/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr.agents;

import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Force;
import com.tyr.Tyr;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;


/**
 * Order a unit to attack toward a target position.
 * @author Simon
 *
 */
public class VesselSupport extends Command
{
	/**
	 * The force which we will support.
	 */
	public Force supportedForce;
	
		/**
	 * Order a unit to attack toward a target position.
	 * @param agent The unit who will attack the enemy.
	 * @param supportedForce The force which we will support.
	 */
	public VesselSupport(Agent agent, Force supportedForce)
	{
		super(agent);
		this.supportedForce = supportedForce;
	}
	
	@Override
	public void execute(Game game, Player self, Tyr bot) 
	{
		agent.drawCircle(Color.Red);
		
		Position target;
		if (supportedForce != null && supportedForce.done())
			supportedForce = null;
		
		if (supportedForce == null || supportedForce.disabled())
		{
			agent.drawCircle(Color.White, 4);
			target = bot.homeGroup.getTarget();
			DebugMessages.addMessage("No force to support!");
		}
		else
			target = supportedForce.getCenter();
		
		if (target != null)
			game.drawLineMap(agent.unit.getX(), agent.unit.getY(), target.getX(), target.getY(), Color.Green);
		
		// Irradiate annoying enemies! :D
		for (Unit enemy : EnemyManager.getEnemyUnits())
		{
			// Not enough energy!
			if (agent.unit.getEnergy() < 75 || !self.hasResearched(TechType.Irradiate))
			{
				agent.drawCircle(Color.Blue, 6);
				break;
			}
			if (enemy.getType() != UnitType.Zerg_Mutalisk && enemy.getType() != UnitType.Zerg_Lurker)
				continue;
			if (enemy.isIrradiated() || enemy.getHitPoints() < 80)
				continue;
			if (agent.distanceSquared(enemy) > 160000)
				continue;
			
			game.drawLineMap(agent.unit.getX(), agent.unit.getY(), enemy.getX(), enemy.getY(), Color.Green);
			agent.unit.useTech(TechType.Irradiate, enemy);
			return;
		}
		
		agent.unit.move(target);
	}
	
	@Override
	public boolean replace(Command command) 
	{
		return true;
	}
}
