/*
* Tyr is an AI for StarCraft: Broodwar, 
* 
* Please visit https://github.com/SimonPrins/Tyr for further information.
* 
* Copyright 2015 Simon Prins
*
* This file is part of Tyr.
* Tyr is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 2 of the License, or
* (at your option) any later version.
* Tyr is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with Tyr.  If not, see http://www.gnu.org/licenses/.
*/


package com.tyr;

import bwapi.Position;


/**
 * Keeps track of a scan.
 * @author Simon
 *
 */
public class ScanEvent 
{
	/**
	 * The position of the scan.
	 */
	public Position pos;
	
	/**
	 * The time at which the scan was done.
	 */
	public int time;
	
	public ScanEvent(Position pos, int time)
	{
		this.pos = pos;
		this.time = time;
	}
	
	/**
	 * Determines whether a position was in range of the scan.
	 * @param position The position for which you want to know if it is in range of the scan.
	 * @return True if the position was in range of the scan, false otherwise.
	 */
	public boolean inRange(Position position)
	{
		return pos.getDistance(position) <= 320;
	}
}
