/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.Bullet;
import bwapi.Color;
import bwapi.Error;
import bwapi.Force;
import bwapi.GameType;
import bwapi.Key;
import bwapi.MouseButton;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.Region;
import bwapi.TechType;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitCommand;
import bwapi.UnitType;
import bwapi.UpgradeType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Game {
    private static Map<Long, Game> instances = new HashMap<Long, Game>();
    private long pointer;

    public List<Force> getForces() {
        return this.getForces_native(this.pointer);
    }

    public List<Player> getPlayers() {
        return this.getPlayers_native(this.pointer);
    }

    public List<Unit> getAllUnits() {
        return this.getAllUnits_native(this.pointer);
    }

    public List<Unit> getMinerals() {
        return this.getMinerals_native(this.pointer);
    }

    public List<Unit> getGeysers() {
        return this.getGeysers_native(this.pointer);
    }

    public List<Unit> getNeutralUnits() {
        return this.getNeutralUnits_native(this.pointer);
    }

    public List<Unit> getStaticMinerals() {
        return this.getStaticMinerals_native(this.pointer);
    }

    public List<Unit> getStaticGeysers() {
        return this.getStaticGeysers_native(this.pointer);
    }

    public List<Unit> getStaticNeutralUnits() {
        return this.getStaticNeutralUnits_native(this.pointer);
    }

    public List<Bullet> getBullets() {
        return this.getBullets_native(this.pointer);
    }

    public List<Position> getNukeDots() {
        return this.getNukeDots_native(this.pointer);
    }

    public Force getForce(int n) {
        return this.getForce_native(this.pointer, n);
    }

    public Player getPlayer(int n) {
        return this.getPlayer_native(this.pointer, n);
    }

    public Unit getUnit(int n) {
        return this.getUnit_native(this.pointer, n);
    }

    public Unit indexToUnit(int n) {
        return this.indexToUnit_native(this.pointer, n);
    }

    public Region getRegion(int n) {
        return this.getRegion_native(this.pointer, n);
    }

    public GameType getGameType() {
        return this.getGameType_native(this.pointer);
    }

    public int getLatency() {
        return this.getLatency_native(this.pointer);
    }

    public int getFrameCount() {
        return this.getFrameCount_native(this.pointer);
    }

    public int getFPS() {
        return this.getFPS_native(this.pointer);
    }

    public double getAverageFPS() {
        return this.getAverageFPS_native(this.pointer);
    }

    public Position getMousePosition() {
        return this.getMousePosition_native(this.pointer);
    }

    public boolean getMouseState(MouseButton mouseButton) {
        return this.getMouseState_native(this.pointer, mouseButton);
    }

    public boolean getMouseState(int n) {
        return this.getMouseState_native(this.pointer, n);
    }

    public boolean getKeyState(Key key) {
        return this.getKeyState_native(this.pointer, key);
    }

    public boolean getKeyState(int n) {
        return this.getKeyState_native(this.pointer, n);
    }

    public Position getScreenPosition() {
        return this.getScreenPosition_native(this.pointer);
    }

    public void setScreenPosition(int n, int n2) {
        this.setScreenPosition_native(this.pointer, n, n2);
    }

    public void setScreenPosition(Position position) {
        this.setScreenPosition_native(this.pointer, position);
    }

    public void pingMinimap(int n, int n2) {
        this.pingMinimap_native(this.pointer, n, n2);
    }

    public void pingMinimap(Position position) {
        this.pingMinimap_native(this.pointer, position);
    }

    public boolean isFlagEnabled(int n) {
        return this.isFlagEnabled_native(this.pointer, n);
    }

    public void enableFlag(int n) {
        this.enableFlag_native(this.pointer, n);
    }

    public List<Unit> getUnitsOnTile(int n, int n2) {
        return this.getUnitsOnTile_native(this.pointer, n, n2);
    }

    public List<Unit> getUnitsInRectangle(int n, int n2, int n3, int n4) {
        return this.getUnitsInRectangle_native(this.pointer, n, n2, n3, n4);
    }

    public List<Unit> getUnitsInRectangle(Position position, Position position2) {
        return this.getUnitsInRectangle_native(this.pointer, position, position2);
    }

    public List<Unit> getUnitsInRadius(Position position, int n) {
        return this.getUnitsInRadius_native(this.pointer, position, n);
    }

    public Error getLastError() {
        return this.getLastError_native(this.pointer);
    }

    public boolean setLastError(Error error) {
        return this.setLastError_native(this.pointer, error);
    }

    public int mapWidth() {
        return this.mapWidth_native(this.pointer);
    }

    public int mapHeight() {
        return this.mapHeight_native(this.pointer);
    }

    public String mapFileName() {
        return this.mapFileName_native(this.pointer);
    }

    public String mapPathName() {
        return this.mapPathName_native(this.pointer);
    }

    public String mapName() {
        return this.mapName_native(this.pointer);
    }

    public String mapHash() {
        return this.mapHash_native(this.pointer);
    }

    public boolean isWalkable(int n, int n2) {
        return this.isWalkable_native(this.pointer, n, n2);
    }

    public boolean isBuildable(int n, int n2) {
        return this.isBuildable_native(this.pointer, n, n2);
    }

    public boolean isBuildable(int n, int n2, boolean bl) {
        return this.isBuildable_native(this.pointer, n, n2, bl);
    }

    public boolean isBuildable(TilePosition tilePosition) {
        return this.isBuildable_native(this.pointer, tilePosition);
    }

    public boolean isBuildable(TilePosition tilePosition, boolean bl) {
        return this.isBuildable_native(this.pointer, tilePosition, bl);
    }

    public boolean isVisible(int n, int n2) {
        return this.isVisible_native(this.pointer, n, n2);
    }

    public boolean isVisible(TilePosition tilePosition) {
        return this.isVisible_native(this.pointer, tilePosition);
    }

    public boolean isExplored(int n, int n2) {
        return this.isExplored_native(this.pointer, n, n2);
    }

    public boolean isExplored(TilePosition tilePosition) {
        return this.isExplored_native(this.pointer, tilePosition);
    }

    public boolean hasCreep(int n, int n2) {
        return this.hasCreep_native(this.pointer, n, n2);
    }

    public boolean hasCreep(TilePosition tilePosition) {
        return this.hasCreep_native(this.pointer, tilePosition);
    }

    public boolean hasPower(int n, int n2) {
        return this.hasPower_native(this.pointer, n, n2);
    }

    public boolean hasPower(int n, int n2, UnitType unitType) {
        return this.hasPower_native(this.pointer, n, n2, unitType);
    }

    public boolean hasPower(TilePosition tilePosition) {
        return this.hasPower_native(this.pointer, tilePosition);
    }

    public boolean hasPower(TilePosition tilePosition, UnitType unitType) {
        return this.hasPower_native(this.pointer, tilePosition, unitType);
    }

    public boolean hasPower(int n, int n2, int n3, int n4) {
        return this.hasPower_native(this.pointer, n, n2, n3, n4);
    }

    public boolean hasPower(int n, int n2, int n3, int n4, UnitType unitType) {
        return this.hasPower_native(this.pointer, n, n2, n3, n4, unitType);
    }

    public boolean hasPower(TilePosition tilePosition, int n, int n2) {
        return this.hasPower_native(this.pointer, tilePosition, n, n2);
    }

    public boolean hasPower(TilePosition tilePosition, int n, int n2, UnitType unitType) {
        return this.hasPower_native(this.pointer, tilePosition, n, n2, unitType);
    }

    public boolean hasPowerPrecise(int n, int n2) {
        return this.hasPowerPrecise_native(this.pointer, n, n2);
    }

    public boolean hasPowerPrecise(int n, int n2, UnitType unitType) {
        return this.hasPowerPrecise_native(this.pointer, n, n2, unitType);
    }

    public boolean hasPowerPrecise(Position position) {
        return this.hasPowerPrecise_native(this.pointer, position);
    }

    public boolean hasPowerPrecise(Position position, UnitType unitType) {
        return this.hasPowerPrecise_native(this.pointer, position, unitType);
    }

    public boolean canBuildHere(Unit unit, TilePosition tilePosition, UnitType unitType) {
        return this.canBuildHere_native(this.pointer, unit, tilePosition, unitType);
    }

    public boolean canBuildHere(Unit unit, TilePosition tilePosition, UnitType unitType, boolean bl) {
        return this.canBuildHere_native(this.pointer, unit, tilePosition, unitType, bl);
    }

    public boolean canMake(Unit unit, UnitType unitType) {
        return this.canMake_native(this.pointer, unit, unitType);
    }

    public boolean canResearch(Unit unit, TechType techType) {
        return this.canResearch_native(this.pointer, unit, techType);
    }

    public boolean canUpgrade(Unit unit, UpgradeType upgradeType) {
        return this.canUpgrade_native(this.pointer, unit, upgradeType);
    }

    public List<TilePosition> getStartLocations() {
        return this.getStartLocations_native(this.pointer);
    }

    public void printf(String string) {
        this.printf_native(this.pointer, string);
    }

    public void sendText(String string) {
        this.sendText_native(this.pointer, string);
    }

    public void sendTextEx(boolean bl, String string) {
        this.sendTextEx_native(this.pointer, bl, string);
    }

    public void changeRace(Race race) {
        this.changeRace_native(this.pointer, race);
    }

    public boolean isInGame() {
        return this.isInGame_native(this.pointer);
    }

    public boolean isMultiplayer() {
        return this.isMultiplayer_native(this.pointer);
    }

    public boolean isBattleNet() {
        return this.isBattleNet_native(this.pointer);
    }

    public boolean isPaused() {
        return this.isPaused_native(this.pointer);
    }

    public boolean isReplay() {
        return this.isReplay_native(this.pointer);
    }

    public void startGame() {
        this.startGame_native(this.pointer);
    }

    public void pauseGame() {
        this.pauseGame_native(this.pointer);
    }

    public void resumeGame() {
        this.resumeGame_native(this.pointer);
    }

    public void leaveGame() {
        this.leaveGame_native(this.pointer);
    }

    public void restartGame() {
        this.restartGame_native(this.pointer);
    }

    public void setLocalSpeed() {
        this.setLocalSpeed_native(this.pointer);
    }

    public void setLocalSpeed(int n) {
        this.setLocalSpeed_native(this.pointer, n);
    }

    public boolean issueCommand(List<Unit> list, UnitCommand unitCommand) {
        return this.issueCommand_native(this.pointer, list, unitCommand);
    }

    public List<Unit> getSelectedUnits() {
        return this.getSelectedUnits_native(this.pointer);
    }

    public Player self() {
        return this.self_native(this.pointer);
    }

    public Player enemy() {
        return this.enemy_native(this.pointer);
    }

    public Player neutral() {
        return this.neutral_native(this.pointer);
    }

    public List<Player> allies() {
        return this.allies_native(this.pointer);
    }

    public List<Player> enemies() {
        return this.enemies_native(this.pointer);
    }

    public List<Player> observers() {
        return this.observers_native(this.pointer);
    }

    public void setTextSize() {
        this.setTextSize_native(this.pointer);
    }

    public void setTextSize(int n) {
        this.setTextSize_native(this.pointer, n);
    }

    public void drawText(int n, int n2, int n3, String string) {
        this.drawText_native(this.pointer, n, n2, n3, string);
    }

    public void drawTextMap(int n, int n2, String string) {
        this.drawTextMap_native(this.pointer, n, n2, string);
    }

    public void drawTextMouse(int n, int n2, String string) {
        this.drawTextMouse_native(this.pointer, n, n2, string);
    }

    public void drawTextScreen(int n, int n2, String string) {
        this.drawTextScreen_native(this.pointer, n, n2, string);
    }

    public void drawBox(int n, int n2, int n3, int n4, int n5, Color color) {
        this.drawBox_native(this.pointer, n, n2, n3, n4, n5, color);
    }

    public void drawBox(int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        this.drawBox_native(this.pointer, n, n2, n3, n4, n5, color, bl);
    }

    public void drawBoxMap(int n, int n2, int n3, int n4, Color color) {
        this.drawBoxMap_native(this.pointer, n, n2, n3, n4, color);
    }

    public void drawBoxMap(int n, int n2, int n3, int n4, Color color, boolean bl) {
        this.drawBoxMap_native(this.pointer, n, n2, n3, n4, color, bl);
    }

    public void drawBoxMouse(int n, int n2, int n3, int n4, Color color) {
        this.drawBoxMouse_native(this.pointer, n, n2, n3, n4, color);
    }

    public void drawBoxMouse(int n, int n2, int n3, int n4, Color color, boolean bl) {
        this.drawBoxMouse_native(this.pointer, n, n2, n3, n4, color, bl);
    }

    public void drawBoxScreen(int n, int n2, int n3, int n4, Color color) {
        this.drawBoxScreen_native(this.pointer, n, n2, n3, n4, color);
    }

    public void drawBoxScreen(int n, int n2, int n3, int n4, Color color, boolean bl) {
        this.drawBoxScreen_native(this.pointer, n, n2, n3, n4, color, bl);
    }

    public void drawTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color) {
        this.drawTriangle_native(this.pointer, n, n2, n3, n4, n5, n6, n7, color);
    }

    public void drawTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7, Color color, boolean bl) {
        this.drawTriangle_native(this.pointer, n, n2, n3, n4, n5, n6, n7, color, bl);
    }

    public void drawTriangleMap(int n, int n2, int n3, int n4, int n5, int n6, Color color) {
        this.drawTriangleMap_native(this.pointer, n, n2, n3, n4, n5, n6, color);
    }

    public void drawTriangleMap(int n, int n2, int n3, int n4, int n5, int n6, Color color, boolean bl) {
        this.drawTriangleMap_native(this.pointer, n, n2, n3, n4, n5, n6, color, bl);
    }

    public void drawTriangleMouse(int n, int n2, int n3, int n4, int n5, int n6, Color color) {
        this.drawTriangleMouse_native(this.pointer, n, n2, n3, n4, n5, n6, color);
    }

    public void drawTriangleMouse(int n, int n2, int n3, int n4, int n5, int n6, Color color, boolean bl) {
        this.drawTriangleMouse_native(this.pointer, n, n2, n3, n4, n5, n6, color, bl);
    }

    public void drawTriangleScreen(int n, int n2, int n3, int n4, int n5, int n6, Color color) {
        this.drawTriangleScreen_native(this.pointer, n, n2, n3, n4, n5, n6, color);
    }

    public void drawTriangleScreen(int n, int n2, int n3, int n4, int n5, int n6, Color color, boolean bl) {
        this.drawTriangleScreen_native(this.pointer, n, n2, n3, n4, n5, n6, color, bl);
    }

    public void drawCircle(int n, int n2, int n3, int n4, Color color) {
        this.drawCircle_native(this.pointer, n, n2, n3, n4, color);
    }

    public void drawCircle(int n, int n2, int n3, int n4, Color color, boolean bl) {
        this.drawCircle_native(this.pointer, n, n2, n3, n4, color, bl);
    }

    public void drawCircleMap(int n, int n2, int n3, Color color) {
        this.drawCircleMap_native(this.pointer, n, n2, n3, color);
    }

    public void drawCircleMap(int n, int n2, int n3, Color color, boolean bl) {
        this.drawCircleMap_native(this.pointer, n, n2, n3, color, bl);
    }

    public void drawCircleMouse(int n, int n2, int n3, Color color) {
        this.drawCircleMouse_native(this.pointer, n, n2, n3, color);
    }

    public void drawCircleMouse(int n, int n2, int n3, Color color, boolean bl) {
        this.drawCircleMouse_native(this.pointer, n, n2, n3, color, bl);
    }

    public void drawCircleScreen(int n, int n2, int n3, Color color) {
        this.drawCircleScreen_native(this.pointer, n, n2, n3, color);
    }

    public void drawCircleScreen(int n, int n2, int n3, Color color, boolean bl) {
        this.drawCircleScreen_native(this.pointer, n, n2, n3, color, bl);
    }

    public void drawEllipse(int n, int n2, int n3, int n4, int n5, Color color) {
        this.drawEllipse_native(this.pointer, n, n2, n3, n4, n5, color);
    }

    public void drawEllipse(int n, int n2, int n3, int n4, int n5, Color color, boolean bl) {
        this.drawEllipse_native(this.pointer, n, n2, n3, n4, n5, color, bl);
    }

    public void drawEllipseMap(int n, int n2, int n3, int n4, Color color) {
        this.drawEllipseMap_native(this.pointer, n, n2, n3, n4, color);
    }

    public void drawEllipseMap(int n, int n2, int n3, int n4, Color color, boolean bl) {
        this.drawEllipseMap_native(this.pointer, n, n2, n3, n4, color, bl);
    }

    public void drawEllipseMouse(int n, int n2, int n3, int n4, Color color) {
        this.drawEllipseMouse_native(this.pointer, n, n2, n3, n4, color);
    }

    public void drawEllipseMouse(int n, int n2, int n3, int n4, Color color, boolean bl) {
        this.drawEllipseMouse_native(this.pointer, n, n2, n3, n4, color, bl);
    }

    public void drawEllipseScreen(int n, int n2, int n3, int n4, Color color) {
        this.drawEllipseScreen_native(this.pointer, n, n2, n3, n4, color);
    }

    public void drawEllipseScreen(int n, int n2, int n3, int n4, Color color, boolean bl) {
        this.drawEllipseScreen_native(this.pointer, n, n2, n3, n4, color, bl);
    }

    public void drawDot(int n, int n2, int n3, Color color) {
        this.drawDot_native(this.pointer, n, n2, n3, color);
    }

    public void drawDotMap(int n, int n2, Color color) {
        this.drawDotMap_native(this.pointer, n, n2, color);
    }

    public void drawDotMouse(int n, int n2, Color color) {
        this.drawDotMouse_native(this.pointer, n, n2, color);
    }

    public void drawDotScreen(int n, int n2, Color color) {
        this.drawDotScreen_native(this.pointer, n, n2, color);
    }

    public void drawLine(int n, int n2, int n3, int n4, int n5, Color color) {
        this.drawLine_native(this.pointer, n, n2, n3, n4, n5, color);
    }

    public void drawLineMap(int n, int n2, int n3, int n4, Color color) {
        this.drawLineMap_native(this.pointer, n, n2, n3, n4, color);
    }

    public void drawLineMouse(int n, int n2, int n3, int n4, Color color) {
        this.drawLineMouse_native(this.pointer, n, n2, n3, n4, color);
    }

    public void drawLineScreen(int n, int n2, int n3, int n4, Color color) {
        this.drawLineScreen_native(this.pointer, n, n2, n3, n4, color);
    }

    public void getScreenBuffer() {
        this.getScreenBuffer_native(this.pointer);
    }

    public int getLatencyFrames() {
        return this.getLatencyFrames_native(this.pointer);
    }

    public int getLatencyTime() {
        return this.getLatencyTime_native(this.pointer);
    }

    public int getRemainingLatencyFrames() {
        return this.getRemainingLatencyFrames_native(this.pointer);
    }

    public int getRemainingLatencyTime() {
        return this.getRemainingLatencyTime_native(this.pointer);
    }

    public int getRevision() {
        return this.getRevision_native(this.pointer);
    }

    public boolean isDebug() {
        return this.isDebug_native(this.pointer);
    }

    public boolean isLatComEnabled() {
        return this.isLatComEnabled_native(this.pointer);
    }

    public void setLatCom(boolean bl) {
        this.setLatCom_native(this.pointer, bl);
    }

    public int getReplayFrameCount() {
        return this.getReplayFrameCount_native(this.pointer);
    }

    public void setGUI() {
        this.setGUI_native(this.pointer);
    }

    public void setGUI(boolean bl) {
        this.setGUI_native(this.pointer, bl);
    }

    public int getAPM() {
        return this.getAPM_native(this.pointer);
    }

    public int getAPM(boolean bl) {
        return this.getAPM_native(this.pointer, bl);
    }

    public boolean setMap(String string) {
        return this.setMap_native(this.pointer, string);
    }

    public void setFrameSkip() {
        this.setFrameSkip_native(this.pointer);
    }

    public void setFrameSkip(int n) {
        this.setFrameSkip_native(this.pointer, n);
    }

    public boolean hasPath(Position position, Position position2) {
        return this.hasPath_native(this.pointer, position, position2);
    }

    public boolean setAlliance(Player player, boolean bl) {
        return this.setAlliance_native(this.pointer, player, bl);
    }

    public boolean setAlliance(Player player) {
        return this.setAlliance_native(this.pointer, player);
    }

    public boolean setAlliance(Player player, boolean bl, boolean bl2) {
        return this.setAlliance_native(this.pointer, player, bl, bl2);
    }

    public boolean setVision(Player player) {
        return this.setVision_native(this.pointer, player);
    }

    public boolean setVision(Player player, boolean bl) {
        return this.setVision_native(this.pointer, player, bl);
    }

    public void setCommandOptimizationLevel() {
        this.setCommandOptimizationLevel_native(this.pointer);
    }

    public void setCommandOptimizationLevel(int n) {
        this.setCommandOptimizationLevel_native(this.pointer, n);
    }

    public Region getRegionAt(int n, int n2) {
        return this.getRegionAt_native(this.pointer, n, n2);
    }

    public Region getRegionAt(Position position) {
        return this.getRegionAt_native(this.pointer, position);
    }

    public int getLastEventTime() {
        return this.getLastEventTime_native(this.pointer);
    }

    public boolean setReplayVision(Player player) {
        return this.setReplayVision_native(this.pointer, player);
    }

    public boolean setReplayVision(Player player, boolean bl) {
        return this.setReplayVision_native(this.pointer, player, bl);
    }

    public boolean setRevealAll() {
        return this.setRevealAll_native(this.pointer);
    }

    public boolean setRevealAll(boolean bl) {
        return this.setRevealAll_native(this.pointer, bl);
    }

    private Game(long l) {
        this.pointer = l;
    }

    private static Game get(long l) {
        if (l == 0L) {
            return null;
        }
        Game game = instances.get(l);
        if (game == null) {
            game = new Game(l);
            instances.put(l, game);
        }
        return game;
    }

    private native List<Force> getForces_native(long var1);

    private native List<Player> getPlayers_native(long var1);

    private native List<Unit> getAllUnits_native(long var1);

    private native List<Unit> getMinerals_native(long var1);

    private native List<Unit> getGeysers_native(long var1);

    private native List<Unit> getNeutralUnits_native(long var1);

    private native List<Unit> getStaticMinerals_native(long var1);

    private native List<Unit> getStaticGeysers_native(long var1);

    private native List<Unit> getStaticNeutralUnits_native(long var1);

    private native List<Bullet> getBullets_native(long var1);

    private native List<Position> getNukeDots_native(long var1);

    private native Force getForce_native(long var1, int var3);

    private native Player getPlayer_native(long var1, int var3);

    private native Unit getUnit_native(long var1, int var3);

    private native Unit indexToUnit_native(long var1, int var3);

    private native Region getRegion_native(long var1, int var3);

    private native GameType getGameType_native(long var1);

    private native int getLatency_native(long var1);

    private native int getFrameCount_native(long var1);

    private native int getFPS_native(long var1);

    private native double getAverageFPS_native(long var1);

    private native Position getMousePosition_native(long var1);

    private native boolean getMouseState_native(long var1, MouseButton var3);

    private native boolean getMouseState_native(long var1, int var3);

    private native boolean getKeyState_native(long var1, Key var3);

    private native boolean getKeyState_native(long var1, int var3);

    private native Position getScreenPosition_native(long var1);

    private native void setScreenPosition_native(long var1, int var3, int var4);

    private native void setScreenPosition_native(long var1, Position var3);

    private native void pingMinimap_native(long var1, int var3, int var4);

    private native void pingMinimap_native(long var1, Position var3);

    private native boolean isFlagEnabled_native(long var1, int var3);

    private native void enableFlag_native(long var1, int var3);

    private native List<Unit> getUnitsOnTile_native(long var1, int var3, int var4);

    private native List<Unit> getUnitsInRectangle_native(long var1, int var3, int var4, int var5, int var6);

    private native List<Unit> getUnitsInRectangle_native(long var1, Position var3, Position var4);

    private native List<Unit> getUnitsInRadius_native(long var1, Position var3, int var4);

    private native Error getLastError_native(long var1);

    private native boolean setLastError_native(long var1, Error var3);

    private native int mapWidth_native(long var1);

    private native int mapHeight_native(long var1);

    private native String mapFileName_native(long var1);

    private native String mapPathName_native(long var1);

    private native String mapName_native(long var1);

    private native String mapHash_native(long var1);

    private native boolean isWalkable_native(long var1, int var3, int var4);

    private native boolean isBuildable_native(long var1, int var3, int var4);

    private native boolean isBuildable_native(long var1, int var3, int var4, boolean var5);

    private native boolean isBuildable_native(long var1, TilePosition var3);

    private native boolean isBuildable_native(long var1, TilePosition var3, boolean var4);

    private native boolean isVisible_native(long var1, int var3, int var4);

    private native boolean isVisible_native(long var1, TilePosition var3);

    private native boolean isExplored_native(long var1, int var3, int var4);

    private native boolean isExplored_native(long var1, TilePosition var3);

    private native boolean hasCreep_native(long var1, int var3, int var4);

    private native boolean hasCreep_native(long var1, TilePosition var3);

    private native boolean hasPower_native(long var1, int var3, int var4);

    private native boolean hasPower_native(long var1, int var3, int var4, UnitType var5);

    private native boolean hasPower_native(long var1, TilePosition var3);

    private native boolean hasPower_native(long var1, TilePosition var3, UnitType var4);

    private native boolean hasPower_native(long var1, int var3, int var4, int var5, int var6);

    private native boolean hasPower_native(long var1, int var3, int var4, int var5, int var6, UnitType var7);

    private native boolean hasPower_native(long var1, TilePosition var3, int var4, int var5);

    private native boolean hasPower_native(long var1, TilePosition var3, int var4, int var5, UnitType var6);

    private native boolean hasPowerPrecise_native(long var1, int var3, int var4);

    private native boolean hasPowerPrecise_native(long var1, int var3, int var4, UnitType var5);

    private native boolean hasPowerPrecise_native(long var1, Position var3);

    private native boolean hasPowerPrecise_native(long var1, Position var3, UnitType var4);

    private native boolean canBuildHere_native(long var1, Unit var3, TilePosition var4, UnitType var5);

    private native boolean canBuildHere_native(long var1, Unit var3, TilePosition var4, UnitType var5, boolean var6);

    private native boolean canMake_native(long var1, Unit var3, UnitType var4);

    private native boolean canResearch_native(long var1, Unit var3, TechType var4);

    private native boolean canUpgrade_native(long var1, Unit var3, UpgradeType var4);

    private native List<TilePosition> getStartLocations_native(long var1);

    private native void printf_native(long var1, String var3);

    private native void sendText_native(long var1, String var3);

    private native void sendTextEx_native(long var1, boolean var3, String var4);

    private native void changeRace_native(long var1, Race var3);

    private native boolean isInGame_native(long var1);

    private native boolean isMultiplayer_native(long var1);

    private native boolean isBattleNet_native(long var1);

    private native boolean isPaused_native(long var1);

    private native boolean isReplay_native(long var1);

    private native void startGame_native(long var1);

    private native void pauseGame_native(long var1);

    private native void resumeGame_native(long var1);

    private native void leaveGame_native(long var1);

    private native void restartGame_native(long var1);

    private native void setLocalSpeed_native(long var1);

    private native void setLocalSpeed_native(long var1, int var3);

    private native boolean issueCommand_native(long var1, List<Unit> var3, UnitCommand var4);

    private native List<Unit> getSelectedUnits_native(long var1);

    private native Player self_native(long var1);

    private native Player enemy_native(long var1);

    private native Player neutral_native(long var1);

    private native List<Player> allies_native(long var1);

    private native List<Player> enemies_native(long var1);

    private native List<Player> observers_native(long var1);

    private native void setTextSize_native(long var1);

    private native void setTextSize_native(long var1, int var3);

    private native void drawText_native(long var1, int var3, int var4, int var5, String var6);

    private native void drawTextMap_native(long var1, int var3, int var4, String var5);

    private native void drawTextMouse_native(long var1, int var3, int var4, String var5);

    private native void drawTextScreen_native(long var1, int var3, int var4, String var5);

    private native void drawBox_native(long var1, int var3, int var4, int var5, int var6, int var7, Color var8);

    private native void drawBox_native(long var1, int var3, int var4, int var5, int var6, int var7, Color var8, boolean var9);

    private native void drawBoxMap_native(long var1, int var3, int var4, int var5, int var6, Color var7);

    private native void drawBoxMap_native(long var1, int var3, int var4, int var5, int var6, Color var7, boolean var8);

    private native void drawBoxMouse_native(long var1, int var3, int var4, int var5, int var6, Color var7);

    private native void drawBoxMouse_native(long var1, int var3, int var4, int var5, int var6, Color var7, boolean var8);

    private native void drawBoxScreen_native(long var1, int var3, int var4, int var5, int var6, Color var7);

    private native void drawBoxScreen_native(long var1, int var3, int var4, int var5, int var6, Color var7, boolean var8);

    private native void drawTriangle_native(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, Color var10);

    private native void drawTriangle_native(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9, Color var10, boolean var11);

    private native void drawTriangleMap_native(long var1, int var3, int var4, int var5, int var6, int var7, int var8, Color var9);

    private native void drawTriangleMap_native(long var1, int var3, int var4, int var5, int var6, int var7, int var8, Color var9, boolean var10);

    private native void drawTriangleMouse_native(long var1, int var3, int var4, int var5, int var6, int var7, int var8, Color var9);

    private native void drawTriangleMouse_native(long var1, int var3, int var4, int var5, int var6, int var7, int var8, Color var9, boolean var10);

    private native void drawTriangleScreen_native(long var1, int var3, int var4, int var5, int var6, int var7, int var8, Color var9);

    private native void drawTriangleScreen_native(long var1, int var3, int var4, int var5, int var6, int var7, int var8, Color var9, boolean var10);

    private native void drawCircle_native(long var1, int var3, int var4, int var5, int var6, Color var7);

    private native void drawCircle_native(long var1, int var3, int var4, int var5, int var6, Color var7, boolean var8);

    private native void drawCircleMap_native(long var1, int var3, int var4, int var5, Color var6);

    private native void drawCircleMap_native(long var1, int var3, int var4, int var5, Color var6, boolean var7);

    private native void drawCircleMouse_native(long var1, int var3, int var4, int var5, Color var6);

    private native void drawCircleMouse_native(long var1, int var3, int var4, int var5, Color var6, boolean var7);

    private native void drawCircleScreen_native(long var1, int var3, int var4, int var5, Color var6);

    private native void drawCircleScreen_native(long var1, int var3, int var4, int var5, Color var6, boolean var7);

    private native void drawEllipse_native(long var1, int var3, int var4, int var5, int var6, int var7, Color var8);

    private native void drawEllipse_native(long var1, int var3, int var4, int var5, int var6, int var7, Color var8, boolean var9);

    private native void drawEllipseMap_native(long var1, int var3, int var4, int var5, int var6, Color var7);

    private native void drawEllipseMap_native(long var1, int var3, int var4, int var5, int var6, Color var7, boolean var8);

    private native void drawEllipseMouse_native(long var1, int var3, int var4, int var5, int var6, Color var7);

    private native void drawEllipseMouse_native(long var1, int var3, int var4, int var5, int var6, Color var7, boolean var8);

    private native void drawEllipseScreen_native(long var1, int var3, int var4, int var5, int var6, Color var7);

    private native void drawEllipseScreen_native(long var1, int var3, int var4, int var5, int var6, Color var7, boolean var8);

    private native void drawDot_native(long var1, int var3, int var4, int var5, Color var6);

    private native void drawDotMap_native(long var1, int var3, int var4, Color var5);

    private native void drawDotMouse_native(long var1, int var3, int var4, Color var5);

    private native void drawDotScreen_native(long var1, int var3, int var4, Color var5);

    private native void drawLine_native(long var1, int var3, int var4, int var5, int var6, int var7, Color var8);

    private native void drawLineMap_native(long var1, int var3, int var4, int var5, int var6, Color var7);

    private native void drawLineMouse_native(long var1, int var3, int var4, int var5, int var6, Color var7);

    private native void drawLineScreen_native(long var1, int var3, int var4, int var5, int var6, Color var7);

    private native void getScreenBuffer_native(long var1);

    private native int getLatencyFrames_native(long var1);

    private native int getLatencyTime_native(long var1);

    private native int getRemainingLatencyFrames_native(long var1);

    private native int getRemainingLatencyTime_native(long var1);

    private native int getRevision_native(long var1);

    private native boolean isDebug_native(long var1);

    private native boolean isLatComEnabled_native(long var1);

    private native void setLatCom_native(long var1, boolean var3);

    private native int getReplayFrameCount_native(long var1);

    private native void setGUI_native(long var1);

    private native void setGUI_native(long var1, boolean var3);

    private native int getAPM_native(long var1);

    private native int getAPM_native(long var1, boolean var3);

    private native boolean setMap_native(long var1, String var3);

    private native void setFrameSkip_native(long var1);

    private native void setFrameSkip_native(long var1, int var3);

    private native boolean hasPath_native(long var1, Position var3, Position var4);

    private native boolean setAlliance_native(long var1, Player var3, boolean var4);

    private native boolean setAlliance_native(long var1, Player var3);

    private native boolean setAlliance_native(long var1, Player var3, boolean var4, boolean var5);

    private native boolean setVision_native(long var1, Player var3);

    private native boolean setVision_native(long var1, Player var3, boolean var4);

    private native void setCommandOptimizationLevel_native(long var1);

    private native void setCommandOptimizationLevel_native(long var1, int var3);

    private native Region getRegionAt_native(long var1, int var3, int var4);

    private native Region getRegionAt_native(long var1, Position var3);

    private native int getLastEventTime_native(long var1);

    private native boolean setReplayVision_native(long var1, Player var3);

    private native boolean setReplayVision_native(long var1, Player var3, boolean var4);

    private native boolean setRevealAll_native(long var1);

    private native boolean setRevealAll_native(long var1, boolean var3);
}

