/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.unitgroups.UnitGroup;

public class ZealotDropGroup
extends UnitGroup {
    private Agent shuttle;
    private Position target;
    private Unit killTarget;
    public int attackMode = 0;
    public static final int KILL_TANKS = 0;
    public static final int ATTACK_BASE = 1;

    public ZealotDropGroup() {
        super(Tyr.bot.hobos);
    }

    public ZealotDropGroup(int attackMode) {
        super(Tyr.bot.hobos);
        this.attackMode = attackMode;
    }

    public void setTarget(Position target) {
        this.target = target;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.shuttle != null && this.shuttle.isDead()) {
            this.shuttle = null;
        }
        if (this.shuttle == null) {
            for (Agent agent : this.units) {
                if (agent.unit.getType() != UnitType.Protoss_Shuttle) continue;
                this.shuttle = agent;
            }
        }
        if (this.attackMode == 0) {
            this.killTanks();
        } else if (this.attackMode == 1) {
            this.modeAttackBase();
        }
    }

    private void killTanks() {
        if (this.killTarget != null && (Agent.isDead(this.killTarget) || this.killTarget.getType() != UnitType.Terran_Siege_Tank_Siege_Mode)) {
            this.killTarget = null;
        }
        if (this.killTarget == null) {
            int dist = 160000;
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (enemy.getType() != UnitType.Terran_Siege_Tank_Siege_Mode) continue;
                int newDist = 1000000;
                for (Agent agent : this.units) {
                    int agentEnemyDist = agent.distanceSquared(enemy);
                    if (agentEnemyDist >= newDist) continue;
                    newDist = agentEnemyDist;
                }
                if (newDist >= dist) continue;
                this.killTarget = enemy;
                dist = newDist;
            }
        }
        if (this.killTarget != null) {
            this.attack();
        } else {
            this.move();
        }
    }

    private void modeAttackBase() {
        if (this.killTarget != null && Agent.isDead(this.killTarget)) {
            this.killTarget = null;
        }
        if (this.killTarget == null) {
            int dist = 160000;
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (!enemy.getType().isResourceDepot()) continue;
                int newDist = 1000000;
                for (Agent agent : this.units) {
                    int agentEnemyDist = agent.distanceSquared(enemy);
                    if (agentEnemyDist >= newDist) continue;
                    newDist = agentEnemyDist;
                }
                if (newDist >= dist) continue;
                this.killTarget = enemy;
                newDist = dist;
            }
        }
        if (this.killTarget != null) {
            this.attackBase();
        } else {
            this.move();
        }
    }

    public void attackBase() {
        int dist = this.shuttle.distanceSquared(this.killTarget);
        if (this.shuttle != null && dist <= 22500) {
            this.shuttle.move(Tyr.getStartLocation());
        }
        boolean unloading = false;
        if (this.shuttle != null && dist <= 160000 && dist > 22500) {
            for (Agent agent : this.units) {
                if (!agent.unit.isLoaded()) continue;
                this.shuttle.unit.unload(agent.unit);
                unloading = true;
                break;
            }
        }
        if (!unloading && this.shuttle != null && dist > 22500) {
            Tyr.game.drawLineMap(this.killTarget.getPosition(), this.shuttle.unit.getPosition(), Color.Red);
            this.shuttle.move(this.killTarget.getPosition());
        }
        for (Agent agent : this.units) {
            if (agent.unit.isLoaded() || agent == this.shuttle) continue;
            agent.attack(this.killTarget.getPosition());
        }
    }

    public void attack() {
        boolean unloading = false;
        if (this.shuttle != null && this.shuttle.distanceSquared(this.killTarget) <= 10000) {
            for (Agent agent : this.units) {
                if (!agent.unit.isLoaded()) continue;
                this.shuttle.unit.unload(agent.unit);
                unloading = true;
                break;
            }
        }
        if (!unloading && this.shuttle != null) {
            Tyr.game.drawLineMap(this.killTarget.getPosition(), this.shuttle.unit.getPosition(), Color.Red);
            this.shuttle.move(this.killTarget.getPosition());
        }
        for (Agent agent : this.units) {
            if (agent == this.shuttle || agent.unit.isLoaded()) continue;
            Tyr.game.drawLineMap(this.killTarget.getPosition(), agent.unit.getPosition(), Color.Red);
            agent.attack(this.killTarget);
        }
    }

    public void move() {
        boolean loaded = this.shuttle != null;
        for (Agent agent : this.units) {
            if (agent == this.shuttle || agent.unit.isLoaded()) continue;
            loaded = false;
            break;
        }
        if (loaded) {
            this.shuttle.move(this.target);
            return;
        }
        if (this.shuttle == null) {
            for (Agent agent : this.units) {
                Tyr.game.drawLineMap(Tyr.getStartLocation(), agent.unit.getPosition(), Color.Green);
                agent.move(Tyr.getStartLocation());
            }
            return;
        }
        boolean loading = false;
        for (Agent agent : this.units) {
            if (agent == this.shuttle || agent.unit.isLoaded()) continue;
            if (loading) {
                Tyr.game.drawLineMap(agent.unit.getPosition(), this.shuttle.unit.getPosition(), Color.Blue);
                agent.move(this.shuttle.unit.getPosition());
                continue;
            }
            loading = true;
            if (agent.distanceSquared(this.shuttle) >= 10000) {
                agent.unit.move(this.shuttle.unit.getPosition());
            }
            Tyr.game.drawLineMap(agent.unit.getPosition(), this.shuttle.unit.getPosition(), Color.Green);
            this.shuttle.unit.load(agent.unit);
        }
    }

    public boolean needsShuttle() {
        return this.shuttle == null;
    }

    public int getZealots() {
        int result = 0;
        for (Agent agent : this.units) {
            if (agent.unit.getType() != UnitType.Protoss_Zealot) continue;
            ++result;
        }
        return result;
    }

    public Agent getShuttle() {
        return this.shuttle;
    }
}

