/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TilePosition;
import com.tyr.BWTAProxy;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.DefensiveTank;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.UnitGroup;

public class TankDefense
extends UnitGroup {
    Position target = null;
    public int defensiveTanks = 2;

    public TankDefense(OutOfJob rejects, Position target) {
        super(rejects);
        this.target = target;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        if (this.target == null && bot.defensiveStructures.get((int)0).defences.size() > 0) {
            this.target = bot.defensiveStructures.get((int)0).defences.get(0).getPosition();
        } else if (this.target == null) {
            this.target = Settings.getRallyPoint();
        }
        if (this.target == null) {
            this.target = SpaceManager.getMainExit();
        }
        for (Agent agent : this.units) {
            if (agent.getCommand().getClass() == DefensiveTank.class) continue;
            agent.order(new DefensiveTank(agent, this.getPosition(Tyr.positionToTile(this.target))));
        }
    }

    private Position getPosition(TilePosition aroundTile) {
        if (!BWTAProxy.initialized) {
            return Tyr.tileToPosition(aroundTile);
        }
        int dist = 0;
        while (dist < 10) {
            int i = -dist;
            while (i <= dist) {
                if (this.checkTile(new TilePosition(aroundTile.getX() + i, aroundTile.getY() - dist))) {
                    return Tyr.tileToPosition(new TilePosition(aroundTile.getX() + i, aroundTile.getY() - dist));
                }
                if (this.checkTile(new TilePosition(aroundTile.getX() - dist, aroundTile.getY() + i))) {
                    return Tyr.tileToPosition(new TilePosition(aroundTile.getX() - dist, aroundTile.getY() + i));
                }
                if (this.checkTile(new TilePosition(aroundTile.getX() + i, aroundTile.getY() + dist))) {
                    return Tyr.tileToPosition(new TilePosition(aroundTile.getX() + i, aroundTile.getY() + dist));
                }
                if (this.checkTile(new TilePosition(aroundTile.getX() + dist, aroundTile.getY() + i))) {
                    return Tyr.tileToPosition(new TilePosition(aroundTile.getX() + dist, aroundTile.getY() + i));
                }
                ++i;
            }
            ++dist;
        }
        return Tyr.tileToPosition(aroundTile);
    }

    private boolean checkTile(TilePosition pos) {
        for (DefensiveStructures structures : Tyr.bot.defensiveStructures) {
            for (Agent tank : structures.tanks.units) {
                if (tank.getCommand().getClass() != DefensiveTank.class) continue;
                DefensiveTank defensive = (DefensiveTank)tank.getCommand();
                TilePosition defendedTile = Tyr.positionToTile(defensive.target);
                if (Math.abs(defendedTile.getX() - pos.getX()) > 1 || Math.abs(defendedTile.getY() - pos.getY()) > 1) continue;
                return false;
            }
        }
        int dx = -1;
        while (dx <= 1) {
            int dy = -1;
            while (dy <= 1) {
                if (pos.getX() + dx < 0 || pos.getY() + dy < 0 || pos.getX() + dx >= Tyr.game.mapWidth() || pos.getY() + dy >= Tyr.game.mapHeight() || Tyr.bot.spaceManager.map[pos.getX() + dx][pos.getY() + dy] != 1) {
                    return false;
                }
                ++dy;
            }
            ++dx;
        }
        return true;
    }

    @Override
    public void add(Agent agent) {
        super.add(agent);
    }

    public void disable() {
        this.defensiveTanks = 0;
        while (this.units.size() > 0) {
            Agent agent = (Agent)this.units.get(this.units.size() - 1);
            this.units.remove(this.units.size() - 1);
            this.rejects.add(agent);
        }
    }
}

