/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.ScanEvent;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.UnitGroup;
import java.util.ArrayList;

public class ComsatNetwork
extends UnitGroup {
    ArrayList<ScanEvent> scanEvents = new ArrayList();

    public ComsatNetwork(OutOfJob rejects) {
        super(rejects);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        Position target = null;
        int i = 0;
        while (i < this.scanEvents.size()) {
            if (game.getFrameCount() - this.scanEvents.get((int)i).time >= 225) {
                this.scanEvents.remove(i);
                --i;
            } else {
                Tyr.drawCircle(this.scanEvents.get((int)i).pos, Color.Orange, 320);
            }
            ++i;
        }
        Unit scannee = null;
        for (Unit enemy : EnemyManager.getEnemyUnits()) {
            if (enemy.isDetected()) continue;
            Tyr.drawCircle(enemy.getPosition(), Color.Orange);
        }
        for (Unit enemy : EnemyManager.getEnemyUnits()) {
            if (enemy.isDetected() || enemy.getType() == UnitType.Protoss_Observer) continue;
            boolean alreadyScanned = false;
            for (ScanEvent event : this.scanEvents) {
                if (!event.inRange(enemy.getPosition())) continue;
                alreadyScanned = true;
            }
            if (alreadyScanned) continue;
            target = enemy.getPosition();
            scannee = enemy;
            break;
        }
        if (target != null) {
            if (target.getX() >= game.mapWidth() * 32 - 128 && target.getY() >= game.mapWidth() * 32 - 128) {
                System.out.println("Error, non existant unit?");
                System.out.println("Unit type: " + scannee.getType());
                System.out.println("Position: (" + target.getX() + ", " + target.getY() + ")");
                DebugMessages.addMessage("Scanner error: " + scannee.getType() + " (" + target.getX() + ", " + target.getY() + ")");
                return;
            }
            for (Agent myUnit : this.units) {
                if (myUnit.unit.getEnergy() <= 50 || !myUnit.unit.isCompleted()) continue;
                this.scanEvents.add(new ScanEvent(target, game.getFrameCount()));
                myUnit.unit.useTech(TechType.Scanner_Sweep, target);
                break;
            }
        }
    }

    @Override
    public int takeAgent(Agent agent) {
        if (agent.unit.getType() == UnitType.Terran_Comsat_Station) {
            return 10;
        }
        return -1;
    }
}

