/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.unitgroups;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import com.tyr.BWTAProxy;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.BCAttack;
import com.tyr.agents.BCDefend;
import com.tyr.agents.None;
import com.tyr.unitgroups.OutOfJob;
import com.tyr.unitgroups.UnitGroup;

public class BCSquad
extends UnitGroup {
    boolean attackMode = false;
    boolean retreatMode = false;
    public Position target = null;
    public static int fleeMinimum = 3;
    public static int moveOutMinimum = 6;
    public static int maximum = 8;

    public BCSquad(OutOfJob rejects) {
        super(rejects);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        block33: {
            block32: {
                boolean attack;
                if (BWTAProxy.initialized && this.units.size() > 0 && this.target == null) {
                    this.getDefenseTarget();
                }
                boolean defend = EnemyManager.getManager().getInvader() != null;
                boolean bl = attack = EnemyManager.getManager().getInvader() == null && this.units.size() >= moveOutMinimum;
                if (attack) {
                    for (Agent agent : this.units) {
                        if (agent.unit.getHitPoints() >= agent.unit.getType().maxHitPoints()) continue;
                        attack = false;
                        break;
                    }
                }
                if (defend) {
                    for (Agent agent : this.units) {
                        Tyr.drawCircle(agent.unit.getPosition(), Color.Green, 32);
                    }
                } else if (!this.attackMode && !this.retreatMode) {
                    for (Agent agent : this.units) {
                        Tyr.drawCircle(agent.unit.getPosition(), Color.Yellow, 32);
                    }
                } else if (this.retreatMode) {
                    for (Agent agent : this.units) {
                        Tyr.drawCircle(agent.unit.getPosition(), Color.White, 32);
                    }
                } else if (this.attackMode) {
                    for (Agent agent : this.units) {
                        Tyr.drawCircle(agent.unit.getPosition(), Color.Red, 32);
                    }
                }
                if (this.attackMode) {
                    if (this.units.size() < fleeMinimum) {
                        this.attackMode = false;
                        this.retreatMode = true;
                        this.getDefenseTarget();
                    } else {
                        for (Agent unit : this.units) {
                            if (unit.unit.getHitPoints() > 125) continue;
                            this.attackMode = false;
                            this.retreatMode = true;
                            this.getDefenseTarget();
                        }
                    }
                }
                if (this.retreatMode) {
                    if (this.target != null) {
                        Tyr.drawCircle(this.target, Color.Blue, 160);
                    }
                    boolean returned = true;
                    for (Agent agent : this.units) {
                        agent.order(new None(agent));
                        if (this.target != null && agent.distanceSquared(this.target) >= 40000) {
                            returned = false;
                            Tyr.drawCircle(agent.unit.getPosition(), Color.Red, 6);
                            game.drawLineMap(this.target.getX(), this.target.getY(), agent.unit.getX(), agent.unit.getY(), Color.Red);
                            continue;
                        }
                        Tyr.drawCircle(agent.unit.getPosition(), Color.Green, 6);
                    }
                    if (returned) {
                        this.retreatMode = false;
                    } else {
                        for (Agent agent : this.units) {
                            agent.drawCircle(Color.White);
                            agent.unit.move(this.target);
                        }
                        return;
                    }
                }
                if (!(defend || this.attackMode || attack || Settings.getRallyPoint() == null || this.target == Settings.getRallyPoint())) {
                    this.target = Settings.getRallyPoint();
                }
                boolean targetChanged = false;
                if (BWTAProxy.initialized && !this.attackMode && attack) {
                    this.attackMode = true;
                }
                if (!defend && BWTAProxy.initialized && this.attackMode && EnemyManager.getManager().getInvader() == null) {
                    targetChanged = this.acquireTarget();
                }
                if (defend || !BWTAProxy.initialized || !this.attackMode) break block32;
                if (this.target != null) {
                    Tyr.drawCircle(this.target, Color.Orange, 128);
                }
                if (!targetChanged || this.target == null) break block33;
                for (Agent agent : this.units) {
                    agent.order(new BCAttack(agent, this.target));
                }
                break block33;
            }
            if (this.target != null) {
                Tyr.drawCircle(this.target, Color.Blue, 160);
                for (Agent agent : this.units) {
                    agent.order(new BCDefend(agent, this.target));
                }
            }
        }
    }

    public boolean getDefenseTarget() {
        Position newTarget = null;
        newTarget = Settings.getRallyPoint() != null ? Settings.getRallyPoint() : (Tyr.bot.defensiveStructures.get((int)0).defences.size() > 0 ? Tyr.bot.defensiveStructures.get((int)0).defences.get(0).getPosition() : Tyr.bot.defensiveStructures.get(0).getDefensePos());
        if (newTarget == null) {
            return false;
        }
        if (this.target != null && newTarget.getX() == this.target.getX() && newTarget.getY() == this.target.getY()) {
            return false;
        }
        this.target = newTarget;
        return true;
    }

    public boolean acquireTarget() {
        if (this.target != null) {
            for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                if (p.pos.getX() != this.target.getX() || p.pos.getY() != this.target.getY()) continue;
                return false;
            }
        }
        Position newTarget = null;
        Position mainPos = Tyr.bot.suspectedEnemy.get(0).getPosition();
        if (Tyr.bot.suspectedEnemy.size() == 0) {
            return false;
        }
        int dist = 0;
        for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
            int newDist = (int)p.pos.getDistance(mainPos);
            if (newDist <= dist) continue;
            newTarget = p.pos;
            dist = newDist;
        }
        if (newTarget == null) {
            return false;
        }
        if (this.target != null && this.target.getX() == newTarget.getX() && this.target.getY() == newTarget.getY()) {
            return false;
        }
        this.target = newTarget;
        return true;
    }
}

