/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.tasks.SalesmenMarinesSolution;
import com.tyr.tasks.SolutionList;
import com.tyr.tasks.Task;

public class SalesmenMarinesTask
extends Task {
    public static boolean paused = false;
    private int direction = 1;
    private UnitType onlyType = null;
    private int requiredSize = 15;
    private int maxMedics = 4;
    private boolean attackDirect = false;
    private int requiredDefense;

    public SalesmenMarinesTask() {
    }

    public SalesmenMarinesTask(UnitType onlyType) {
        this.onlyType = onlyType;
    }

    public SalesmenMarinesTask(UnitType onlyType, int requiredSize, int maxMedics, boolean attackDirect, int requiredDefense) {
        this.onlyType = onlyType;
        this.requiredSize = requiredSize;
        this.maxMedics = maxMedics;
        this.attackDirect = attackDirect;
        this.requiredDefense = requiredDefense;
    }

    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        if (this.solution != null) {
            if (((SolutionList)this.solution).size() == 0) {
                this.solution = null;
            } else {
                return true;
            }
        }
        if (this.solution == null && Settings.getBlockAttack()) {
            return false;
        }
        return bot.homeGroup.units.size() >= this.requiredSize + this.requiredDefense && bot.homeGroup.units.size() - UnitTracker.count(UnitType.Terran_Medic) + this.maxMedics >= this.requiredSize;
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        if (this.attackDirect) {
            this.attackDirect = false;
            this.direction = EnemyManager.getManager().getOrderedExpands() != null && EnemyManager.getManager().getSelfPos() * 2 >= EnemyManager.getManager().getOrderedExpands().size() ? 1 : -1;
        }
        boolean sendOut = bot.homeGroup.units.size() >= this.requiredSize + this.requiredDefense;
        int marineCount = 0;
        if (sendOut) {
            for (Agent agent : bot.homeGroup.units) {
                if (this.onlyType != null && agent.unit.getType() != this.onlyType || agent.unit.getType() == UnitType.Terran_Medic) continue;
                ++marineCount;
            }
        }
        boolean bl = sendOut = marineCount >= this.requiredSize - this.maxMedics;
        if (sendOut && !paused) {
            SalesmenMarinesSolution sol = new SalesmenMarinesSolution(this, this.direction);
            this.direction *= -1;
            int medics = 0;
            int i = bot.homeGroup.units.size() - 1;
            while (i >= 0 && sol.size() < this.requiredSize) {
                Agent agent = (Agent)bot.homeGroup.units.get(i);
                if (agent.unit.getType() != UnitType.Terran_Medic && (this.onlyType == null || agent.unit.getType() == this.onlyType) || agent.unit.getType() == UnitType.Terran_Medic && medics < this.maxMedics) {
                    sol.add(agent);
                    bot.homeGroup.units.remove(i);
                    if (agent.unit.getType() == UnitType.Terran_Medic) {
                        ++medics;
                    }
                }
                --i;
            }
            ((SolutionList)this.solution).add(sol);
        }
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        this.solution = new SolutionList(this);
    }
}

