/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwapi.UnitType;
import bwta.Region;
import com.tyr.BWTAProxy;
import com.tyr.EnemyManager;
import com.tyr.PositionUtil;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import java.util.ArrayList;
import java.util.List;

public class LocalDefenseSolution
extends Solution {
    private List<Agent> units = new ArrayList<Agent>();
    private Unit target = null;
    private Region defendedRegion;
    private Position defendedPosition;

    public LocalDefenseSolution(Task task, Region defendedRegion) {
        super(task);
        this.defendedRegion = defendedRegion;
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        int i = this.units.size() - 1;
        while (i >= 0) {
            if (this.units.get(i) == null || this.units.get(i).isDead()) {
                this.units.remove(i);
            }
            --i;
        }
        if (!(this.target == null || this.target.getHitPoints() > 0 && this.target.getRemoveTimer() <= 0 && this.target.exists())) {
            this.target = null;
        }
        this.updateTargetByRegion();
        this.updateTargetByPosition();
        if (this.target != null) {
            Tyr.drawCircle(this.target.getPosition(), Color.Red, 16);
        }
        for (Agent agent : this.units) {
            if (this.target != null) {
                agent.attack(this.target);
                continue;
            }
            if (this.defendedPosition != null) {
                agent.unit.move(this.defendedPosition);
                continue;
            }
            if (this.defendedRegion == null) continue;
            agent.unit.move(this.defendedRegion.getCenter());
        }
    }

    private void updateTargetByRegion() {
        if (this.defendedRegion == null) {
            return;
        }
        if (this.target != null && BWTAProxy.getRegion(this.target.getPosition()) != this.defendedRegion) {
            this.target = null;
        }
        if (this.target == null) {
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType() == UnitType.Protoss_Observer || unit.getType() == UnitType.Protoss_Scarab || PositionUtil.distanceSq(unit, this.defendedRegion.getCenter()) >= 0x240000 || BWTAProxy.getRegion(unit.getPosition()) != this.defendedRegion) continue;
                this.target = unit;
                break;
            }
        }
    }

    private void updateTargetByPosition() {
        if (this.defendedPosition == null) {
            return;
        }
        int maxDistSq = Settings.getSmallInvasionDist() * Settings.getSmallInvasionDist();
        if (this.target != null && PositionUtil.distanceSq(this.target, this.defendedPosition) > maxDistSq) {
            this.target = null;
        }
        if (this.target == null) {
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType() == UnitType.Protoss_Observer || unit.getType() == UnitType.Protoss_Scarab || PositionUtil.distanceSq(unit, this.defendedPosition) >= maxDistSq) continue;
                this.target = unit;
                break;
            }
        }
    }

    public void add(Agent agent) {
        this.units.add(agent);
    }

    public int size() {
        return this.units.size();
    }

    public boolean done() {
        return this.size() == 0;
    }

    public void setDefendedPosition(Position defendedPosition) {
        this.defendedPosition = defendedPosition;
        this.defendedRegion = null;
    }
}

