/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.UnitType;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.tasks.ExploreScienceSolution;
import com.tyr.tasks.Task;

public class ExploreScienceTask
extends Task {
    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        return UnitTracker.count(UnitType.Terran_Science_Vessel) > 0;
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        ExploreScienceSolution exploreSolution = (ExploreScienceSolution)this.solution;
        int i = bot.homeGroup.units.size() - 1;
        while (i >= 0) {
            if (exploreSolution.hasVessel() && exploreSolution.tankCount() >= 4) break;
            Agent agent = (Agent)bot.homeGroup.units.get(i);
            if (agent.unit.getType() == UnitType.Terran_Science_Vessel && !exploreSolution.hasVessel()) {
                exploreSolution.setVessel(agent);
                bot.homeGroup.units.remove(i);
            } else if (exploreSolution.hasVessel() && agent.isTank() && exploreSolution.tankCount() < 4) {
                exploreSolution.addTank(agent);
                bot.homeGroup.units.remove(i);
            }
            --i;
        }
        super.solve(game, self, bot);
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        this.solution = new ExploreScienceSolution(this);
    }
}

