/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.tasks.DoomDropSolution;
import com.tyr.tasks.Task;
import java.util.ArrayList;

public class DoomDropTask
extends Task {
    UnitType[][] requiredUnits = new UnitType[][]{{UnitType.Terran_Goliath, UnitType.Terran_Vulture, UnitType.Terran_Vulture, UnitType.Terran_Vulture}, {UnitType.Terran_Goliath, UnitType.Terran_Vulture, UnitType.Terran_Vulture, UnitType.Terran_Vulture}, {UnitType.Terran_Siege_Tank_Siege_Mode, UnitType.Terran_Siege_Tank_Siege_Mode}, {UnitType.Terran_Siege_Tank_Siege_Mode, UnitType.Terran_Siege_Tank_Siege_Mode}};
    int startDir = 0;

    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        if (this.solution != null) {
            return true;
        }
        if (EnemyManager.getManager().getOrderedExpands() == null) {
            return false;
        }
        return this.haveUnits(this.requiredUnits.length);
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        super.solve(game, self, bot);
        DoomDropSolution doomDrop = (DoomDropSolution)this.solution;
        if (doomDrop.returned && this.haveUnits(this.requiredUnits.length - doomDrop.dropshipsLeft())) {
            if (doomDrop.attackersRemain()) {
                boolean baseRemains = false;
                for (EnemyPosition pos : EnemyManager.getManager().enemyBuildingMemory) {
                    if (!pos.type.isResourceDepot()) continue;
                    baseRemains = true;
                    break;
                }
                if (!baseRemains) {
                    return;
                }
            }
            doomDrop.clearDropships();
            this.assignUnits(doomDrop.getDropships(), doomDrop.getUnits());
            doomDrop.returned = false;
        }
    }

    private void assignUnits(ArrayList<Agent> dropships, ArrayList<Agent>[] units) {
        boolean[][] found = new boolean[this.requiredUnits.length][];
        int listIt = 0;
        while (listIt < this.requiredUnits.length) {
            found[listIt] = new boolean[this.requiredUnits[listIt].length];
            ++listIt;
        }
        int a = Tyr.bot.homeGroup.units.size() - 1;
        while (a >= 0) {
            Agent agent = (Agent)Tyr.bot.homeGroup.units.get(a);
            if (agent.unit.getType() == UnitType.Terran_Dropship) {
                if (dropships.size() < this.requiredUnits.length) {
                    dropships.add(agent);
                    Tyr.bot.homeGroup.units.remove(a);
                }
            } else {
                boolean success = false;
                int listIt2 = 0;
                while (!success && listIt2 < this.requiredUnits.length) {
                    int typeIt = 0;
                    while (!success && typeIt < this.requiredUnits[listIt2].length) {
                        if (!found[listIt2][typeIt] && agent.unit.getType() == this.requiredUnits[listIt2][typeIt]) {
                            found[listIt2][typeIt] = true;
                            units[listIt2].add(agent);
                            Tyr.bot.homeGroup.units.remove(a);
                            success = true;
                        }
                        ++typeIt;
                    }
                    ++listIt2;
                }
            }
            --a;
        }
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        ArrayList[] units = new ArrayList[this.requiredUnits.length];
        int i = 0;
        while (i < this.requiredUnits.length) {
            units[i] = new ArrayList();
            ++i;
        }
        ArrayList<Agent> dropships = new ArrayList<Agent>();
        this.assignUnits(dropships, units);
        this.determineDirection();
        this.solution = new DoomDropSolution(this, dropships, units, this.startDir);
    }

    private void determineDirection() {
        if (this.startDir != 0) {
            return;
        }
        ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
        if (orderedExpands == null) {
            return;
        }
        Position exit = SpaceManager.getMainExit();
        int down = (EnemyManager.getManager().getSelfPos() - 1 + orderedExpands.size()) % orderedExpands.size();
        int up = (EnemyManager.getManager().getSelfPos() + 1) % orderedExpands.size();
        this.startDir = orderedExpands.get(down).getDistance(exit) < orderedExpands.get(up).getDistance(exit) ? 1 : -1;
    }

    private boolean haveUnits(int dropshipsNeeded) {
        if (Tyr.bot.homeGroup.units.size() < 10) {
            return false;
        }
        int tanks = 0;
        for (Agent agent : Tyr.bot.homeGroup.units) {
            if (!agent.isTank()) continue;
            ++tanks;
        }
        if (tanks < 6) {
            return false;
        }
        boolean[][] found = new boolean[this.requiredUnits.length][];
        int listIt = 0;
        while (listIt < this.requiredUnits.length) {
            found[listIt] = new boolean[this.requiredUnits[listIt].length];
            ++listIt;
        }
        int dropships = 0;
        for (Agent agent : Tyr.bot.homeGroup.units) {
            if (agent.unit.getType() == UnitType.Terran_Dropship) {
                ++dropships;
                continue;
            }
            int listIt2 = 0;
            while (listIt2 < this.requiredUnits.length) {
                int typeIt = 0;
                while (typeIt < this.requiredUnits[listIt2].length) {
                    if (!found[listIt2][typeIt] && agent.unit.getType() == this.requiredUnits[listIt2][typeIt]) {
                        found[listIt2][typeIt] = true;
                    }
                    ++typeIt;
                }
                ++listIt2;
            }
        }
        if (dropships < dropshipsNeeded) {
            DebugMessages.addMessage("Not enough dropships for drop.");
            return false;
        }
        boolean success = true;
        boolean[][] blArrayArray = found;
        int n = found.length;
        int n2 = 0;
        while (n2 < n) {
            boolean[] passengersFound;
            boolean[] blArray = passengersFound = blArrayArray[n2];
            int n3 = passengersFound.length;
            int n4 = 0;
            while (n4 < n3) {
                boolean passengerFound = blArray[n4];
                if (!passengerFound) {
                    DebugMessages.addMessage("Not enough units for drop.");
                    success = false;
                }
                ++n4;
            }
            ++n2;
        }
        return success;
    }
}

