/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Color;
import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import bwta.BaseLocation;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.AttackRegroupSolution;
import com.tyr.tasks.Solution;
import com.tyr.tasks.Task;
import com.tyr.unitgroups.MineralWorkers;
import java.util.ArrayList;
import java.util.Iterator;

public class DoomDropSolution
extends Solution {
    private AttackRegroupSolution attackRegroup;
    private ArrayList<AttackRegroupSolution> previousAttacks = new ArrayList();
    private int currentPos;
    private int currentDir = 1;
    private Position target;
    private Position attackTarget;
    private ArrayList<Agent> dropships;
    private ArrayList<Agent>[] units;
    private ArrayList<Position> orderedExpands;
    public boolean returned;
    private int mode = 0;
    private static final int load = 0;
    private static final int moveOut = 1;
    private static final int attack = 2;

    public DoomDropSolution(Task task, ArrayList<Agent> dropships, ArrayList<Agent>[] units, int currentDir) {
        super(task);
        this.dropships = dropships;
        this.units = units;
        this.currentDir = currentDir;
        this.determineTarget();
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        boolean newTarget = this.acquireTarget(Tyr.bot);
        if (this.attackRegroup != null) {
            Tyr.drawCircle(this.attackRegroup.getCenter(), Color.Blue, 20);
        }
        if (this.attackTarget != null) {
            Tyr.drawCircle(this.attackTarget, Color.Red, 20);
        }
        if (newTarget && this.attackRegroup != null) {
            this.attackRegroup.setTarget(this.attackTarget);
        }
        for (AttackRegroupSolution sol : this.previousAttacks) {
            if (this.attackTarget != null) {
                sol.setTarget(this.attackTarget);
            }
            sol.onFrame(game, self, bot);
        }
        DebugMessages.addMessage("Previous attacks remaining: " + this.previousAttacks.size());
        int i = this.previousAttacks.size() - 1;
        while (i >= 0) {
            if (this.previousAttacks.get(i).done()) {
                this.previousAttacks.remove(i);
            }
            --i;
        }
        i = this.dropships.size() - 1;
        while (i >= 0) {
            if (this.dropships.get(i) != null && this.dropships.get(i).isDead()) {
                this.dropships.set(i, null);
            }
            --i;
        }
        ArrayList<Agent>[] arrayListArray = this.units;
        int n = this.units.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayList<Agent> passengers = arrayListArray[n2];
            int i2 = passengers.size() - 1;
            while (i2 >= 0) {
                if (passengers.get(i2).isDead()) {
                    passengers.remove(i2);
                }
                --i2;
            }
            ++n2;
        }
        DebugMessages.addMessage("Dropship mode = " + this.mode);
        if (this.attackRegroup != null) {
            this.attackRegroup.onFrame(game, self, bot);
        }
        if (this.mode == 0) {
            this.load();
        } else if (this.mode == 1) {
            this.moveOut();
        } else if (this.mode == 2) {
            this.attack();
        }
    }

    private void attack() {
        if (this.dropships.size() == 0) {
            return;
        }
        this.returned = true;
        int listIt = 0;
        while (listIt < this.units.length) {
            Agent dropship = this.dropships.get(listIt);
            boolean isCarrying = false;
            ArrayList<Agent> passengers = this.units[listIt];
            for (Agent passenger : passengers) {
                if (!passenger.unit.isLoaded()) continue;
                dropship.unit.unload(passenger.unit);
                isCarrying = true;
                this.returned = false;
                break;
            }
            if (isCarrying && Tyr.bot.spaceManager.map[dropship.unit.getTilePosition().getX()][dropship.unit.getTilePosition().getY()] != 1) {
                dropship.unit.move(this.target);
            }
            if (isCarrying && Tyr.bot.spaceManager.map[dropship.unit.getTilePosition().getX()][dropship.unit.getTilePosition().getY()] == 1 && dropship.unit.getOrder() == Order.Move) {
                dropship.unit.stop();
            }
            if (dropship != null && !dropship.isDead() && !isCarrying) {
                dropship.unit.move(Tyr.tileToPosition(Tyr.self.getStartLocation()));
                if (dropship.distanceSquared(Tyr.tileToPosition(Tyr.self.getStartLocation())) > 40000) {
                    this.returned = false;
                }
            }
            ++listIt;
        }
        if (this.returned) {
            if (this.attackRegroup != null) {
                this.previousAttacks.add(this.attackRegroup);
                this.attackRegroup = null;
            }
            this.units = new ArrayList[this.dropships.size()];
            int i = 0;
            while (i < this.dropships.size()) {
                this.units[i] = new ArrayList();
                ++i;
            }
            this.mode = 0;
        }
    }

    private void moveOut() {
        this.determineTarget();
        int dist = 0;
        for (Agent agent : this.dropships) {
            if (agent == null) continue;
            agent.unit.move(this.target);
            Tyr.game.drawLineMap(agent.unit.getX(), agent.unit.getY(), this.target.getX(), this.target.getY(), Color.Blue);
            dist = Math.min(dist, agent.distanceSquared(this.target));
        }
        if (dist > 90000) {
            return;
        }
        if (this.currentPos >= this.orderedExpands.size() - 1) {
            this.startAttack();
            return;
        }
        for (EnemyPosition enemy : EnemyManager.getManager().enemyBuildingMemory) {
            if (!enemy.type.isResourceDepot() || !(enemy.pos.getDistance(this.target) < 100.0)) continue;
            this.startAttack();
            break;
        }
    }

    public void startAttack() {
        this.mode = 2;
        if (this.attackRegroup == null) {
            this.attackRegroup = new AttackRegroupSolution(this.task, this.target);
        }
        ArrayList<Agent>[] arrayListArray = this.units;
        int n = this.units.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayList<Agent> passengers = arrayListArray[n2];
            for (Agent agent : passengers) {
                this.attackRegroup.add(agent);
            }
            ++n2;
        }
    }

    private void load() {
        this.returned = true;
        int listIt = 0;
        while (listIt < this.units.length) {
            if (this.units[listIt].size() > 0) {
                this.returned = false;
            }
            ++listIt;
        }
        int totalPassengers = 0;
        boolean done = true;
        int listIt2 = 0;
        while (listIt2 < this.units.length) {
            ArrayList<Agent> passengers = this.units[listIt2];
            Agent dropship = this.dropships.get(listIt2);
            if (dropship != null && !dropship.isDead()) {
                totalPassengers += passengers.size();
                for (Agent agent : passengers) {
                    if (agent == null || agent.isDead() || agent.unit.isLoaded()) continue;
                    done = false;
                    dropship.unit.load(agent.unit);
                    if (agent.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode) {
                        agent.unit.unsiege();
                        continue;
                    }
                    if (agent.unit.getTargetPosition() != null && !(agent.unit.getTargetPosition().getDistance(dropship.unit.getPosition()) >= 100.0)) continue;
                    agent.unit.move(dropship.unit.getPosition());
                }
            }
            ++listIt2;
        }
        if (done && totalPassengers > 0) {
            this.mode = 1;
            this.target = null;
            return;
        }
    }

    private boolean determineTarget() {
        int i;
        boolean result = false;
        ArrayList<Position> orderedExpands = EnemyManager.getManager().getOrderedExpands();
        if (orderedExpands != null) {
            i = 0;
            while (i < orderedExpands.size()) {
                Position pos = orderedExpands.get(i);
                Tyr.drawCircle(pos, Color.Red, 32);
                Tyr.game.drawTextMap(pos.getX(), pos.getY(), String.valueOf(i));
                ++i;
            }
            if (this.target != null) {
                Tyr.drawCircle(this.target, Color.Red);
            }
        }
        if (this.target == null) {
            if (orderedExpands == null) {
                DebugMessages.addMessage("orderedExpands is null.");
                return false;
            }
            this.currentPos = EnemyManager.getManager().getSelfPos();
            if (this.currentPos != -1) {
                this.target = orderedExpands.get(this.currentPos);
                result = true;
            }
        }
        i = 0;
        while (i < 2 * orderedExpands.size()) {
            boolean isIsland = false;
            for (BaseLocation loc : Tyr.bot.expands) {
                if (!loc.isIsland() || !(loc.getDistance(this.target) <= 128.0)) continue;
                isIsland = true;
            }
            if (!isIsland && this.target != null && !Tyr.game.isVisible(Tyr.positionToTile(this.target))) break;
            boolean closeEnough = false;
            for (MineralWorkers base : Tyr.bot.workForce.mineralWorkers) {
                if (base.resourceDepot == null || base.resourceDepot.getDistance(this.target) >= 100) continue;
                closeEnough = true;
            }
            if (!isIsland && !closeEnough && this.dropships != null) {
                for (Agent agent : this.dropships) {
                    if (agent == null || agent.distanceSquared(this.target) >= 16384) continue;
                    closeEnough = true;
                }
            }
            if (!isIsland && !closeEnough) break;
            this.nextTarget();
            result = true;
            ++i;
        }
        return result;
    }

    private void nextTarget() {
        if (this.orderedExpands == null) {
            this.orderedExpands = (ArrayList)EnemyManager.getManager().getOrderedExpands().clone();
            if (this.orderedExpands == null) {
                return;
            }
            if (Tyr.bot.suspectedEnemy.size() == 1) {
                this.orderedExpands.add(Tyr.bot.suspectedEnemy.get(0).getPosition());
            }
        }
        if (this.currentPos >= this.orderedExpands.size() - 1) {
            return;
        }
        this.currentPos = (this.currentPos + this.currentDir + this.orderedExpands.size()) % this.orderedExpands.size();
        this.target = this.orderedExpands.get(this.currentPos);
    }

    public boolean done() {
        ArrayList<Agent>[] arrayListArray = this.units;
        int n = this.units.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayList<Agent> passengers = arrayListArray[n2];
            if (passengers.size() > 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void clear() {
        for (Agent dropship : this.dropships) {
            Tyr.bot.hobos.add(dropship);
        }
        ArrayList<Agent>[] arrayListArray = this.units;
        int n = this.units.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayList<Agent> passengers = arrayListArray[n2];
            for (Agent agent : passengers) {
                Tyr.bot.hobos.add(agent);
            }
            ++n2;
        }
    }

    public boolean acquireTarget(Tyr bot) {
        if (this.attackTarget != null) {
            for (EnemyPosition p : EnemyManager.getManager().enemyBuildingMemory) {
                if (p.pos.getX() != this.attackTarget.getX() || p.pos.getY() != this.attackTarget.getY()) continue;
                return false;
            }
        }
        Position newTarget = null;
        Iterator<Object> iterator = EnemyManager.getManager().enemyBuildingMemory.iterator();
        if (iterator.hasNext()) {
            EnemyPosition p = iterator.next();
            newTarget = p.pos;
        }
        if (newTarget == null && (iterator = bot.suspectedEnemy.iterator()).hasNext()) {
            BaseLocation b = (BaseLocation)iterator.next();
            newTarget = b.getPosition();
        }
        if (newTarget == null) {
            return false;
        }
        if (this.attackTarget == null) {
            this.attackTarget = newTarget;
            return true;
        }
        if (this.attackTarget.getX() == newTarget.getX() && this.attackTarget.getY() == newTarget.getY()) {
            DebugMessages.addMessage("Target has not changed.");
            return false;
        }
        this.attackTarget = newTarget;
        return true;
    }

    public int dropshipsLeft() {
        int result = 0;
        for (Agent dropship : this.dropships) {
            if (dropship == null || dropship.isDead()) continue;
            ++result;
        }
        return result;
    }

    public void clearDropships() {
        ArrayList<Agent> newShips = new ArrayList<Agent>();
        for (Agent dropship : this.dropships) {
            if (dropship == null) continue;
            newShips.add(dropship);
        }
        this.dropships = newShips;
    }

    public ArrayList<Agent> getDropships() {
        return this.dropships;
    }

    public ArrayList<Agent>[] getUnits() {
        return this.units;
    }

    public boolean attackersRemain() {
        return this.previousAttacks.size() > 0;
    }
}

