/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.tasks;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.EnemyManager;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.tasks.SendTroopsSolution;
import com.tyr.tasks.Task;

public class DefendBaseTask
extends Task {
    private Unit invader;
    private Position defensePos;
    private int range;
    public boolean active = true;

    public DefendBaseTask(Position defensePos, int range) {
        this.defensePos = defensePos;
        this.range = range;
    }

    @Override
    public boolean isRequired(Game game, Player self, Tyr bot) {
        return true;
    }

    @Override
    public void solve(Game game, Player self, Tyr bot) {
        this.determineInvader();
        if (this.invader != null) {
            ((SendTroopsSolution)this.solution).setTarget(this.invader.getPosition());
        } else {
            ((SendTroopsSolution)this.solution).setTarget(this.defensePos);
        }
        int i = bot.homeGroup.units.size() - 1;
        while (i > ((SendTroopsSolution)this.solution).getCount()) {
            ((SendTroopsSolution)this.solution).add((Agent)bot.homeGroup.units.get(i));
            bot.homeGroup.units.remove(i);
            --i;
        }
        super.solve(game, self, bot);
    }

    private void determineInvader() {
        this.invader = null;
        double bestDist = this.range;
        for (Unit enemy : EnemyManager.getEnemyUnits()) {
            double newDist;
            if (Tyr.self.getRace() == Race.Protoss && !enemy.isDetected() && (enemy.getType() == UnitType.Protoss_Dark_Templar || enemy.isBurrowed()) || (newDist = (double)enemy.getDistance(this.defensePos)) >= bestDist) continue;
            this.invader = enemy;
        }
    }

    @Override
    public void findSolution(Game game, Player self, Tyr bot) {
        this.solution = new SendTroopsSolution(this, this.defensePos);
    }
}

