/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TechType;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.MassTank;
import com.tyr.builds.SupplyDepotPart;
import com.tyr.unitgroups.ScoutGroup;

public class TvP
extends CompositeBuildOrder {
    boolean cannonBuildDetected = false;
    boolean antiTechStarted;
    MassTank massTank = null;
    boolean cannonRush = false;
    boolean antiCannonInitialized = false;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(15);
        Settings.setMaximumSize(40);
        this.add(new SupplyDepotPart());
        this.add(new ExpandPart());
        bot.scout.nscouts = 1;
        bot.scout.workerScoutTiming = 1600;
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        int count;
        DebugMessages.addMessage("Going bio.");
        if (bot.scout.opponentStrategy == ScoutGroup.cannons) {
            ExpandPart.maximumCcs = 1;
        }
        if (!(this.cannonRush || EnemyManager.getManager().getInvader() == null || EnemyManager.getManager().getInvader().getType() != UnitType.Protoss_Photon_Cannon && EnemyManager.getManager().getInvader().getType() != UnitType.Protoss_Pylon)) {
            this.cannonRush = true;
        }
        if ((bot.scout.opponentStrategy == ScoutGroup.cannons || this.cannonBuildDetected) && UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) < 5) {
            this.cannonBuildDetected = true;
            if (!this.antiCannonInitialized) {
                this.antiCannonInitialized = true;
                this.massTank = new MassTank();
                this.massTank.initialize(game, self, bot);
            }
            this.massTank.cannonRushDetected = this.cannonRush;
            this.massTank.onFrame(game, self, bot);
            return;
        }
        super.onFrame(game, self, bot);
        if ((bot.scout.opponentStrategy == ScoutGroup.tech || bot.scout.opponentStrategy == ScoutGroup.zealotPush || game.getFrameCount() >= 6000 && bot.scout.opponentStrategy == ScoutGroup.unknown) && !this.antiTechStarted) {
            this.antiTechStarted = true;
            Settings.setDefensiveTanks(2);
        }
        if (this.antiTechStarted) {
            Tyr.drawCircle(new Position(self.getStartLocation().getX() * 32 + 64, self.getStartLocation().getY() * 32 + 32), Color.Green, 64);
            if (bot.getAvailableGas() >= 200) {
                Settings.setWorkersPerGas(1);
            } else if (bot.getAvailableGas() <= 100) {
                Settings.setWorkersPerGas(2);
            }
        } else {
            Tyr.drawCircle(new Position(self.getStartLocation().getX() * 32 + 64, self.getStartLocation().getY() * 32 + 32), Color.White, 64);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) < Math.min(UnitTracker.getCcCount() * 2, 10) && (bot.getAvailableMinerals() >= 200 || UnitTracker.count(UnitType.Terran_Barracks) < 1)) {
            bot.spaceManager.build(UnitType.Terran_Barracks);
        }
        if (UnitTracker.getGeyserCount() > 0 && bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Refinery) == 0 && UnitTracker.count(UnitType.Terran_Bunker) >= 1) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if (bot.getAvailableMinerals() >= 125 && UnitTracker.count(UnitType.Terran_Engineering_Bay) < 1 && UnitTracker.count(UnitType.Terran_Bunker) >= 1) {
            bot.spaceManager.build(UnitType.Terran_Engineering_Bay);
        }
        if (this.antiTechStarted && UnitTracker.count(UnitType.Terran_Engineering_Bay) >= 1 && bot.getAvailableMinerals() >= 75) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                count = structures.getUnitCount(UnitType.Terran_Missile_Turret);
                if (count != 0 || structures.defences.size() <= 0) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Missile_Turret, structures);
                break;
            }
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) != 0 && UnitTracker.count(UnitType.Terran_Refinery) != 0 && UnitTracker.count(UnitType.Terran_Academy) == 0 && UnitTracker.count(UnitType.Terran_Engineering_Bay) > 0 && UnitTracker.count(UnitType.Terran_Command_Center) >= 2) {
            bot.spaceManager.build(UnitType.Terran_Academy);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1 && bot.scout.opponentStrategy != ScoutGroup.cannons) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                count = structures.getUnitCount(UnitType.Terran_Bunker);
                if (count >= (this.antiTechStarted && !structures.tooFar ? 2 : 1)) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
                break;
            }
        }
        if (bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Terran_Engineering_Bay) >= 1 && UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Factory) < 1 && this.antiTechStarted) {
            bot.spaceManager.build(UnitType.Terran_Factory);
        }
        if (this.antiTechStarted && bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Terran_Academy) > 0 && UnitTracker.count(UnitType.Terran_Engineering_Bay) > 0 && UnitTracker.count(UnitType.Terran_Factory) > 0 && UnitTracker.count(UnitType.Terran_Command_Center) >= 2 && UnitTracker.count(UnitType.Terran_Starport) < 1) {
            bot.spaceManager.build(UnitType.Terran_Starport);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (!this.cannonBuildDetected && !this.cannonRush && agent.unit.getType() == UnitType.Terran_Factory) {
            int neededTanks = 0;
            for (DefensiveStructures defPos : bot.defensiveStructures) {
                if (defPos.tooFar) continue;
                neededTanks += Settings.getDefensiveTanks();
            }
            if (agent.unit.getAddon() == null && bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50) {
                agent.unit.buildAddon(UnitType.Terran_Machine_Shop);
            } else if (!agent.unit.isTraining() && bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) < neededTanks && (UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) == 0 || self.hasResearched(TechType.Tank_Siege_Mode))) {
                agent.unit.train(UnitType.Terran_Siege_Tank_Tank_Mode);
            } else if (!agent.unit.isTraining() && bot.getAvailableMinerals() >= 100) {
                agent.unit.train(UnitType.Terran_Vulture);
            }
            return true;
        }
        return false;
    }
}

