/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.SupplyDepotPart;
import com.tyr.builds.WorkerScoutPart;

public class TerranAntiAir
extends CompositeBuildOrder {
    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(40);
        Settings.setMaximumSize(60);
        this.add(new SupplyDepotPart());
        this.add(new WorkerScoutPart(1600));
        this.add(new ExpandPart());
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        int count;
        super.onFrame(game, self, bot);
        if (bot.getAvailableGas() >= 400) {
            Settings.setWorkersPerGas(UnitTracker.count(UnitType.Terran_Factory) >= 1 ? 2 : 1);
        } else if (bot.getAvailableGas() <= 300) {
            Settings.setWorkersPerGas(UnitTracker.count(UnitType.Terran_Factory) >= 1 ? 3 : 2);
        } else {
            Tyr.drawCircle(new Position(self.getStartLocation().getX() * 32 + 64, self.getStartLocation().getY() * 32 + 32), Color.White, 64);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Command_Center) >= 2 && UnitTracker.count(UnitType.Terran_Barracks) < 1) {
            bot.spaceManager.build(UnitType.Terran_Barracks);
        }
        if (UnitTracker.getGeyserCount() > 0 && bot.getAvailableMinerals() >= 100 && (UnitTracker.count(UnitType.Terran_Refinery) == 0 || UnitTracker.count(UnitType.Terran_Refinery) < UnitTracker.count(UnitType.Terran_Command_Center) && UnitTracker.count(UnitType.Terran_Starport) > 0) && UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Bunker) >= 1) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if (bot.getAvailableMinerals() >= 125 && UnitTracker.count(UnitType.Terran_Engineering_Bay) < 1 && UnitTracker.count(UnitType.Terran_Starport) >= 1) {
            bot.spaceManager.build(UnitType.Terran_Engineering_Bay);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) != 0 && UnitTracker.count(UnitType.Terran_Refinery) != 0 && UnitTracker.count(UnitType.Terran_Academy) == 0 && UnitTracker.count(UnitType.Terran_Engineering_Bay) > 0 && UnitTracker.count(UnitType.Terran_Command_Center) >= 2) {
            bot.spaceManager.build(UnitType.Terran_Academy);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                if (structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) < 128.0 && UnitTracker.count(UnitType.Terran_Factory) == 0 || (count = structures.getUnitCount(UnitType.Terran_Bunker)) >= 1) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
                break;
            }
        }
        if (bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Factory) < 3) {
            bot.spaceManager.build(UnitType.Terran_Factory);
        }
        if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Terran_Factory) >= 2 && UnitTracker.count(UnitType.Terran_Command_Center) >= 2 && UnitTracker.count(UnitType.Terran_Starport) < 2) {
            bot.spaceManager.build(UnitType.Terran_Starport);
        }
        if (UnitTracker.count(UnitType.Terran_Engineering_Bay) >= 1 && bot.getAvailableMinerals() >= 75) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                count = structures.getUnitCount(UnitType.Terran_Missile_Turret);
                if (count >= 2 || structures.defences.size() <= 0) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Missile_Turret, structures);
                break;
            }
        }
        if (UnitTracker.count(UnitType.Terran_Starport) >= 2 && UnitTracker.count(UnitType.Terran_Armory) < 2 && bot.getAvailableGas() >= 50 && bot.getAvailableMinerals() >= 100) {
            bot.spaceManager.build(UnitType.Terran_Armory);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Factory) {
            if (!agent.unit.isTraining() && bot.getAvailableMinerals() >= 100) {
                agent.unit.train(UnitType.Terran_Vulture);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Starport) {
            if (agent.unit.getAddon() == null && bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50) {
                agent.unit.buildAddon(UnitType.Terran_Control_Tower);
            } else if (!agent.unit.isTraining() && bot.getAvailableMinerals() >= 250 && bot.getAvailableGas() >= 125 && UnitTracker.count(UnitType.Terran_Armory) >= 1) {
                agent.unit.train(UnitType.Terran_Valkyrie);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Science_Facility) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Engineering_Bay) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Physics_Lab) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Armory) {
            if (bot.getAvailableMinerals() >= UpgradeType.Terran_Vehicle_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Vehicle_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Terran_Vehicle_Weapons);
            }
            if (bot.getAvailableMinerals() >= UpgradeType.Terran_Vehicle_Plating.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Vehicle_Plating.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Terran_Vehicle_Plating);
            }
            return true;
        }
        return false;
    }
}

