/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.UnitType;
import com.tyr.EnemyManager;
import com.tyr.EnemyPosition;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.builds.BuildOrder;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.tasks.DropHarassTask;

public class TFastDetect
extends CompositeBuildOrder {
    BuildOrder contained;

    public TFastDetect(BuildOrder contained) {
        this.contained = contained;
    }

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        if (this.contained != null) {
            this.contained.initialize(game, self, bot);
        }
        bot.taskManager.potentialTasks.add(new DropHarassTask());
        super.add(new WorkerScoutPart(800));
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        int count;
        super.onFrame(game, self, bot);
        boolean coreExists = false;
        for (EnemyPosition building : EnemyManager.getManager().enemyBuildingMemory) {
            if (building.type != UnitType.Protoss_Cybernetics_Core) continue;
            coreExists = true;
            break;
        }
        if (coreExists && bot.getAvailableMinerals() >= 125 && UnitTracker.count(UnitType.Terran_Engineering_Bay) < 1 && UnitTracker.count(UnitType.Terran_Bunker) >= 1) {
            bot.spaceManager.build(UnitType.Terran_Engineering_Bay);
        }
        if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Terran_Command_Center) >= 2 && UnitTracker.count(UnitType.Terran_Factory) >= 1 && UnitTracker.count(UnitType.Terran_Starport) == 0) {
            bot.spaceManager.build(UnitType.Terran_Starport);
        }
        if (coreExists && bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                if (!(structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) < 128.0) || UnitTracker.count(UnitType.Terran_Factory) != 0) continue;
                count = structures.getUnitCount(UnitType.Terran_Bunker);
                if (count >= (game.enemy().getRace() == Race.Protoss ? 2 : 1)) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
                break;
            }
        }
        if (UnitTracker.count(UnitType.Terran_Engineering_Bay) >= 1 && bot.getAvailableMinerals() >= 75) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                count = structures.getUnitCount(UnitType.Terran_Missile_Turret);
                if (count >= 1 || structures.defences.size() <= 0) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Missile_Turret, structures);
                break;
            }
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) != 0 && UnitTracker.count(UnitType.Terran_Refinery) != 0 && UnitTracker.count(UnitType.Terran_Academy) == 0) {
            bot.spaceManager.build(UnitType.Terran_Academy);
        }
        this.contained.onFrame(game, self, bot);
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Starport) {
            if (agent.unit.getAddon() == null && bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50) {
                agent.unit.buildAddon(UnitType.Terran_Control_Tower);
            } else if (bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Terran_Dropship) < 1) {
                agent.unit.train(UnitType.Terran_Dropship);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Factory) {
            if (bot.getAvailableMinerals() >= 100 && !agent.unit.isTraining() && UnitTracker.count(UnitType.Terran_Vulture) <= 2 * (UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode))) {
                agent.unit.train(UnitType.Terran_Vulture);
                return true;
            }
            if (UnitTracker.count(UnitType.Terran_Armory) >= 1 && !agent.unit.isTraining() && UnitTracker.count(UnitType.Terran_Siege_Tank_Siege_Mode) + UnitTracker.count(UnitType.Terran_Siege_Tank_Tank_Mode) >= 8 + UnitTracker.count(UnitType.Terran_Goliath) && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 50) {
                agent.unit.train(UnitType.Terran_Goliath);
                return true;
            }
        }
        return this.contained.overrideStructureOrder(game, self, bot, agent);
    }
}

