/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwta.BWTA;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.PositionUtil;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.ConjRequirement;
import com.tyr.requirements.CostRequirement;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.BuildAtLocationTask;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.LocalDefenseTask;
import com.tyr.unitgroups.ScoutGroup;

public class PvT
extends CompositeBuildOrder {
    private ConstantPushTask constantPushTask;
    private LocalDefenseTask localDefenseTask;
    private LocalDefenseTask thirdDefenseTask;
    public boolean attackStarted;
    private int armySize = 25;
    private int retreatSize = 20;
    private boolean mechDetected = false;
    private boolean upgradeLegSpeed;
    private boolean detectionNeeded = false;
    private boolean useStorm = true;
    private boolean useArbiters = true;
    private boolean useDT = false;
    private boolean counterZerglingPush = false;
    private boolean counterMassZerglings = false;
    private boolean counterMutas = false;
    private boolean defensesInitialized = false;
    private boolean defendThird = true;

    public PvT(int armySize) {
        this.armySize = armySize;
    }

    public PvT(int armySize, boolean useArbiters, boolean useDT, boolean counterMutas, boolean defendThird) {
        this.armySize = armySize;
        this.useArbiters = useArbiters;
        this.useDT = useDT;
        this.counterMutas = counterMutas;
        this.defendThird = defendThird;
    }

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(60);
        Settings.setSmallInvasionDist(480);
        Settings.setLargeInvasionDist(768);
        Settings.setWorkersPerGas(2);
        Attack.dontWaitAtCannon = true;
        this.add(new ExpandPart(true));
        if (game.mapFileName().contains("Alchemist") || !ScoutGroup.enemyRaceKnown()) {
            this.add(new WorkerScoutPart(100));
        } else {
            this.add(new WorkerScoutPart(1600));
        }
        ExpandPart.maximumCcs = 2;
        this.localDefenseTask = new LocalDefenseTask(BWTA.getRegion(self.getStartLocation()), 0);
        bot.taskManager.potentialTasks.add(this.localDefenseTask);
        this.thirdDefenseTask = new LocalDefenseTask(null, 0);
        bot.taskManager.potentialTasks.add(this.thirdDefenseTask);
        this.constantPushTask = new ConstantPushTask(null, 0);
        this.constantPushTask.stop = true;
        bot.taskManager.potentialTasks.add(this.constantPushTask);
        ConstantPushTask.prioritizeExpands = true;
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("Performing PvT build.");
        super.onFrame(game, self, bot);
        if (!this.mechDetected && (EnemyManager.getManager().getEnemyTypes().contains(UnitType.Terran_Siege_Tank_Siege_Mode) || EnemyManager.getManager().getEnemyTypes().contains(UnitType.Terran_Siege_Tank_Tank_Mode) || EnemyManager.getManager().getEnemyTypes().contains(UnitType.Terran_Machine_Shop))) {
            this.mechDetected = true;
        }
        if (!this.mechDetected) {
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (enemy.getType() != UnitType.Terran_Vulture || PositionUtil.distanceSq(enemy.getPosition(), Tyr.getStartLocation()) > 0x240000) continue;
                this.mechDetected = true;
                break;
            }
        }
        if (game.getFrameCount() >= 15000) {
            this.counterZerglingPush = false;
        } else if (EnemyManager.getManager().getAllCount(UnitType.Zerg_Zergling) >= 6) {
            this.counterZerglingPush = true;
        }
        if (EnemyManager.getManager().getAllCount(UnitType.Zerg_Mutalisk) > 0) {
            this.counterMutas = true;
        }
        boolean bl = this.counterMassZerglings = ScoutGroup.enemyRace == Race.Zerg && EnemyManager.getManager().getAllCount(UnitType.Zerg_Mutalisk) + EnemyManager.getManager().getAllCount(UnitType.Zerg_Hydralisk) + EnemyManager.getManager().getAllCount(UnitType.Zerg_Lurker) == 0 && game.getFrameCount() >= 12000 && !this.counterMutas;
        if (this.mechDetected) {
            this.detectionNeeded = true;
        }
        boolean bl2 = this.useStorm = !this.mechDetected && ScoutGroup.enemyRace == Race.Terran;
        if (ScoutGroup.enemyRace == Race.Zerg) {
            this.useArbiters = false;
        }
        if (ScoutGroup.enemyRace == Race.Protoss || ScoutGroup.enemyRace == Race.Zerg) {
            this.detectionNeeded = true;
        }
        if (PvT.gas() >= 400) {
            Settings.setWorkersPerGas(2);
        } else if (PvT.gas() < 250 && PvT.count(GATEWAY) >= 12 || PvT.gas() + 400 < PvT.minerals()) {
            Settings.setWorkersPerGas(3);
        }
        if (this.constantPushTask != null && PvT.completed(ZEALOT) + PvT.completed(DRAGOON) <= this.retreatSize) {
            this.constantPushTask.stop = true;
        }
        if (!(this.constantPushTask == null || PvT.completed(ZEALOT) + PvT.completed(DRAGOON) < this.armySize || PvT.completed(HIGH_TEMPLAR) <= 0 && this.useStorm || !self.hasResearched(TechType.Psionic_Storm) && this.useStorm)) {
            ExpandPart.maximumCcs = 100;
            this.constantPushTask.stop = false;
            this.attackStarted = true;
            this.localDefenseTask.setDefendersNeeded(3);
            this.armySize = Math.max(this.armySize, 30);
            this.detectionNeeded = true;
        }
        if (this.defendThird && this.thirdDefenseTask.getDefendersNeeded() == 0 && Tyr.bot.workForce.mineralWorkers.size() >= 3) {
            this.thirdDefenseTask.setDefendersNeeded(3);
            this.thirdDefenseTask.setDefendedPosition(Tyr.bot.workForce.mineralWorkers.get((int)2).resourceDepot.getPosition());
        }
        if (PvT.completed(DRAGOON) >= 8) {
            ExpandPart.maximumCcs = Math.max(3, ExpandPart.maximumCcs);
        }
        if (PvT.completed(ZEALOT) + PvT.completed(DRAGOON) >= 9) {
            this.upgradeLegSpeed = true;
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= PvT.count(GATEWAY) * 3 + UnitTracker.getCcCount() * 3 && PvT.minerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400) {
            bot.spaceManager.build(PYLON);
        }
        if (!this.defensesInitialized && this.counterMutas && game.getFrameCount() >= 8000) {
            this.defensesInitialized = true;
            Position defensivePosition = SpaceManager.getNaturalDefensePos();
            BuildAtLocationTask buildTask = new BuildAtLocationTask(defensivePosition, true);
            buildTask.addBuilding(UnitType.Protoss_Pylon, new UnitRequirement(UnitType.Protoss_Probe, 7));
            int i = 0;
            while (i < 2) {
                ConjRequirement requirements = new ConjRequirement().addRequirement(new CostRequirement(150, 0));
                buildTask.addBuilding(UnitType.Protoss_Photon_Cannon, requirements);
                ++i;
            }
            bot.taskManager.potentialTasks.add(buildTask);
        }
        if (PvT.completed(FORGE) > 0 && PvT.minerals() >= 150 && PvT.count(CANNON) < 4 && this.counterMutas && game.getFrameCount() >= 8000) {
            PvT.build(CANNON);
        }
        if (PvT.count(NEXUS) >= 2 && PvT.minerals() >= 150 && PvT.count(GATEWAY) == 0 && PvT.completed(PYLON) > 0 && PvT.count(PYLON) > 0) {
            bot.spaceManager.build(GATEWAY);
        }
        if (PvT.count(NEXUS) >= 2 && PvT.minerals() >= 150 && PvT.count(GATEWAY) < 2 && PvT.count(CYBERNETICS_CORE) > 0) {
            bot.spaceManager.build(GATEWAY);
        }
        if ((ScoutGroup.enemyRace == Race.Protoss || ScoutGroup.enemyRace == Race.Zerg) && PvT.minerals() >= 150 && PvT.count(GATEWAY) < (ScoutGroup.enemyRace == Race.Zerg ? 2 : 1)) {
            bot.spaceManager.build(GATEWAY);
        }
        if (!this.pauseProduction()) {
            if (PvT.count(NEXUS) >= 2 && PvT.minerals() >= 250 && PvT.count(GATEWAY) < 4 && PvT.count(CYBERNETICS_CORE) > 0) {
                bot.spaceManager.build(GATEWAY);
            }
            if (PvT.count(NEXUS) >= 2 && PvT.minerals() >= 250 && PvT.count(CYBERNETICS_CORE) > 0 && PvT.count(GATEWAY) < 8) {
                bot.spaceManager.build(GATEWAY);
            }
            if (PvT.count(NEXUS) >= 2 && PvT.minerals() >= 150 && PvT.completed(GATEWAY) >= 8 && PvT.count(GATEWAY) < 12) {
                bot.spaceManager.build(GATEWAY);
            }
        }
        if (PvT.minerals() >= 100 && UnitTracker.getGeyserCount() > 0 && PvT.count(GATEWAY) > 0 && PvT.count(NEXUS) >= 2) {
            bot.spaceManager.build(ASSIMILATOR);
        }
        if (PvT.minerals() >= 200 && PvT.count(CYBERNETICS_CORE) < 1 && PvT.completed(GATEWAY) > 0 && PvT.count(NEXUS) >= 2) {
            bot.spaceManager.build(CYBERNETICS_CORE);
        }
        if (PvT.minerals() >= 150 && PvT.count(FORGE) < 2 && PvT.count(DRAGOON) >= 2) {
            bot.spaceManager.build(FORGE);
        }
        if (this.upgradeLegSpeed && PvT.minerals() >= 150 && PvT.gas() >= 100 && PvT.count(CITADEL) == 0 && PvT.completed(CYBERNETICS_CORE) > 0 && PvT.count(NEXUS) >= 2) {
            bot.spaceManager.build(CITADEL);
        }
        if (PvT.minerals() >= 150 && PvT.gas() >= 200 && (this.useStorm || this.useArbiters || self.getUpgradeLevel(UpgradeType.Protoss_Ground_Armor) + self.getUpgradeLevel(UpgradeType.Protoss_Ground_Weapons) > 0) && PvT.count(TEMPLAR_ARCHIVES) < 1 && PvT.completed(CITADEL) > 0 && PvT.count(NEXUS) >= 2) {
            PvT.build(TEMPLAR_ARCHIVES);
        }
        if (PvT.gas() >= 200 && PvT.minerals() >= 200 && this.detectionNeeded && PvT.count(ROBOTICS_FACILITY) == 0 && PvT.count(DRAGOON) >= 5) {
            bot.spaceManager.build(ROBOTICS_FACILITY);
        }
        if (PvT.gas() >= 50 && PvT.minerals() >= 100 && PvT.completed(ROBOTICS_FACILITY) > 0 && PvT.count(OBSERVATORY) == 0 && this.detectionNeeded) {
            bot.spaceManager.build(OBSERVATORY);
        }
        if (PvT.minerals() >= 150 && PvT.gas() >= 100 && this.useArbiters && PvT.count(STARGATE) == 0 && PvT.completed(CYBERNETICS_CORE) > 0 && PvT.count(DRAGOON) >= 8 && (self.hasResearched(TechType.Psionic_Storm) || self.isResearching(TechType.Psionic_Storm) || !this.useStorm)) {
            PvT.build(STARGATE);
        }
        if (PvT.minerals() >= 200 && PvT.gas() >= 150 && PvT.completed(STARGATE) > 0 && PvT.completed(TEMPLAR_ARCHIVES) > 0 && PvT.count(ARBITER_TRIBUNAL) == 0 && (self.hasResearched(TechType.Psionic_Storm) || self.isResearching(TechType.Psionic_Storm) || !this.useStorm)) {
            PvT.build(ARBITER_TRIBUNAL);
        }
    }

    private boolean pauseProduction() {
        if (PvT.gas() > 250 && PvT.minerals() > 400) {
            return false;
        }
        if (this.upgradeLegSpeed && PvT.count(CITADEL) == 0) {
            return true;
        }
        if (PvT.completed(CITADEL) > 0 && !Tyr.self.isUpgrading(UpgradeType.Leg_Enhancements) && Tyr.self.getUpgradeLevel(UpgradeType.Leg_Enhancements) == 0) {
            return true;
        }
        if (PvT.completed(CITADEL) > 0 && PvT.count(TEMPLAR_ARCHIVES) == 0) {
            return true;
        }
        if (PvT.completed(TEMPLAR_ARCHIVES) > 0 && PvT.count(HIGH_TEMPLAR) > 0 && !Tyr.self.isResearching(TechType.Psionic_Storm) && !Tyr.self.hasResearched(TechType.Psionic_Storm) && this.useStorm) {
            return true;
        }
        if (this.detectionNeeded && PvT.count(DRAGOON) >= 5 && PvT.completed(ROBOTICS_FACILITY) == 1 && PvT.count(OBSERVATORY) == 0) {
            return true;
        }
        if (this.detectionNeeded && PvT.count(DRAGOON) >= 5 && PvT.completed(OBSERVATORY) == 1 && PvT.count(OBSERVER) == 0) {
            return true;
        }
        if (PvT.completed(STARGATE) > 0 && this.useArbiters && PvT.completed(TEMPLAR_ARCHIVES) > 0 && PvT.count(ARBITER_TRIBUNAL) == 0 && (Tyr.self.hasResearched(TechType.Psionic_Storm) || Tyr.self.isResearching(TechType.Psionic_Storm) || !this.useStorm) && PvT.count(ARBITER_TRIBUNAL) == 0) {
            return true;
        }
        if (this.detectionNeeded && PvT.count(DRAGOON) >= 5 && PvT.count(ROBOTICS_FACILITY) == 0) {
            return true;
        }
        return this.attackStarted && PvT.count(NEXUS) < 3;
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == GATEWAY && !agent.unit.isTraining()) {
            boolean pause = this.pauseProduction();
            if ((ScoutGroup.enemyRace == Race.Protoss || ScoutGroup.enemyRace == Race.Zerg) && PvT.count(ZEALOT) < (this.counterZerglingPush ? 8 : 4) && PvT.minerals() >= 100) {
                agent.unit.build(ZEALOT);
            }
            if (pause && PvT.minerals() >= 600) {
                agent.unit.build(ZEALOT);
            } else if (PvT.count(ZEALOT) + PvT.count(DRAGOON) >= 10 * PvT.count(HIGH_TEMPLAR) && PvT.count(HIGH_TEMPLAR) < 6 && PvT.completed(TEMPLAR_ARCHIVES) > 0 && !pause && this.useStorm) {
                if (PvT.minerals() >= 50 && PvT.gas() >= 150) {
                    agent.unit.build(HIGH_TEMPLAR);
                }
            } else if (self.completedUnitCount(UnitType.Protoss_Templar_Archives) > 0 && PvT.count(DARK_TEMPLAR) == 0 && PvT.minerals() >= 125 && PvT.gas() >= 100 && this.useDT) {
                agent.unit.train(UnitType.Protoss_Dark_Templar);
            } else if (!(PvT.count(ZEALOT) >= (this.counterMassZerglings ? 2 : 1) * PvT.count(DRAGOON) - 5 || PvT.minerals() < 100 || PvT.minerals() < 400 && pause)) {
                agent.unit.build(ZEALOT);
            } else if (PvT.minerals() >= 125 && PvT.gas() >= 50 && (PvT.minerals() >= 400 && PvT.gas() > 200 || !pause)) {
                agent.unit.build(DRAGOON);
            }
            return true;
        }
        if (agent.unit.getType() == FORGE && !agent.unit.isUpgrading()) {
            if (this.pauseProduction() && ScoutGroup.enemyRace != Race.Zerg) {
                return true;
            }
            if (PvT.minerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && PvT.gas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
            }
            if (PvT.minerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && PvT.gas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
            }
        } else if (agent.unit.getType() == CYBERNETICS_CORE && !agent.unit.isUpgrading()) {
            if (PvT.minerals() >= UpgradeType.Singularity_Charge.mineralPrice() && PvT.gas() >= UpgradeType.Singularity_Charge.gasPrice() && PvT.count(DRAGOON) > 5) {
                agent.unit.upgrade(UpgradeType.Singularity_Charge);
            }
        } else {
            if (agent.unit.getType() == ROBOTICS_FACILITY) {
                if (PvT.count(OBSERVER) < 2 && PvT.completed(OBSERVATORY) > 0 && PvT.minerals() >= 25 && PvT.gas() >= 75 && !agent.unit.isTraining()) {
                    agent.unit.build(OBSERVER);
                }
                return true;
            }
            if (agent.unit.getType() == CITADEL && !agent.unit.isUpgrading()) {
                if (PvT.gas() >= UpgradeType.Leg_Enhancements.gasPrice() && PvT.minerals() >= UpgradeType.Leg_Enhancements.mineralPrice()) {
                    agent.unit.upgrade(UpgradeType.Leg_Enhancements);
                }
            } else if (agent.unit.getType() == TEMPLAR_ARCHIVES && !agent.unit.isResearching()) {
                if (this.useStorm && PvT.gas() >= TechType.Psionic_Storm.gasPrice() && PvT.minerals() >= TechType.Psionic_Storm.mineralPrice() && !self.hasResearched(TechType.Psionic_Storm)) {
                    agent.unit.research(TechType.Psionic_Storm);
                }
            } else if (agent.unit.getType() == STARGATE) {
                if (PvT.completed(ARBITER_TRIBUNAL) > 0 && PvT.minerals() >= 100 && PvT.gas() >= 350 && !agent.unit.isTraining()) {
                    agent.unit.train(ARBITER);
                }
                return true;
            }
        }
        return false;
    }
}

