/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.TechType;
import bwapi.UnitType;
import bwapi.UpgradeType;
import bwta.BWTA;
import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.tasks.ClearExpandsTask;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.tasks.DefendMainTask;
import com.tyr.tasks.LocalDefenseTask;
import com.tyr.unitgroups.DistributeAttackGroup;

public class MassRecall
extends CompositeBuildOrder {
    private LocalDefenseTask localDefenseTask;
    private LocalDefenseTask naturalDefenseTask;
    private LocalDefenseTask thirdDefenseTask;
    private ConstantPushTask constantPushTask;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        DefendMainTask.keepZealotsBack = true;
        this.localDefenseTask = new LocalDefenseTask(BWTA.getRegion(Tyr.getStartLocation()), 0);
        this.addTask(this.localDefenseTask);
        this.naturalDefenseTask = new LocalDefenseTask(null, 0);
        this.addTask(this.naturalDefenseTask);
        this.thirdDefenseTask = new LocalDefenseTask(null, 0);
        this.addTask(this.thirdDefenseTask);
        this.constantPushTask = new ConstantPushTask(3);
        this.constantPushTask.stop = true;
        this.addTask(this.constantPushTask);
        DistributeAttackGroup.waitDistance = 800;
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(7);
        Settings.setWorkersPerGas(2);
        Settings.setLargeInvasionDist(768);
        ExpandPart.maximumCcs = 2;
        ClearExpandsTask.allowFullAssault = false;
        this.add(new WorkerScoutPart(1600));
        this.add(new ExpandPart(true));
        Attack.requiredAtCannon = 0;
        ConstantPushTask.prioritizeExpands = true;
        ConstantPushTask.reinforcementSize = 5;
        super.initialize(game, self, bot);
    }

    private static int armySize() {
        return MassRecall.completed(ZEALOT) + MassRecall.completed(DRAGOON);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("Army size: " + MassRecall.armySize());
        if (this.constantPushTask != null && MassRecall.completed(ZEALOT) + MassRecall.completed(DRAGOON) <= 10) {
            this.constantPushTask.stop = true;
        }
        if (MassRecall.armySize() >= 16) {
            this.localDefenseTask.setDefendersNeeded(1);
        }
        if (this.naturalDefenseTask != null && this.naturalDefenseTask.getDefendersNeeded() == 0 && Tyr.bot.workForce.mineralWorkers.size() >= 2) {
            this.naturalDefenseTask.setDefendersNeeded(2);
            this.naturalDefenseTask.setDefendedPosition(Tyr.bot.workForce.mineralWorkers.get((int)1).resourceDepot.getPosition());
        }
        if (this.thirdDefenseTask != null && this.thirdDefenseTask.getDefendersNeeded() == 0 && Tyr.bot.workForce.mineralWorkers.size() >= 3) {
            this.thirdDefenseTask.setDefendersNeeded(3);
            this.thirdDefenseTask.setDefendedPosition(Tyr.bot.workForce.mineralWorkers.get((int)2).resourceDepot.getPosition());
        }
        super.onFrame(game, self, bot);
        if (MassRecall.gas() >= 400) {
            Settings.setWorkersPerGas(2);
        } else if (MassRecall.gas() < 250 && MassRecall.count(GATEWAY) >= 12 || MassRecall.gas() + 400 < MassRecall.minerals()) {
            Settings.setWorkersPerGas(3);
        }
        if (MassRecall.count(NEXUS) > 1) {
            Settings.setMaximumWorkers(40);
        } else if (UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0) {
            Settings.setMaximumWorkers(30);
        } else if (UnitTracker.count(UnitType.Protoss_Gateway) >= 4) {
            Settings.setMaximumWorkers(25);
        } else if (UnitTracker.count(UnitType.Protoss_Gateway) >= 2) {
            Settings.setMaximumWorkers(9);
        }
        if (MassRecall.armySize() >= 2 && UnitTracker.count(UnitType.Protoss_Gateway) < 4) {
            Settings.setMaximumWorkers(20);
        }
        if (UnitTracker.count(UnitType.Protoss_Probe) >= 7 && UnitTracker.count(UnitType.Protoss_Pylon) == 0 && bot.getAvailableMinerals() >= 100) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (SpaceManager.noPower && MassRecall.minerals() >= 100 && MassRecall.count(PYLON) == MassRecall.completed(PYLON)) {
            bot.spaceManager.build(PYLON);
        }
        if (self.completedUnitCount(UnitType.Protoss_Pylon) > 0 && bot.getAvailableMinerals() >= 125 && UnitTracker.count(UnitType.Protoss_Gateway) == 0 && MassRecall.count(NEXUS) > 1) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (UnitTracker.count(UnitType.Protoss_Gateway) == 1 && bot.getAvailableMinerals() >= 100 && MassRecall.count(CYBERNETICS_CORE) > 0 && MassRecall.count(ASSIMILATOR) > 0 && MassRecall.count(NEXUS) > 1) {
            bot.spaceManager.build(UnitType.Protoss_Gateway);
        }
        if (!this.pauseProduction()) {
            if (UnitTracker.count(UnitType.Protoss_Gateway) < 4 && bot.getAvailableMinerals() >= 300 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0) {
                bot.spaceManager.build(UnitType.Protoss_Gateway);
            }
            if (UnitTracker.count(UnitType.Protoss_Gateway) >= 3 && UnitTracker.count(UnitType.Protoss_Gateway) < 6 && bot.getAvailableMinerals() >= 300 && MassRecall.count(ZEALOT) + MassRecall.count(DRAGOON) >= 7) {
                bot.spaceManager.build(UnitType.Protoss_Gateway);
            }
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= UnitTracker.count(UnitType.Protoss_Gateway) * 3 + UnitTracker.getCcCount() * 3 && bot.getAvailableMinerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400 && UnitTracker.count(UnitType.Protoss_Pylon) >= 1 && (MassRecall.armySize() >= 2 || self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() < 4)) {
            bot.spaceManager.build(UnitType.Protoss_Pylon);
        }
        if (UnitTracker.count(UnitType.Protoss_Assimilator) < 2 && bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && (MassRecall.count(CYBERNETICS_CORE) > 0 || MassRecall.minerals() >= 300) && MassRecall.count(NEXUS) >= 2) {
            bot.spaceManager.build(UnitType.Protoss_Assimilator);
        }
        if (bot.getAvailableMinerals() >= 200 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) < 1 && MassRecall.completed(GATEWAY) > 0) {
            bot.spaceManager.build(UnitType.Protoss_Cybernetics_Core);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Protoss_Dragoon) + UnitTracker.count(UnitType.Protoss_Zealot) >= 15 && UnitTracker.count(UnitType.Protoss_Forge) == 0) {
            bot.spaceManager.build(UnitType.Protoss_Forge);
        }
        if (bot.getAvailableMinerals() >= 300 && UnitTracker.count(UnitType.Protoss_Nexus) >= 2 && UnitTracker.count(UnitType.Protoss_Cybernetics_Core) > 0 && UnitTracker.count(UnitType.Protoss_Forge) < 2) {
            bot.spaceManager.build(UnitType.Protoss_Forge);
        }
        if (bot.getAvailableMinerals() >= 150 && bot.getAvailableGas() >= 100 && UnitTracker.count(UnitType.Protoss_Citadel_of_Adun) == 0 && self.completedUnitCount(UnitType.Protoss_Cybernetics_Core) > 0 && UnitTracker.count(UnitType.Protoss_Gateway) >= 4 && MassRecall.count(DRAGOON) >= 5) {
            bot.spaceManager.build(UnitType.Protoss_Citadel_of_Adun);
        }
        if (MassRecall.gas() >= 150 && MassRecall.minerals() >= 200 && MassRecall.count(TEMPLAR_ARCHIVES) == 0 && MassRecall.completed(CITADEL) > 0 && MassRecall.count(DRAGOON) >= 8) {
            MassRecall.build(TEMPLAR_ARCHIVES);
        }
        if (MassRecall.gas() >= 200 && MassRecall.minerals() >= 200 && MassRecall.count(ROBOTICS_FACILITY) < 1 && MassRecall.count(GATEWAY) >= 2) {
            bot.spaceManager.build(ROBOTICS_FACILITY);
        }
        if (MassRecall.gas() >= 50 && MassRecall.minerals() >= 100 && MassRecall.completed(ROBOTICS_FACILITY) > 0 && MassRecall.count(OBSERVATORY) == 0) {
            bot.spaceManager.build(OBSERVATORY);
        }
        if (MassRecall.minerals() >= 150 && MassRecall.gas() >= 100 && MassRecall.count(STARGATE) == 0 && MassRecall.completed(CYBERNETICS_CORE) > 0 && MassRecall.count(DRAGOON) >= 8) {
            MassRecall.build(STARGATE);
        }
        if (MassRecall.minerals() >= 200 && MassRecall.gas() >= 150 && MassRecall.completed(STARGATE) > 0 && MassRecall.completed(TEMPLAR_ARCHIVES) > 0 && MassRecall.count(ARBITER_TRIBUNAL) == 0) {
            MassRecall.build(ARBITER_TRIBUNAL);
        }
    }

    private boolean pauseProduction() {
        if (MassRecall.gas() > 250 && MassRecall.minerals() > 400) {
            return false;
        }
        if (MassRecall.count(DRAGOON) >= 2 && MassRecall.count(GATEWAY) > 2 && MassRecall.completed(CYBERNETICS_CORE) > 0 && MassRecall.count(ROBOTICS_FACILITY) == 0 && MassRecall.count(ARBITER_TRIBUNAL) > 0) {
            return true;
        }
        if (MassRecall.armySize() >= 2 && MassRecall.completed(CYBERNETICS_CORE) > 0 && MassRecall.completed(ROBOTICS_FACILITY) == 1 && MassRecall.count(OBSERVATORY) == 0) {
            return true;
        }
        if (MassRecall.armySize() >= 2 && MassRecall.completed(CYBERNETICS_CORE) > 0 && MassRecall.completed(OBSERVATORY) == 1 && MassRecall.count(OBSERVER) < 3 && MassRecall.completed(OBSERVER) == MassRecall.count(OBSERVER)) {
            return true;
        }
        if (MassRecall.completed(STARGATE) > 0 && MassRecall.count(SCOUT) == 0) {
            return true;
        }
        if (UnitTracker.count(CITADEL) == 0 && MassRecall.completed(CYBERNETICS_CORE) > 0 && MassRecall.count(GATEWAY) >= 4 && MassRecall.count(ZEALOT) + MassRecall.count(DRAGOON) >= 20) {
            return true;
        }
        if (MassRecall.minerals() < 400 && MassRecall.count(NEXUS) <= 2 && MassRecall.count(NEXUS) < ExpandPart.maximumCcs) {
            return true;
        }
        if (MassRecall.minerals() >= 300) {
            return false;
        }
        if (MassRecall.count(ZEALOT) >= 2 && MassRecall.count(CYBERNETICS_CORE) == 0) {
            return true;
        }
        return MassRecall.count(ZEALOT) >= 2 && MassRecall.count(ASSIMILATOR) == 0;
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == UnitType.Protoss_Gateway && !agent.unit.isTraining()) {
            if (MassRecall.count(DRAGOON) <= 10 && !this.pauseProduction()) {
                if (bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50) {
                    agent.unit.build(DRAGOON);
                }
                return true;
            }
            if (!(this.pauseProduction() && MassRecall.minerals() < 300 || MassRecall.count(ZEALOT) + 3 > MassRecall.count(DRAGOON) && MassRecall.count(DRAGOON) < 20 || MassRecall.count(DRAGOON) < 10 || bot.getAvailableMinerals() < 100)) {
                agent.unit.build(ZEALOT);
            } else if (!this.pauseProduction() && MassRecall.count(ZEALOT) + 3 > MassRecall.count(DRAGOON) && bot.getAvailableMinerals() >= 125 && bot.getAvailableGas() >= 50) {
                agent.unit.build(DRAGOON);
            }
            return true;
        }
        if (agent.unit.getType() == UnitType.Protoss_Cybernetics_Core && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Singularity_Charge.mineralPrice() && MassRecall.count(DRAGOON) >= 3 && bot.getAvailableGas() >= UpgradeType.Singularity_Charge.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Singularity_Charge);
            }
        } else if (agent.unit.getType() == UnitType.Protoss_Forge && !agent.unit.isUpgrading()) {
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Weapons.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Weapons);
            }
            if (bot.getAvailableMinerals() >= UpgradeType.Protoss_Ground_Armor.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Protoss_Ground_Armor.gasPrice()) {
                agent.unit.upgrade(UpgradeType.Protoss_Ground_Armor);
            }
        } else if (agent.unit.getType() == CITADEL && !agent.unit.isUpgrading()) {
            if (MassRecall.gas() >= UpgradeType.Leg_Enhancements.gasPrice() && MassRecall.minerals() >= UpgradeType.Leg_Enhancements.mineralPrice()) {
                agent.unit.upgrade(UpgradeType.Leg_Enhancements);
            }
        } else {
            if (agent.unit.getType() == ROBOTICS_FACILITY) {
                if (MassRecall.count(OBSERVER) < 3 && MassRecall.minerals() >= 25 && MassRecall.gas() >= 75 && !agent.unit.isTraining()) {
                    agent.unit.build(OBSERVER);
                }
                if (MassRecall.minerals() >= 600 && !agent.unit.isTraining()) {
                    agent.unit.build(SHUTTLE);
                }
                return true;
            }
            if (agent.unit.getType() == STARGATE) {
                if (MassRecall.completed(ARBITER_TRIBUNAL) > 0 && MassRecall.minerals() >= 100 && MassRecall.gas() >= 350 && !agent.unit.isTraining()) {
                    agent.unit.train(ARBITER);
                }
                return true;
            }
            if (agent.unit.getType() == ARBITER_TRIBUNAL && self.hasResearched(TechType.Recall) && MassRecall.minerals() >= 150 && MassRecall.gas() >= 150) {
                agent.unit.research(TechType.Recall);
            }
        }
        return false;
    }
}

