/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.agents.Attack;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.ConjRequirement;
import com.tyr.requirements.CostRequirement;
import com.tyr.requirements.Requirement;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.BuildAtLocationSolution;
import com.tyr.tasks.BuildAtLocationTask;
import com.tyr.tasks.ConstantPushTask;
import com.tyr.unitgroups.AttackGroup;
import com.tyr.unitgroups.WorkerGroup;

public class BrieDuCamembert
extends CompositeBuildOrder {
    private ConstantPushTask constantPushTask;
    public boolean attackStarted;
    private int armySize = 8;
    private int retreatSize = 0;
    private boolean upgradeLegSpeed;
    private boolean detectionNeeded = false;
    private boolean firstAttackDone = false;
    private boolean proxyPylonInitialized = true;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(100);
        Settings.setMaximumSize(100);
        Settings.setMaximumWorkers(25);
        Settings.setSmallInvasionDist(480);
        Settings.setLargeInvasionDist(768);
        Settings.setWorkersPerGas(2);
        Attack.dontWaitAtCannon = true;
        this.add(new ExpandPart(true));
        if (game.mapFileName().contains("Alchemist")) {
            this.add(new WorkerScoutPart(100));
        } else {
            this.add(new WorkerScoutPart(1600));
        }
        ExpandPart.maximumCcs = 1;
        bot.taskManager.potentialTasks.add(new ConstantPushTask(DARK_TEMPLAR, 1));
        this.constantPushTask = new ConstantPushTask(null, 0);
        this.constantPushTask.stop = true;
        bot.taskManager.potentialTasks.add(this.constantPushTask);
        AttackGroup.fearBarracks = true;
        ConstantPushTask.prioritizeExpands = true;
        BuildAtLocationSolution.removeExcess = false;
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("Performing PvT build.");
        super.onFrame(game, self, bot);
        boolean bl = WorkerGroup.evacuateThreatenedBases = game.getFrameCount() >= 12000;
        if (BrieDuCamembert.gas() >= 400) {
            Settings.setWorkersPerGas(2);
        } else if (BrieDuCamembert.gas() < 250 && BrieDuCamembert.count(GATEWAY) >= 12 || BrieDuCamembert.gas() + 400 < BrieDuCamembert.minerals()) {
            Settings.setWorkersPerGas(3);
        }
        if (this.constantPushTask != null && BrieDuCamembert.completed(ZEALOT) + BrieDuCamembert.completed(DRAGOON) <= this.retreatSize) {
            this.constantPushTask.stop = true;
        }
        if (this.constantPushTask != null && BrieDuCamembert.completed(ZEALOT) + BrieDuCamembert.completed(DRAGOON) >= this.armySize) {
            ExpandPart.maximumCcs = 2;
            this.constantPushTask.stop = false;
            this.attackStarted = true;
        }
        if (!this.firstAttackDone && BrieDuCamembert.completed(ZEALOT) + BrieDuCamembert.completed(DRAGOON) >= 3) {
            this.constantPushTask.stop = false;
        }
        if (!this.firstAttackDone && EnemyManager.getManager().getAllCount(UnitType.Terran_Siege_Tank_Siege_Mode) > 0) {
            this.constantPushTask.remove();
            this.firstAttackDone = true;
            this.constantPushTask.stop = true;
            this.upgradeLegSpeed = true;
        }
        if (self.supplyTotal() + UnitTracker.getSupplyConstructing() - self.supplyUsed() <= BrieDuCamembert.count(GATEWAY) * 3 + UnitTracker.getCcCount() * 3 && BrieDuCamembert.minerals() >= 100 && self.supplyTotal() + UnitTracker.getSupplyConstructing() < 400) {
            bot.spaceManager.build(PYLON);
        }
        if (BrieDuCamembert.minerals() >= 150 && BrieDuCamembert.count(GATEWAY) < 2 && BrieDuCamembert.completed(PYLON) > 0) {
            bot.spaceManager.build(GATEWAY);
        }
        if (!this.pauseProduction()) {
            if (BrieDuCamembert.minerals() >= 150 && BrieDuCamembert.count(GATEWAY) < 4 && BrieDuCamembert.count(CYBERNETICS_CORE) > 0 && BrieDuCamembert.count(TEMPLAR_ARCHIVES) > 0) {
                bot.spaceManager.build(GATEWAY);
            }
            if (BrieDuCamembert.count(NEXUS) >= 2 && BrieDuCamembert.minerals() >= 250 && BrieDuCamembert.count(CYBERNETICS_CORE) > 0 && BrieDuCamembert.count(GATEWAY) < 8) {
                bot.spaceManager.build(GATEWAY);
            }
            if (BrieDuCamembert.count(NEXUS) >= 2 && BrieDuCamembert.minerals() >= 150 && BrieDuCamembert.completed(GATEWAY) >= 8 && BrieDuCamembert.count(GATEWAY) < 12) {
                bot.spaceManager.build(GATEWAY);
            }
        }
        if (BrieDuCamembert.minerals() >= 100 && UnitTracker.getGeyserCount() > 0 && BrieDuCamembert.count(GATEWAY) > 0 && BrieDuCamembert.count(ZEALOT) >= 5 && BrieDuCamembert.count(ASSIMILATOR) == 0 || this.attackStarted) {
            bot.spaceManager.build(ASSIMILATOR);
        }
        if (BrieDuCamembert.minerals() >= 200 && BrieDuCamembert.count(CYBERNETICS_CORE) < 1 && BrieDuCamembert.completed(GATEWAY) > 0 && BrieDuCamembert.count(ZEALOT) >= 5) {
            bot.spaceManager.build(CYBERNETICS_CORE);
        }
        if (BrieDuCamembert.minerals() >= 150 && BrieDuCamembert.gas() >= 100 && BrieDuCamembert.count(CITADEL) == 0 && BrieDuCamembert.completed(CYBERNETICS_CORE) > 0) {
            bot.spaceManager.build(CITADEL);
        }
        if (BrieDuCamembert.minerals() >= 150 && BrieDuCamembert.gas() >= 200 && BrieDuCamembert.count(TEMPLAR_ARCHIVES) < 1 && BrieDuCamembert.completed(CITADEL) > 0) {
            BrieDuCamembert.build(TEMPLAR_ARCHIVES);
        }
        if (BrieDuCamembert.gas() >= 200 && BrieDuCamembert.minerals() >= 200 && this.detectionNeeded && BrieDuCamembert.count(ROBOTICS_FACILITY) == 0 && BrieDuCamembert.count(DRAGOON) >= 5) {
            bot.spaceManager.build(ROBOTICS_FACILITY);
        }
        if (BrieDuCamembert.gas() >= 50 && BrieDuCamembert.minerals() >= 100 && BrieDuCamembert.completed(ROBOTICS_FACILITY) > 0 && BrieDuCamembert.count(OBSERVATORY) == 0 && this.detectionNeeded) {
            bot.spaceManager.build(OBSERVATORY);
        }
        if (!this.proxyPylonInitialized && BrieDuCamembert.count(ZEALOT) >= 5 && game.getFrameCount() >= 100 && bot.suspectedEnemy.size() == 1) {
            this.proxyPylonInitialized = true;
            final BrieDuCamembert build = this;
            Position offensivePosition = SpaceManager.getEnemyNatural().getPosition();
            BuildAtLocationTask buildTask = new BuildAtLocationTask(offensivePosition, true);
            buildTask.addBuilding(UnitType.Protoss_Pylon, new ConjRequirement().addRequirement(new CostRequirement(50, 0)).addRequirement(new Requirement(){

                @Override
                public boolean met() {
                    return !build.firstAttackDone;
                }
            }));
            buildTask.addBuilding(UnitType.Protoss_Forge, new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Pylon, 1, true)).addRequirement(new CostRequirement(100, 0)).addRequirement(new Requirement(){

                @Override
                public boolean met() {
                    return !build.firstAttackDone;
                }
            }));
            int i = 0;
            while (i < 4) {
                ConjRequirement requirements = new ConjRequirement().addRequirement(new UnitRequirement(UnitType.Protoss_Forge, 1, true)).addRequirement(new CostRequirement(150, 0)).addRequirement(new Requirement(){

                    @Override
                    public boolean met() {
                        return !build.firstAttackDone;
                    }
                });
                buildTask.addBuilding(UnitType.Protoss_Photon_Cannon, requirements);
                ++i;
            }
            bot.taskManager.potentialTasks.add(buildTask);
        }
        if (BrieDuCamembert.count(CANNON) < 4 && BrieDuCamembert.minerals() >= 400 && BrieDuCamembert.completed(FORGE) > 0) {
            BrieDuCamembert.build(CANNON);
        }
    }

    private boolean pauseProduction() {
        if (BrieDuCamembert.gas() > 250 && BrieDuCamembert.minerals() > 400) {
            return false;
        }
        if (this.upgradeLegSpeed && BrieDuCamembert.count(CITADEL) == 0) {
            return true;
        }
        if (BrieDuCamembert.completed(CITADEL) > 0 && !Tyr.self.isUpgrading(UpgradeType.Leg_Enhancements) && Tyr.self.getUpgradeLevel(UpgradeType.Leg_Enhancements) == 0) {
            return true;
        }
        if (BrieDuCamembert.completed(CITADEL) > 0 && BrieDuCamembert.count(TEMPLAR_ARCHIVES) == 0) {
            return true;
        }
        if (this.detectionNeeded && BrieDuCamembert.count(DRAGOON) >= 5 && BrieDuCamembert.completed(ROBOTICS_FACILITY) == 1 && BrieDuCamembert.count(OBSERVATORY) == 0) {
            return true;
        }
        if (this.detectionNeeded && BrieDuCamembert.count(DRAGOON) >= 5 && BrieDuCamembert.completed(OBSERVATORY) == 1 && BrieDuCamembert.count(OBSERVER) == 0) {
            return true;
        }
        if (this.detectionNeeded && BrieDuCamembert.count(DRAGOON) >= 5 && BrieDuCamembert.count(ROBOTICS_FACILITY) == 0) {
            return true;
        }
        return this.attackStarted && BrieDuCamembert.count(NEXUS) < 3;
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (agent.unit.getType() == NEXUS) {
            if (BrieDuCamembert.count(GATEWAY) < 2 && BrieDuCamembert.count(PROBE) >= 10) {
                return true;
            }
            if (BrieDuCamembert.count(ZEALOT) <= 2 && BrieDuCamembert.count(PROBE) >= 13) {
                return true;
            }
        } else {
            if (agent.unit.getType() == GATEWAY && !agent.unit.isTraining()) {
                if (BrieDuCamembert.count(DARK_TEMPLAR) >= BrieDuCamembert.count(DRAGOON) + 5) {
                    agent.unit.train(DRAGOON);
                }
                if (BrieDuCamembert.completed(TEMPLAR_ARCHIVES) > 0) {
                    agent.unit.train(DARK_TEMPLAR);
                } else if (BrieDuCamembert.count(ZEALOT) < 5 || BrieDuCamembert.minerals() >= 400) {
                    agent.unit.build(ZEALOT);
                }
                return true;
            }
            if (agent.unit.getType() == FORGE && !agent.unit.isUpgrading()) {
                if (this.pauseProduction()) {
                    return true;
                }
            } else if (agent.unit.getType() == CYBERNETICS_CORE && !agent.unit.isUpgrading()) {
                if (BrieDuCamembert.minerals() >= UpgradeType.Singularity_Charge.mineralPrice() && BrieDuCamembert.gas() >= UpgradeType.Singularity_Charge.gasPrice() && BrieDuCamembert.count(DRAGOON) > 5) {
                    agent.unit.upgrade(UpgradeType.Singularity_Charge);
                }
            } else {
                if (agent.unit.getType() == ROBOTICS_FACILITY) {
                    if (BrieDuCamembert.count(OBSERVER) < 2 && BrieDuCamembert.completed(OBSERVATORY) > 0 && BrieDuCamembert.minerals() >= 25 && BrieDuCamembert.gas() >= 75 && !agent.unit.isTraining()) {
                        agent.unit.build(OBSERVER);
                    }
                    return true;
                }
                if (agent.unit.getType() == CITADEL && !agent.unit.isUpgrading()) {
                    return true;
                }
                if ((agent.unit.getType() != TEMPLAR_ARCHIVES || agent.unit.isResearching()) && agent.unit.getType() == STARGATE) {
                    if (BrieDuCamembert.completed(ARBITER_TRIBUNAL) > 0 && BrieDuCamembert.minerals() >= 100 && BrieDuCamembert.gas() >= 350 && !agent.unit.isTraining()) {
                        agent.unit.train(ARBITER);
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

