/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.TechType;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.SupplyDepotPart;
import com.tyr.builds.WorkerScoutPart;

public class BioMech
extends CompositeBuildOrder {
    boolean expandingEnabled = false;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setRequiredSize(15);
        Settings.setMaximumSize(60);
        Settings.setWorkersPerGas(1);
        this.add(new SupplyDepotPart());
        this.add(new WorkerScoutPart(1600));
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        long time;
        DebugMessages.addMessage("Going bioMech.");
        StopWatch watch = new StopWatch();
        watch.start();
        super.onFrame(game, self, bot);
        if (!this.expandingEnabled && bot.getAvailableMinerals() >= 800) {
            this.add(new ExpandPart());
            this.expandingEnabled = true;
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("BioMech super time: " + time);
        }
        if (UnitTracker.count(UnitType.Terran_Factory) > 0) {
            Settings.setWorkersPerGas(2);
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) < Math.min(6, 2 * UnitTracker.getCcCount()) && (UnitTracker.count(UnitType.Terran_Academy) > 0 || UnitTracker.count(UnitType.Terran_Barracks) < 2) && (UnitTracker.count(UnitType.Terran_Barracks) == 0 || self.hasResearched(TechType.Tank_Siege_Mode) && UnitTracker.count(UnitType.Terran_Factory) > 0 && UnitTracker.count(UnitType.Terran_Academy) > 0 && UnitTracker.count(UnitType.Terran_Refinery) > 0)) {
            bot.spaceManager.build(UnitType.Terran_Barracks);
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("BioMech tier 1 time: " + time);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && UnitTracker.count(UnitType.Terran_Refinery) == 0) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("BioMech refinery: " + time + " geyserCount: " + UnitTracker.getGeyserCount());
        }
        if (bot.getAvailableMinerals() >= 150 && UnitTracker.count(UnitType.Terran_Barracks) != 0 && UnitTracker.count(UnitType.Terran_Factory) != 0 && UnitTracker.count(UnitType.Terran_Refinery) != 0 && UnitTracker.count(UnitType.Terran_Academy) == 0) {
            bot.spaceManager.build(UnitType.Terran_Academy);
        }
        if (bot.getAvailableMinerals() >= 125 && UnitTracker.count(UnitType.Terran_Engineering_Bay) < 2 && UnitTracker.count(UnitType.Terran_Marine) >= 20 && UnitTracker.count(UnitType.Terran_Academy) > 0) {
            bot.spaceManager.build(UnitType.Terran_Engineering_Bay);
        }
        if (UnitTracker.count(UnitType.Terran_Barracks) > 0 && UnitTracker.count(UnitType.Terran_Factory) == 0 && bot.getAvailableGas() >= 100 && bot.getAvailableMinerals() >= 200) {
            bot.spaceManager.build(UnitType.Terran_Factory);
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("BioMech tier 2 time: " + time);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks) {
            if (!agent.unit.isTraining() && Tyr.bot.getAvailableGas() >= 25 && Tyr.bot.getAvailableMinerals() >= 50 && self.completedUnitCount(UnitType.Terran_Academy) > 0) {
                if (UnitTracker.count(UnitType.Terran_Medic) * 4 < UnitTracker.count(UnitType.Terran_Marine) + UnitTracker.count(UnitType.Terran_Firebat) - 4 * UnitTracker.count(UnitType.Terran_Bunker)) {
                    agent.unit.train(UnitType.Terran_Medic);
                    return true;
                }
                if (UnitTracker.count(UnitType.Terran_Firebat) <= UnitTracker.count(UnitType.Terran_Marine)) {
                    agent.unit.train(UnitType.Terran_Firebat);
                    return true;
                }
            }
        } else if (agent.unit.getType() == UnitType.Terran_Starport) {
            return true;
        }
        return false;
    }
}

