/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.Race;
import bwapi.TechType;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.DefensiveStructures;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.GenericPartFactory;
import com.tyr.builds.SupplyDepotPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.LinearMax;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.AttackTask;
import com.tyr.unitgroups.MineralWorkers;

public class AntiPool
extends CompositeBuildOrder {
    private boolean takeExpands = false;
    private int turretPos;
    private int depotTurrets = 10;
    boolean firstAttackDone = false;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        Settings.setLargeInvasionDist(720);
        Settings.setRequiredSize(10);
        Settings.setMaximumSize(60);
        Settings.setWorkersPerGas(1);
        bot.bunkers.maximumRepair = 1;
        this.add(new SupplyDepotPart());
        this.add(new WorkerScoutPart(1600));
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setCost(100, 0).create());
        GenericPartFactory barracks2Factory = new GenericPartFactory(UnitType.Terran_Barracks).setMax(2).setCost(100, 0);
        this.add(barracks2Factory.create());
        barracks2Factory.add(new UnitRequirement(UnitType.Terran_Bunker));
        GenericPartFactory barracksFactory = new GenericPartFactory(UnitType.Terran_Barracks).setMax(8).setCost(100, 0).add(new LinearMax(UnitType.Terran_Command_Center, UnitType.Terran_Barracks, 3, 0, false)).add(new UnitRequirement(UnitType.Terran_Academy));
        barracksFactory.add(new UnitRequirement(UnitType.Terran_Bunker));
        this.add(barracksFactory.create());
        GenericPartFactory academyFactory = new GenericPartFactory(UnitType.Terran_Academy).add(new UnitRequirement(UnitType.Terran_Barracks)).add(new UnitRequirement(UnitType.Terran_Refinery));
        this.add(academyFactory.create());
        this.add(new GenericPartFactory(UnitType.Terran_Engineering_Bay).setMax(2).add(new UnitRequirement(UnitType.Terran_Marine, 10)).add(new UnitRequirement(UnitType.Terran_Academy)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Factory).add(new UnitRequirement(UnitType.Terran_Barracks, 6)).add(new UnitRequirement(UnitType.Terran_Engineering_Bay, 2)).create());
        super.initialize(game, self, bot);
    }

    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("Stopping zergling rush.");
        DebugMessages.addMessage("Total lings detected: " + EnemyManager.getManager().getAllCount(UnitType.Zerg_Zergling));
        StopWatch watch = new StopWatch();
        watch.start();
        super.onFrame(game, self, bot);
        long time = watch.time();
        if (time > 55L) {
            DebugMessages.addMessage("Bio super time: " + time);
        }
        if (UnitTracker.count(UnitType.Terran_Barracks) > 5 || UnitTracker.count(UnitType.Terran_Engineering_Bay) > 0) {
            Settings.setWorkersPerGas(2);
        }
        if (!this.takeExpands && AttackTask.getAttackSent()) {
            this.add(new ExpandPart(true));
            this.takeExpands = true;
        }
        boolean bl = bot.bunkers.disabled = self.completedUnitCount(UnitType.Terran_Marine) + self.completedUnitCount(UnitType.Terran_Medic) >= (this.firstAttackDone ? 20 : 10) && !AttackTask.getAttackSent();
        if (!this.firstAttackDone && !EnemyManager.getManager().enemyDefensiveStructures.isEmpty()) {
            this.firstAttackDone = true;
            Settings.setRequiredSize(20);
            AttackTask.setAttackSent(false);
            AttackTask.cancelAttacks();
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio tier 1 time: " + time);
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.getGeyserCount() > 0 && UnitTracker.count(UnitType.Terran_Barracks) >= 1 && (UnitTracker.count(UnitType.Terran_Refinery) == 0 || UnitTracker.count(UnitType.Terran_Starport) > 0) && UnitTracker.count(UnitType.Terran_Bunker) > 0) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio refinery: " + time + " geyserCount: " + UnitTracker.getGeyserCount());
        }
        if (bot.getAvailableMinerals() >= 75 && self.completedUnitCount(UnitType.Terran_Engineering_Bay) > 0) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                if (structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) <= 200.0) continue;
                if (structures.getUnitCount(UnitType.Terran_Missile_Turret) != 0) break;
                bot.spaceManager.buildDefensive(UnitType.Terran_Missile_Turret, structures);
                break;
            }
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1) {
            for (DefensiveStructures structures : bot.defensiveStructures) {
                int count = structures.getUnitCount(UnitType.Terran_Bunker);
                if (bot.defensiveStructures.size() > 1 && structures.defendedPosition.getDistance(Tyr.tileToPosition(self.getStartLocation())) <= 200.0 || count >= 1) continue;
                bot.spaceManager.buildDefensive(UnitType.Terran_Bunker, structures);
                break;
            }
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio bunker time: " + time);
        }
        if (self.completedUnitCount(UnitType.Terran_Engineering_Bay) >= 1 && bot.getAvailableMinerals() >= 75) {
            boolean built = false;
            int i = 0;
            while (i < bot.workForce.mineralWorkers.size()) {
                MineralWorkers workers = bot.workForce.mineralWorkers.get((i + this.turretPos) % bot.workForce.mineralWorkers.size());
                if (bot.spaceManager.build(UnitType.Terran_Missile_Turret, null, workers.turretSite)) {
                    built = true;
                    this.turretPos = (i + this.turretPos + 1) % bot.workForce.mineralWorkers.size();
                    break;
                }
                ++i;
            }
            if (!built) {
                DebugMessages.addMessage("No placement found for any turret.");
            }
        }
        if (bot.getAvailableMinerals() >= 75 && self.completedUnitCount(UnitType.Terran_Missile_Turret) <= this.depotTurrets && UnitTracker.count(UnitType.Terran_Marine) >= 15) {
            bot.spaceManager.build(UnitType.Terran_Missile_Turret, null, bot.spaceManager.depotBuildSite);
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio turrets time: " + time);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks) {
            if (!agent.unit.isTraining() && Tyr.bot.getAvailableGas() >= 25 && Tyr.bot.getAvailableMinerals() >= 50 && self.completedUnitCount(UnitType.Terran_Academy) > 0 && UnitTracker.count(UnitType.Terran_Medic) * 4 < UnitTracker.count(UnitType.Terran_Marine) - 4 * UnitTracker.count(UnitType.Terran_Bunker)) {
                agent.unit.train(UnitType.Terran_Medic);
                return true;
            }
        } else if (agent.unit.getType() == UnitType.Terran_Academy) {
            if (bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 100 && !agent.unit.isResearching() && !self.hasResearched(TechType.Stim_Packs)) {
                agent.unit.research(TechType.Stim_Packs);
                return true;
            }
            if (bot.getAvailableGas() >= 150 && bot.getAvailableMinerals() >= 150 && !agent.unit.isResearching()) {
                agent.unit.upgrade(UpgradeType.U_238_Shells);
            }
        } else if (agent.unit.getType() == UnitType.Terran_Factory) {
            if (!agent.unit.isTraining() && bot.getAvailableMinerals() >= 100 && Tyr.game.enemy().getRace() == Race.Protoss) {
                agent.unit.train(UnitType.Terran_Vulture);
            }
            return true;
        }
        return false;
    }
}

