/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.builds;

import bwapi.Game;
import bwapi.Player;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.UpgradeType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Settings;
import com.tyr.StopWatch;
import com.tyr.Tyr;
import com.tyr.UnitTracker;
import com.tyr.agents.Agent;
import com.tyr.buildingplacement.SpaceManager;
import com.tyr.builds.CompositeBuildOrder;
import com.tyr.builds.ExpandPart;
import com.tyr.builds.GenericPartFactory;
import com.tyr.builds.SupplyDepotPart;
import com.tyr.builds.WorkerScoutPart;
import com.tyr.requirements.DisjRequirement;
import com.tyr.requirements.LinearMax;
import com.tyr.requirements.Requirement;
import com.tyr.requirements.UnitRequirement;
import com.tyr.tasks.AssignScience;
import com.tyr.tasks.DefendBaseTask;
import com.tyr.tasks.PokeTask;
import com.tyr.tasks.SalesmenMarinesTask;
import com.tyr.unitgroups.AttackGroup;
import com.tyr.unitgroups.HomeGroup;
import com.tyr.unitgroups.MineralWorkers;

public class AntiMutaMech
extends CompositeBuildOrder {
    private int turretPos;
    private int depotTurrets = 4;
    private boolean lingRush = false;
    private boolean lurkers = false;
    boolean splitDefenseStarted = false;

    @Override
    public void initialize(Game game, Player self, Tyr bot) {
        final AntiMutaMech thisBuild = this;
        Settings.setRequiredSize(201);
        Settings.setMaximumSize(201);
        Settings.setWorkersPerGas(3);
        bot.bunkers.maximumRepair = 1;
        this.add(new SupplyDepotPart());
        this.add(new WorkerScoutPart(1600));
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setCost(100, 0).create());
        this.add(new GenericPartFactory(UnitType.Terran_Barracks).setMax(5).add(new LinearMax(UnitType.Terran_Command_Center, UnitType.Terran_Barracks, 1, 1, true)).add(new UnitRequirement(UnitType.Terran_Command_Center, 2, true)).create());
        GenericPartFactory academyFactory = new GenericPartFactory(UnitType.Terran_Academy).add(new UnitRequirement(UnitType.Terran_Barracks)).add(new UnitRequirement(UnitType.Terran_Refinery)).add(new UnitRequirement(UnitType.Terran_Command_Center, 2));
        this.add(academyFactory.create());
        this.add(new GenericPartFactory(UnitType.Terran_Engineering_Bay).add(new DisjRequirement().addRequirement(new UnitRequirement(UnitType.Terran_Command_Center, 2)).addRequirement(new Requirement(){

            @Override
            public boolean met() {
                return thisBuild.lingRush;
            }
        })).add(new UnitRequirement(UnitType.Terran_Factory)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Factory).add(new UnitRequirement(UnitType.Terran_Barracks, 1, true)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Starport).add(new UnitRequirement(UnitType.Terran_Factory, 2)).add(new UnitRequirement(UnitType.Terran_Goliath, 6)).add(new UnitRequirement(UnitType.Terran_Engineering_Bay)).add(new UnitRequirement(UnitType.Terran_Factory, 1, true)).add(new UnitRequirement(UnitType.Terran_Command_Center, 2, true)).create());
        this.add(new GenericPartFactory(UnitType.Terran_Science_Facility).add(new UnitRequirement(UnitType.Terran_Factory, 2)).add(new UnitRequirement(UnitType.Terran_Engineering_Bay)).add(new UnitRequirement(UnitType.Terran_Starport, 1, true)).create());
        this.add(new ExpandPart(true));
        bot.taskManager.potentialTasks.add(new AssignScience());
        bot.taskManager.potentialTasks.add(new SalesmenMarinesTask(null, 25, 8, true, 0));
        bot.taskManager.potentialTasks.add(new PokeTask());
        PokeTask.required = 10;
        PokeTask.defendingUnitsNeeded = 10;
        AttackGroup.fearLurkers = true;
        HomeGroup.defendAtNatural = true;
        super.initialize(game, self, bot);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFrame(Game game, Player self, Tyr bot) {
        DebugMessages.addMessage("Going bio.");
        StopWatch watch = new StopWatch();
        watch.start();
        if (!this.lingRush) {
            int lingCount = 0;
            for (Unit unit : EnemyManager.getEnemyUnits()) {
                if (unit.getType() != UnitType.Zerg_Zergling) continue;
                ++lingCount;
            }
            if (lingCount >= 8) {
                this.lingRush = true;
                PokeTask.disable();
            }
        }
        if (!this.splitDefenseStarted && PokeTask.getAttackSent()) {
            bot.taskManager.potentialTasks.add(new DefendBaseTask(SpaceManager.getDefensePos(Tyr.tileToPosition(self.getStartLocation())), Settings.getLargeInvasionDist()));
            this.splitDefenseStarted = true;
        }
        if (this.lingRush) {
            DebugMessages.addMessage("Zergling rush!");
        }
        if (!this.lurkers) {
            for (Unit enemy : EnemyManager.getEnemyUnits()) {
                if (enemy.getType() != UnitType.Zerg_Lurker && enemy.getType() != UnitType.Zerg_Hydralisk && enemy.getType() != UnitType.Zerg_Hydralisk_Den) continue;
                this.lurkers = true;
            }
        }
        Settings.setDefendStart(bot.defensiveStructures.size() <= 1 && this.splitDefenseStarted);
        SalesmenMarinesTask.paused = this.lurkers && self.completedUnitCount(UnitType.Terran_Science_Vessel) == 0;
        super.onFrame(game, self, bot);
        long time = watch.time();
        if (time > 55L) {
            DebugMessages.addMessage("Bio super time: " + time);
        }
        boolean bl = bot.bunkers.disabled = self.completedUnitCount(UnitType.Terran_Marine) >= 10 && !PokeTask.getAttackSent();
        if (UnitTracker.count(UnitType.Terran_Engineering_Bay) > 0 && bot.getAvailableGas() < 400) {
            Settings.setWorkersPerGas(3);
        } else if (UnitTracker.count(UnitType.Terran_Barracks) > 5 || UnitTracker.count(UnitType.Terran_Engineering_Bay) > 0) {
            Settings.setWorkersPerGas(2);
        }
        time = watch.time();
        if (time > 55L) {
            DebugMessages.addMessage("Bio tier 1 time: " + time);
        }
        if (!(bot.getAvailableMinerals() < 100 || UnitTracker.getGeyserCount() <= 0 || UnitTracker.count(UnitType.Terran_Command_Center) < 2 && !this.lingRush || UnitTracker.count(UnitType.Terran_Barracks) < 1 || UnitTracker.count(UnitType.Terran_Refinery) != 0 && UnitTracker.count(UnitType.Terran_Starport) <= 0 || UnitTracker.count(UnitType.Terran_Bunker) <= 0)) {
            bot.spaceManager.build(UnitType.Terran_Refinery);
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio refinery: " + time + " geyserCount: " + UnitTracker.getGeyserCount());
        }
        if (bot.getAvailableMinerals() >= 100 && UnitTracker.count(UnitType.Terran_Barracks) >= 1 && UnitTracker.count(UnitType.Terran_Bunker) == 0) {
            bot.spaceManager.build(UnitType.Terran_Bunker, SpaceManager.getDefensePos(SpaceManager.getNatural()));
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio bunker time: " + time);
        }
        if (self.completedUnitCount(UnitType.Terran_Engineering_Bay) >= 1 && bot.getAvailableMinerals() >= 75) {
            void var8_13;
            boolean built = false;
            boolean bl2 = false;
            while (var8_13 < bot.workForce.mineralWorkers.size()) {
                if (!this.lingRush || (var8_13 + this.turretPos) % bot.workForce.mineralWorkers.size() == false || bot.homeGroup.units.size() > 5) {
                    MineralWorkers workers = bot.workForce.mineralWorkers.get((int)((var8_13 + this.turretPos) % bot.workForce.mineralWorkers.size()));
                    if (bot.spaceManager.build(UnitType.Terran_Missile_Turret, null, workers.turretSite)) {
                        built = true;
                        this.turretPos = (var8_13 + this.turretPos + true) % bot.workForce.mineralWorkers.size();
                        break;
                    }
                }
                ++var8_13;
            }
            if (!built) {
                DebugMessages.addMessage("No placement found for any turret.");
            }
        }
        if (bot.getAvailableMinerals() >= 75 && self.completedUnitCount(UnitType.Terran_Missile_Turret) >= 4 && this.depotTurrets > 0) {
            bot.spaceManager.build(UnitType.Terran_Missile_Turret, null, bot.spaceManager.depotBuildSite);
            --this.depotTurrets;
        }
        if ((time = watch.time()) > 55L) {
            DebugMessages.addMessage("Bio turrets time: " + time);
        }
    }

    @Override
    public boolean overrideStructureOrder(Game game, Player self, Tyr bot, Agent agent) {
        if (super.overrideStructureOrder(game, self, bot, agent)) {
            return true;
        }
        if (agent.unit.getType() == UnitType.Terran_Barracks) {
            if (UnitTracker.count(UnitType.Terran_Marine) >= 5 && UnitTracker.count(UnitType.Terran_Command_Center) < 2) {
                return true;
            }
            if (!agent.unit.isTraining() && Tyr.bot.getAvailableGas() >= 25 && Tyr.bot.getAvailableMinerals() >= 50 && self.completedUnitCount(UnitType.Terran_Academy) > 0 && UnitTracker.count(UnitType.Terran_Medic) * 4 < UnitTracker.count(UnitType.Terran_Marine) - 4 * UnitTracker.count(UnitType.Terran_Bunker)) {
                agent.unit.train(UnitType.Terran_Medic);
                return true;
            }
        } else if (agent.unit.getType() == UnitType.Terran_Academy) {
            if (bot.getAvailableGas() >= 150 && bot.getAvailableMinerals() >= 150 && !agent.unit.isResearching()) {
                agent.unit.upgrade(UpgradeType.U_238_Shells);
            }
        } else {
            if (agent.unit.getType() == UnitType.Terran_Starport) {
                if (agent.unit.getAddon() == null && bot.getAvailableMinerals() >= 50 && bot.getAvailableGas() >= 50) {
                    agent.unit.buildAddon(UnitType.Terran_Control_Tower);
                }
                if (!agent.unit.isTraining() && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 225) {
                    agent.unit.train(UnitType.Terran_Science_Vessel);
                }
                return true;
            }
            if (agent.unit.getType() == UnitType.Terran_Factory) {
                if (agent.unit.getAddon() != null && (this.lurkers || bot.homeGroup.units.size() >= 20 && UnitTracker.countTanks() < 2)) {
                    return false;
                }
                if (UnitTracker.usableAddOns(UnitType.Terran_Machine_Shop) == 0 && (this.lurkers || self.completedUnitCount(UnitType.Terran_Factory) >= 2) && !agent.unit.isTraining()) {
                    UnitTracker.addAddOn(UnitType.Terran_Machine_Shop);
                    agent.unit.buildAddon(UnitType.Terran_Machine_Shop);
                }
                if (UnitTracker.count(UnitType.Terran_Armory) >= 1 && !agent.unit.isTraining() && bot.getAvailableMinerals() >= 100 && bot.getAvailableGas() >= 50) {
                    agent.unit.train(UnitType.Terran_Goliath);
                }
                return true;
            }
            if (agent.unit.getType() == UnitType.Terran_Science_Facility) {
                if (!self.hasResearched(TechType.Irradiate) && bot.getAvailableMinerals() >= 200 && bot.getAvailableGas() >= 200) {
                    agent.unit.research(TechType.Irradiate);
                    return true;
                }
                return false;
            }
            if (agent.unit.getType() == UnitType.Terran_Machine_Shop) {
                if (!(agent.unit.isResearching() || this.lurkers && !self.hasResearched(TechType.Tank_Siege_Mode) || bot.getAvailableMinerals() < 100 || bot.getAvailableGas() < 100)) {
                    agent.unit.upgrade(UpgradeType.Charon_Boosters);
                }
            } else {
                if (agent.unit.getType() == UnitType.Terran_Engineering_Bay) {
                    return false;
                }
                if (agent.unit.getType() == UnitType.Terran_Armory) {
                    if (bot.getAvailableMinerals() >= UpgradeType.Terran_Vehicle_Weapons.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Vehicle_Weapons.gasPrice()) {
                        agent.unit.upgrade(UpgradeType.Terran_Vehicle_Weapons);
                    }
                    if (bot.getAvailableMinerals() >= UpgradeType.Terran_Vehicle_Plating.mineralPrice() && bot.getAvailableGas() >= UpgradeType.Terran_Vehicle_Plating.gasPrice()) {
                        agent.unit.upgrade(UpgradeType.Terran_Vehicle_Plating);
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

