/*
 * Decompiled with CFR 0.152.
 */
package com.tyr.agents;

import bwapi.Color;
import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitType;
import com.tyr.DebugMessages;
import com.tyr.EnemyManager;
import com.tyr.Force;
import com.tyr.Tyr;
import com.tyr.agents.Agent;
import com.tyr.agents.Command;

public class VesselSupport
extends Command {
    public Force supportedForce;

    public VesselSupport(Agent agent, Force supportedForce) {
        super(agent);
        this.supportedForce = supportedForce;
    }

    @Override
    public void execute(Game game, Player self, Tyr bot) {
        Position target;
        this.agent.drawCircle(Color.Red);
        if (this.supportedForce != null && this.supportedForce.done()) {
            this.supportedForce = null;
        }
        if (this.supportedForce == null || this.supportedForce.disabled()) {
            this.agent.drawCircle(Color.White, 4);
            target = bot.homeGroup.getTarget();
            DebugMessages.addMessage("No force to support!");
        } else {
            target = this.supportedForce.getCenter();
        }
        if (target != null) {
            game.drawLineMap(this.agent.unit.getX(), this.agent.unit.getY(), target.getX(), target.getY(), Color.Green);
        }
        for (Unit enemy : EnemyManager.getEnemyUnits()) {
            if (this.agent.unit.getEnergy() < 75 || !self.hasResearched(TechType.Irradiate)) {
                this.agent.drawCircle(Color.Blue, 6);
                break;
            }
            if (enemy.getType() != UnitType.Zerg_Mutalisk && enemy.getType() != UnitType.Zerg_Lurker || enemy.isIrradiated() || enemy.getHitPoints() < 80 || this.agent.distanceSquared(enemy) > 160000) continue;
            game.drawLineMap(this.agent.unit.getX(), this.agent.unit.getY(), enemy.getX(), enemy.getY(), Color.Green);
            this.agent.unit.useTech(TechType.Irradiate, enemy);
            return;
        }
        this.agent.unit.move(target);
    }

    @Override
    public boolean replace(Command command) {
        return true;
    }
}

