/*
 * Decompiled with CFR 0.152.
 */
package com.tyr;

import bwapi.Text.Size.Enum;
import bwapi.Unit;
import com.tyr.Settings;
import com.tyr.Tyr;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DebugMessages {
    private static ArrayList<String> messages = new ArrayList();
    private static ArrayList<String> permanentMessages = new ArrayList();
    private static File file;
    public static HashMap<Unit, String> unitInfo;

    static {
        unitInfo = new HashMap();
    }

    public static void addMessage(String message) {
        messages.add(message);
    }

    public static void addMessagePermanent(String message) {
        permanentMessages.add(message);
    }

    public static void toScreen() {
        int i = 0;
        while (i < permanentMessages.size()) {
            Tyr.game.setTextSize(Enum.Small);
            Tyr.game.drawTextScreen(10, 25 + i * 15, permanentMessages.get(i));
            ++i;
        }
        i = 0;
        while (i < messages.size()) {
            Tyr.game.setTextSize(Enum.Small);
            Tyr.game.drawTextScreen(10, 25 + (i + permanentMessages.size()) * 15, messages.get(i));
            ++i;
        }
        for (Map.Entry<Unit, String> entry : unitInfo.entrySet()) {
            Tyr.game.drawTextMap(entry.getKey().getX(), entry.getKey().getY(), entry.getValue());
        }
        messages = new ArrayList();
    }

    private static void createFile() {
        file = DebugMessages.createFile(Tyr.game.enemy().getRace() + " - " + DebugMessages.getEnemyName() + ".txt");
    }

    private static File createFile(String filename) {
        File result = null;
        try {
            result = new File("bwapi-data\\write\\" + filename);
            try {
                if (!result.exists()) {
                    new File("bwapi-data\\write\\").mkdirs();
                    result.createNewFile();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getEnemyName() {
        ArrayList<String> namefile = DebugMessages.readFile("opponent.txt");
        if (namefile.size() == 0 || !Settings.getDebug()) {
            return Tyr.game.enemy().getName();
        }
        return (String)namefile.get(0);
    }

    public static ArrayList<String> readFile() {
        return DebugMessages.readFile(Tyr.game.enemy().getRace() + " - " + DebugMessages.getEnemyName() + ".txt");
    }

    public static ArrayList<String> readFile(String filename) {
        try {
            File file = new File("bwapi-data\\read\\" + filename);
            if (!file.exists()) {
                return new ArrayList<String>();
            }
            try {
                FileReader reader = new FileReader(file);
                BufferedReader br = new BufferedReader(reader);
                ArrayList<String> result = new ArrayList<String>();
                String nextLine = br.readLine();
                while (nextLine != null) {
                    result.add(nextLine);
                    nextLine = br.readLine();
                }
                br.close();
                return result;
            }
            catch (FileNotFoundException e) {
                return new ArrayList<String>();
            }
            catch (IOException e) {
                return new ArrayList<String>();
            }
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    public static void saveMessage(String message) {
        try {
            if (file == null) {
                DebugMessages.createFile();
            }
            try {
                FileWriter writer = new FileWriter(file, true);
                writer.append(String.valueOf(message) + "\r\n");
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void log(String message) {
        try {
            File log = DebugMessages.createFile("log.txt");
            try {
                FileWriter writer = new FileWriter(log, true);
                writer.append(String.valueOf(message) + "\r\n");
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void testGameEnd(boolean win) {
        try {
            File gameEnd = DebugMessages.createFile("gameEnd.txt");
            try {
                FileWriter writer = new FileWriter(gameEnd, true);
                writer.append(String.valueOf(win ? "win" : "loss") + "\r\n");
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void testGameStart() {
        try {
            DebugMessages.createFile("gameStart.txt");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

