#pragma once

#include "Common.h"

namespace MyBot
{
	/// ش Unit ID, UnitType, Ҽ Player, HitPoint, lastPosition, completed(ǹ ϼ )  صδ ڷᱸ
	///    Ʊ þ   ʾ invisible ° Ǿ   ȸҼ  ľߴ  ǵǱ   ڷᱸ ʿմϴ
	struct UnitInfo
	{
		int             unitID;
		int             lastHealth;
		int             lastShields;
		BWAPI::Player   player;
		BWAPI::Unit     unit;
		BWAPI::Position lastPosition;
		BWAPI::UnitType type;
		bool            completed;

		// ߰
		bool            isLastPositionValid;
		int				lastPositionRecordFrame;
		BWAPI::Position positionBefore;
		int				positionBeforeRecordFrame;

		BWAPI::Position		targetPosition;
		BWTA::BaseLocation*	targetBaseLocation;
		BWAPI::Unit			targetUnit;

		bool            isAssignedToSquad;

		bool			isAssignedAsParasiteTarget;
		bool			isAssignedAsSpawnBroodlingsTarget;
		bool			isAssignedAsEnsnareTarget;
		int				assignedQueenUnit;

		UnitInfo()
			: unitID(0)
			, lastHealth(0)
			, player(nullptr)
			, unit(nullptr)
			, lastPosition(BWAPI::Positions::None)
			, type(BWAPI::UnitTypes::None)
			, completed(false)
		{
			// ߰
			isLastPositionValid = false;
			lastPositionRecordFrame = 0;
			positionBefore = BWAPI::Positions::None;
			positionBeforeRecordFrame = 0;

			isAssignedToSquad = false;
			isAssignedAsParasiteTarget = false;
			isAssignedAsSpawnBroodlingsTarget = false;
			isAssignedAsEnsnareTarget = false;

		}

		const bool operator == (BWAPI::Unit unit) const
		{
			return unitID == unit->getID();
		}

		const bool operator == (const UnitInfo & rhs) const
		{
			return (unitID == rhs.unitID);
		}

		const bool operator < (const UnitInfo & rhs) const
		{
			return (unitID < rhs.unitID);
		}
	};

	typedef std::map<BWAPI::Unit,UnitInfo> UnitAndUnitInfoMap;

	class UnitData
	{
		/// Unit  UnitInfo  Map · ϴ ڷᱸ 
		UnitAndUnitInfoMap						unitAndUnitInfoMap;

		const bool isBadUnitInfo(const UnitInfo & ui) const;

		/// UnitType ı/   
		std::vector<int>						numDeadUnits;
		/// UnitType Ǽ/Ʒߴ   
		std::vector<int>						numCreatedUnits;
		/// UnitType ϴ   īƮ.    ĺ   īƮ
		std::vector<int>						numUnits;

		///   ϴµ ҿǾ Mineral   (󸶳 ظ Ҵ° ϱ )
		int										mineralsLost;
		///   ϴµ ҿǾ Gas   (󸶳 ظ Ҵ° ϱ )
		int										gasLost;

	public:

		UnitData();

		///   Ʈմϴ
		void	updateUnitInfo(BWAPI::Unit unit);

		/// ı/  ڷᱸ մϴ
		void	removeUnit(BWAPI::Unit unit);

		/// Ͱ null  Ǿų, ıǾ Resource_Vespene_Geyser ư Refinery,  ǹ ־ ɷ صξµ  ıǾ  ǹ (Ư, ׶  Ÿ Ҹ ǹ) ͸ մϴ
		void	removeBadUnits();

		///   ϴµ ҿǾ Mineral   (󸶳 ظ Ҵ° ϱ )  մϴ
		int		getMineralsLost()                           const;

		///   ϴµ ҿǾ Gas   (󸶳 ظ Ҵ° ϱ )
		int		getGasLost()                                const;

		/// ش UnitType  ĺ Unit ڸ մϴ
		int		getNumUnits(BWAPI::UnitType t = BWAPI::UnitTypes::None)              const;

		/// ش UnitType  ĺ Unit ı/  մϴ
		int		getNumDeadUnits(BWAPI::UnitType t)          const;

		/// ش UnitType  ĺ Unit Ǽ/Ʒ  մϴ
		int		getNumCreatedUnits(BWAPI::UnitType t)		const;

		std::map<BWAPI::Unit, UnitInfo> & getUnitAndUnitInfoMap();
	};
}