#pragma once

#include "Common.h"
#include "UnitData.h"
#include "BuildOrderQueue.h"
#include "InformationManager.h"
#include "WorkerManager.h"
#include "BuildManager.h"
#include "ConstructionManager.h"
#include "ScoutManager.h"
#include "StrategyManager.h"

namespace MyBot
{
	///  α׷  Ǽ    ȭ鿡 ߰  ǥϴ class
	///  Manager κ  ȸϿ Screen Ȥ Map   ǥմϴ
	class UXManager
	{
		UXManager();

		const int dotRadius = 2;

		//    Screen  ǥմϴ
		void drawGameInformationOnScreen(int x, int y);
		
		/// APM (Action Per Minute) ڸ Screen  ǥմϴ
		void drawAPM(int x, int y);

		/// Players  Screen  ǥմϴ
		void drawPlayers();

		/// Player   (Force)   Screen  ǥմϴ
		void drawForces();



		/// BWTA ̺귯  Map м   Map  ǥմϴ
		void drawBWTAResultOnMap();

		/// Tile Position ׸带 Map  ǥմϴ
		void drawMapGrid();


		/// BuildOrderQueue  Screen  ǥմϴ
		void drawBuildOrderQueueOnScreen(int x, int y);

		/// ConstructionQueue  Screen  ǥմϴ
		void drawConstructionQueueOnScreenAndMap(int x, int y);

		/// Construction  ϱ  ص Tile  Map  ǥմϴ
		void drawReservedBuildingTilesOnMap();

		/// Construction   ϴ Tile  Map  ǥմϴ
		void drawTilesToAvoidOnMap();

		/// Build  ¸ Screen  ǥմϴ
		void drawBuildStatusOnScreen(int x, int y);


		/// Unit  HitPoint  ߰  Map  ǥմϴ
		void drawUnitExtendedInformationOnMap();

		/// UnitType    Screen  ǥմϴ
		void drawUnitStatisticsOnScreen(int x, int y);

		/// Unit  Id  Map  ǥմϴ
		void drawUnitIdOnMap();

		/// Unit  Target  մ  Map  ǥմϴ
		void drawUnitTargetOnMap();

		/// Bullet  Map  ǥմϴ
		void drawBullets();



		/// Worker Unit  ڿä Ȳ Map  ǥմϴ
		void drawWorkerMiningStatusOnMap();

		/// ResourceDepot  Worker ڸ Map  ǥմϴ
		void drawWorkerCountOnMap();

		/// Worker Unit  ¸ Screen  ǥմϴ
		void drawWorkerStateOnScreen(int x, int y);


		///  ¸ Screen  ǥմϴ
		void drawScoutInformation(int x, int y);

	public:
		/// static singleton ü մϴ
		static UXManager &	Instance();

		///  ۵  ȸ ߰  մϴ
		void onStart();

		///     Ӹ ߰  ϰ  Է óմϴ
		void update();
	};

	///  Ȳ    Ͽ ǥϱ  Comparator class
	class CompareWhenStarted
	{
	public:

		CompareWhenStarted() {}

		///  Ȳ    Ͽ ǥϱ  sorting operator
		bool operator() (BWAPI::Unit u1, BWAPI::Unit u2)
		{
			int startedU1 = BWAPI::Broodwar->getFrameCount() - (u1->getType().buildTime() - u1->getRemainingBuildTime());
			int startedU2 = BWAPI::Broodwar->getFrameCount() - (u2->getType().buildTime() - u2->getRemainingBuildTime());
			return startedU1 > startedU2;
		}
	};

}
