#pragma once

#include "Common.h"
#include "InformationManager.h"
#include "StrategyManager.h"
#include "MapTools.h"

namespace MyBot
{
	class Strategy_ScoutTaskManager
	{
		Strategy_ScoutTaskManager();

		///  ÷ :  ڵ尡  Ű ˱ ÷
		bool isToFindError;


		UnitData * enemyUnitData;
		UnitData * myUnitData;
		BWTA::BaseLocation * enemyMainBaseLocation;
		BWTA::BaseLocation * myMainBaseLocation;
		BWTA::BaseLocation * enemyFirstExpansionBaseLocation;
		BWTA::Chokepoint * enemyFirstChokepoint;

		int								currentScoutWorkerStatus;
		int								currentScoutOverlordStatus;
		int								currentScoutZerglingStatus;

		BWAPI::Unit						currentScoutWorker;
		BWAPI::Unit						currentScoutOverlord;
		BWAPI::Unit						currentScoutZergling;

		BWTA::BaseLocation *			currentScoutWorkerTargetBaseLocation;
		BWTA::BaseLocation *			currentScoutOverlordTargetBaseLocation;
		BWTA::BaseLocation *			currentScoutZerglingTargetBaseLocation;
		int								currentScoutTargetDistance;

		int                             currentScoutFreeToVertexIndex;
		std::vector<BWAPI::Position>    enemyBaseRegionVertices;
		BWAPI::Position					currentScoutTargetPosition;

		void							assignScoutIfNeeded();






		///  δ븦  BaseLocation  ã ̵ŵϴ
		void                            moveScoutSquadToFindEnemyBaseLocation();
		
		///  δ븦  BaseLocation  ϱ  ̵ŵϴ
		void							moveScoutSquadToScoutEnemyBaseLocation();

		std::map<BWAPI::Unit, BWAPI::Position> scoutUnitAndPositionMap;

		void							moveScoutSquadToScoutEnemyFirstExpansion();
		void							moveScoutSquadToScoutEnemyOtherExpansion(StrategicTask task);
		void							moveScoutSquadToScoutEnemyOuterChokePoint();
		void							moveScoutSquadToScoutMyOuterChokePoint();
		void							moveScoutSquadToScoutOurFirstExpansion();

		///  δ븦 Empty BaseLocations  ̵ŵϴ
		void                            moveScoutSquadToEmptyBaseLocations();

		/// ۸  δ븦 BaseLocation ġ οŵϴ
		void							moveScoutSquadToBurrowOnBaseLocation();
		/// ۸  δ븦 Ư ġ οŵϴ
		void							moveMultiObstructSquadToScoutBaseLocations();

		///  δ븦  ü  ̵ŵϴ
		void                            moveScoutSquadForEntireMap();


		/// Ŀ  Ȯ  źŵϴ
		void							obstructEnemyExpansionWithLurker();


		void							clearFinishedScoutUnit();

		void                            calculateEnemyRegionVertices();
		BWAPI::Position                 getScoutFleePositionFromEnemyRegionVertices(BWAPI::Unit unit);
		int                             getClosestVertexIndex(BWAPI::Unit unit);

		/// Լ :   BaseLocation  մϴ
		BWTA::BaseLocation*				getNextEmptyBaseLocaionToScout(BWAPI::UnitType unitType = BWAPI::UnitTypes::Zerg_Zergling);
	public:
		/// static singleton ü մϴ
		static Strategy_ScoutTaskManager & Instance();

		void update();

		void drawStatus();
	};
}