#pragma once

#include "Common.h"

#include "UnitData.h"
#include "BuildOrderQueue.h"
#include "InformationManager.h"
#include "WorkerManager.h"
#include "BuildManager.h"
#include "ConstructionManager.h"
#include "ScoutManager.h"
#include "StrategyManager.h"

namespace MyBot
{
	class Strategy_CombatTaskManager {

	public:
		bool isAttackEnemyBaseLocationWorkerStarted;


		enum CombatState {
			defenseMode = 0,										// Ʊ  
			gatherToAttack = 1,										//   Ʊ  ó 
			prepareToAttackStart = 2,								//     ó 
			attackEnemyChokepoint1 = 3, 								//   1  
			attackEnemyChokepoint2 = 4,								//   2  
			attackEnemyChokepoint3 = 5,								//   3  
			attackEnemyBaseLocation = 6,							//  BaseLocation 
			attackMySecondChokepoint,							// Ʊ ι°  
			attackEnemySecondChokepoint,						//  ι°  
			attackEnemyFirstExpansionLocation,					//  ո 
			attackEnemyMainBaseLocation,						//   
			eliminateEnemy = 99										//  Eliminate 
		};

		enum FlyingState {
			moveToSafePosition = 0,									// 
			searchForTarget = 1,									// Ž
			moveToFirstPoint = 2,									// ù° Ʈ ̵
			moveToSecondPoint = 3,									// ι° Ʈ ̵
			moveToThirdPoint = 4,									//  Ʈ ̵
			moveToTarget = 5,										//  ǥ ̵
			attackEnemy = 6											//  
		};

		CombatState combatState;				///   Ȳ
		
		FlyingState flyingState;				///   Ȳ

		BWAPI::Position targetAttackPositionForGroundUnits;
		BWAPI::Position targetAttackPositionForAirUnits;
		BWAPI::Position targetAssemblePositionForGroundUnits;
		BWAPI::Position targetAssemblePositionForAirUnits;

		Strategy_CombatTaskManager() 
		{
			isAttackEnemyBaseLocationWorkerStarted = false;
			combatState = CombatState::defenseMode;

			flyingState = FlyingState::moveToSafePosition;
			concentrationAttackTargetUnit = nullptr;
			mainCombatMutaliskSquadCenterPosition = BWAPI::Positions::None;

			targetAttackPositionForGroundUnits = BWAPI::Positions::None;
			targetAttackPositionForAirUnits = BWAPI::Positions::None;


		};

		/// static singleton ü մϴ
		static Strategy_CombatTaskManager &	Instance();

		void update();

		void blockAndHoldOnChokePoint();
		void attackWithLurkerDrop();
		void defensePositionWithHydralisk();

		void burrowAndAmbushAttackWithLurker();

		void attackEnemyWorkerUnitInMainRegion();
		void attackEnemyBuildingUnitInMainRegion();
		void attackEnemyGroundUnitInOurRegion();
		
		void attackEnemyWithMainCombatMutaliskSquad();
		BWAPI::Position mainCombatMutaliskSquadCenterPosition;

		void attackEnemyWithMainCombatGroundSquad();
		void attackEnemyWithEarlyZerglingSquad();

		bool isTimeToStartAttack();
		bool isTimeToRetreatFromCombat();

		
		/// Լ - unit ̼ 
		void updateUnitMission();
		
		void updateUnitMissionForZerglingAsFindEnemyMainBaseLocation();
		void updateUnitMissionForZerglingAsFastAttack();
		void updateUnitMissionForZerglingAsEliminateAttack();
		void updateUnitMissionForMutaliskAsAttack();
		void updateUnitMissionForOverlord();
		void updateUnitMissionForLurker();
		void updateUnitMissionForQueen();

		void executeEnemyElimination();

		std::map<BWAPI::Unit, BWAPI::Unit> attackerTargetMap;
		BWAPI::Unit concentrationAttackTargetUnit;

		// Լ
		int getNumberOfSameTargeting(BWAPI::Unit targetUnit);

		BWAPI::Unit getNearestEnemyWorker(BWAPI::Position from, int radius);

		BWAPI::Unit getNearestEnemyWorkerForMeleeAttack(BWAPI::Position from, int maxSameAttackerCount = 3);

		BWAPI::Position getNearestEnemyUnitToGroundAttack(BWAPI::Position from);

		BWAPI::Unit getNearestAndWeakestEnemyGroundCombatUnit(BWAPI::Position from);

		bool isThereHealthyFriendUnitAround(BWAPI::Position from, int radius);

		BWAPI::Position getFarthestMineralPosition(BWAPI::Position from, BWTA::BaseLocation* baselocation);

		bool isAllMineralExplored(BWTA::BaseLocation* baselocation);

		BWAPI::Unit getEnemyUnitAroundEnemyChokepointClosestToEnemyFirstExpansionLocation();

		BWAPI::Unit getMostUrgentEnemyUnit();

		bool isImpossibleToWinTheCombat();

		bool isEasyToKillEnemyCombatUnitsWithZergling();

		int enemyCombatUnitCount = 0;
		int enemyWorkerUnitCount = 0;
		int enemyZealotCount = 0;
		int enemyMarineCount = 0;
		int enemyZerglingCount = 0;

		int enemyWorkerUnitAroundEnemyBase = 0;
		int enemyWorkerUnitAroundEnemyChokepoint = 0;
		int enemyCombatUnitAroundEnemyBase = 0;
		int enemyCombatUnitAroundEnemyChokepoint = 0;
		int enemyBuildingAroundEnemyBase = 0;
		int enemyBuildingAroundEnemyChokepoint = 0;
		int enemyDefenseBuildingAroundEnemyBase = 0;
		int enemyDefenseBuildingAroundEnemyChokepoint = 0;

		void updateUnitCount();

		BWTA::BaseLocation* getWeakestEnemyBaseLocationForGroundCombatUnit();

		int getMyUnitCount(BWAPI::Position from, int radius);

		BWAPI::Position getAssemblePositionForGroundAttack(BWAPI::Position from, BWAPI::Position to);

		BWTA::BaseLocation* getWeakestEnemyBaseLocationForMutalisk();

		int getDifficultyToAttackWithMutalisk(BWTA::BaseLocation* baseLocation);

		int getAttractionToAttackWithMutalisk(BWTA::BaseLocation* baseLocation);

		BWAPI::Position getTargetPositionInMapToAttackWithMutalisk();

		BWAPI::Position getTargetPositionToAttackWithMutalisk();

		BWAPI::Unit getAttractiveUnitToAttackForMutalisk(BWAPI::Unit mutalisk);

		void moveMutaliskSquad(BWAPI::Position finalTargetPosition, bool isToAttackBaseLocation = false);

		int getAttackPriority(BWAPI::Unit enemyUnit);

		void swarmTest();
	};
}

