#pragma once

#include "Common.h"

#include "UnitData.h"
#include "BuildOrderQueue.h"
#include "InformationManager.h"
#include "WorkerManager.h"
#include "BuildManager.h"
#include "ConstructionManager.h"
#include "ScoutManager.h"
#include "StrategyManager.h"

namespace MyBot
{
	class Strategy_BuildTaskManager {
		Strategy_BuildTaskManager();
	public:
		/// static singleton ü մϴ
		static Strategy_BuildTaskManager &	Instance();

		void update();

		void executeConstructionTask();
		void executeUnitBuildTask();

		/// ǹ ϳ  ϳ , Tech / Upgrade  ϳ ȵǾ Ѵ
		void checkBuildPreconditionAndBuildOne(StrategicTask task, MetaType metaType);

		/// ǹ̳  limitCount   ´
		void BuildUnitByLimit(StrategicTask task, MetaType metaType, int limitCount);

		/// ϲ 
		bool isAutoWorkerTrainingMode;
		void executeWorkerTraining();

		/// ö 
		bool isAutoSupplyManagementMode;
		void executeSupplyManagement();


	};
}