#include "Strategy_BuildTaskManager.h"

using namespace MyBot;

Strategy_BuildTaskManager & Strategy_BuildTaskManager::Instance()
{
	static Strategy_BuildTaskManager instance;
	return instance;
}

Strategy_BuildTaskManager::Strategy_BuildTaskManager()
{
	isAutoWorkerTrainingMode = false;
	isAutoSupplyManagementMode = false;
}



void Strategy_BuildTaskManager::update()
{
	// 1ʿ 4 
	if (BWAPI::Broodwar->getFrameCount() % 6 != 0) {
		return;
	}

	if (BuildManager::Instance().buildQueue.isEmpty()) {
		isAutoWorkerTrainingMode = true;
		isAutoSupplyManagementMode = true;
	}

	// ڿ      ó Ȯ ڵ ϰ Ѵ
	/*
	if (BWAPI::Broodwar->self()->minerals() > 1000) {
		isAutoWorkerTrainingMode = true;
		isAutoSupplyManagementMode = true;
	}
	else {
		isAutoWorkerTrainingMode = false;
		isAutoSupplyManagementMode = false;
	}
	*/

	//std::cout << "BWAPI::Broodwar->self()->supplyTotal() " << BWAPI::Broodwar->self()->supplyTotal() << std::endl;
	//std::cout << "BWAPI::Broodwar->self()->supplyUsed() " << BWAPI::Broodwar->self()->supplyUsed() << std::endl;

	// supply     2
	if (BWAPI::Broodwar->self()->supplyTotal() > 30 * 2) {
		isAutoWorkerTrainingMode = true;
	}

	/*
	if (BWAPI::Broodwar->self()->supplyUsed() > 20 * 2) {
		isAutoSupplyManagementMode = true;
	}
	*/

	// ϲ  ö 
	executeWorkerTraining();

	executeSupplyManagement();

	executeConstructionTask();

	//TODO : ̸ 
	//moveWorkerToConstructionPlace();

	executeUnitBuildTask();
}


void Strategy_BuildTaskManager::executeUnitBuildTask()
{
	// ش ŭ ߰ ϱ
	// TODO : ġ 
	for (auto it = StrategyManager::Instance().taskList.begin(); it != StrategyManager::Instance().taskList.end(); ) {

		if ((*it).taskGoal == TaskGoalType::Build_Unit_Another) {

			//std::cout << "Build_Unit_Another " << (*it).targetUnitType.c_str() << std::endl;
			for (int i = 0; i < (*it).targetCount; i++) {

				if ((*it).isUrgent) {
					//std::cout << "queueAsHighestPriority " << (*it).targetUnitType.c_str() << std::endl;

					// ġ  task  ִ ġ ״ 
					if ((*it).targetPosition != BWAPI::Positions::None) {
						BuildManager::Instance().buildQueue.queueAsHighestPriority((*it).targetUnitType, BWAPI::TilePosition((*it).targetPosition), false);
					}
					else {
						BuildManager::Instance().buildQueue.queueAsHighestPriority((*it).targetUnitType, false);
					}
				}
				else {
					//std::cout << "queueAsLowestPriority " << (*it).targetUnitType.c_str() << std::endl;
					// ġ  task  ִ ġ ״ 
					if ((*it).targetPosition != BWAPI::Positions::None) {
						BuildManager::Instance().buildQueue.queueAsLowestPriority((*it).targetUnitType, BWAPI::TilePosition((*it).targetPosition), false);
					}
					else {
						BuildManager::Instance().buildQueue.queueAsLowestPriority((*it).targetUnitType, false);
					}
				}
			}
			it = StrategyManager::Instance().taskList.erase(it);
		}
		else {
			++it;
		}
	}

	//   ϱ
	// TODO :   ,    ΰ
	for (auto it = StrategyManager::Instance().taskList.begin(); it != StrategyManager::Instance().taskList.end();) {
		if ((*it).taskGoal == TaskGoalType::Build_Unit_By_Limit) {			
			BuildUnitByLimit(*it, MetaType((*it).targetUnitType), (*it).targetCount);
		}
		++it;
	}
}

void Strategy_BuildTaskManager::executeConstructionTask()
{
	//  BuildStrategy  ϴµ ʿ ּ ǹ ǼѴ
	//  BuildStrategy  ο BuildStrategy  ٲ Ӹ ƴ϶, 
	// BuildStrategy  ȹٲ ʿ ǹ ı/ҵǾ , ʿ ǹ ű Ǽؼ ϵ ϴ ̴

	for (auto & task : StrategyManager::Instance().taskList) {

		/*
		if (task.taskGoal == TaskGoalType::Build_Unit_By_Limit) {

			if (task.targetUnitType == BWAPI::UnitTypes::Zerg_Hydralisk_Den) {
				checkBuildPreconditionAndBuildOne(task, MetaType(BWAPI::UnitTypes::Zerg_Hatchery));
				checkBuildPreconditionAndBuildOne(task, MetaType(BWAPI::UnitTypes::Zerg_Spawning_Pool));
				checkBuildPreconditionAndBuildOne(task, MetaType(BWAPI::UnitTypes::Zerg_Hydralisk_Den));
			}
			else if (task.targetUnitType == BWAPI::UnitTypes::Zerg_Sunken_Colony) {
				checkBuildPreconditionAndBuildOne(task, MetaType(BWAPI::UnitTypes::Zerg_Hatchery));
				checkBuildPreconditionAndBuildOne(task, MetaType(BWAPI::UnitTypes::Zerg_Spawning_Pool));
				checkBuildPreconditionAndBuildOne(task, MetaType(BWAPI::UnitTypes::Zerg_Creep_Colony));
			}
			else if (task.targetUnitType == BWAPI::UnitTypes::Zerg_Spire) {
				checkBuildPreconditionAndBuildOne(task, MetaType(BWAPI::UnitTypes::Zerg_Hatchery));
				checkBuildPreconditionAndBuildOne(task, MetaType(BWAPI::UnitTypes::Zerg_Spawning_Pool));
				checkBuildPreconditionAndBuildOne(task, MetaType(BWAPI::UnitTypes::Zerg_Lair));
				checkBuildPreconditionAndBuildOne(task, MetaType(BWAPI::UnitTypes::Zerg_Spire));
			}
			else if (task.targetUnitType == BWAPI::UnitTypes::Zerg_Queens_Nest) {
				checkBuildPreconditionAndBuildOne(task, MetaType(BWAPI::UnitTypes::Zerg_Hatchery));
				checkBuildPreconditionAndBuildOne(task, MetaType(BWAPI::UnitTypes::Zerg_Spawning_Pool));
				checkBuildPreconditionAndBuildOne(task, MetaType(BWAPI::UnitTypes::Zerg_Lair));
				checkBuildPreconditionAndBuildOne(task, MetaType(BWAPI::UnitTypes::Zerg_Queens_Nest));
			}
		}
		else 
		*/
		if (task.taskGoal == TaskGoalType::Build_Tech) {
			checkBuildPreconditionAndBuildOne(task, MetaType(task.targetTechType));
		}
		else if (task.taskGoal == TaskGoalType::Build_Upgrade) {
			checkBuildPreconditionAndBuildOne(task, MetaType(task.targetUpgradeType));
		}
	}
}
void Strategy_BuildTaskManager::checkBuildPreconditionAndBuildOne(StrategicTask task, MetaType metaType)
{
	// TODO :  ǹ,    üũؼ  Ұ ıǾ ٽ  ϴ  ߿ ڵѴ
	// TODO : SeedPositionStrategy 

	// TODO : Sunken ū  ´
	// TODO : ó  ´

	// metaType  ǹ , ̹ Ǿְų  ̸ ʰ, ׷  Ѵ
	if (metaType.isBuilding()) {

		if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Hatchery)
		{
			if (BWAPI::Broodwar->canMake(BWAPI::UnitTypes::Zerg_Hatchery)
				&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hatchery) == 0
				&& BWAPI::Broodwar->self()->incompleteUnitCount(BWAPI::UnitTypes::Zerg_Hatchery) == 0
				&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Lair) == 0
				&& BWAPI::Broodwar->self()->incompleteUnitCount(BWAPI::UnitTypes::Zerg_Lair) == 0
				&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hive) == 0
				&& BWAPI::Broodwar->self()->incompleteUnitCount(BWAPI::UnitTypes::Zerg_Hive) == 0)
			{
				if (BuildManager::Instance().buildQueue.getItemCount(metaType.getUnitType()) == 0) {
					if (ConstructionManager::Instance().getConstructionQueueItemCount(metaType.getUnitType()) == 0) {
						BuildManager::Instance().buildQueue.queueAsLowestPriority(metaType.getUnitType(), false);
					}
				}
			}
		}
		else if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Lair)
		{
			if (BWAPI::Broodwar->canMake(BWAPI::UnitTypes::Zerg_Lair)
				&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Lair) == 0
				&& BWAPI::Broodwar->self()->incompleteUnitCount(BWAPI::UnitTypes::Zerg_Lair) == 0
				&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hive) == 0
				&& BWAPI::Broodwar->self()->incompleteUnitCount(BWAPI::UnitTypes::Zerg_Hive) == 0)
			{
				if (BuildManager::Instance().buildQueue.getItemCount(metaType.getUnitType()) == 0) {
					BuildManager::Instance().buildQueue.queueAsLowestPriority(metaType.getUnitType(), false);
				}
			}
		}
		else if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Hive)
		{
			if (BWAPI::Broodwar->canMake(BWAPI::UnitTypes::Zerg_Hive)
				&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hive) == 0
				&& BWAPI::Broodwar->self()->incompleteUnitCount(BWAPI::UnitTypes::Zerg_Hive) == 0)
			{
				if (BuildManager::Instance().buildQueue.getItemCount(metaType.getUnitType()) == 0) {
					BuildManager::Instance().buildQueue.queueAsLowestPriority(metaType.getUnitType(), false);
				}
			}
		}
		else if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Greater_Spire)
		{
			if (BWAPI::Broodwar->canMake(BWAPI::UnitTypes::Zerg_Greater_Spire)
				&& BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Greater_Spire) == 0
				&& BWAPI::Broodwar->self()->incompleteUnitCount(BWAPI::UnitTypes::Zerg_Greater_Spire) == 0)
			{
				if (BuildManager::Instance().buildQueue.getItemCount(metaType.getUnitType()) == 0) {
					BuildManager::Instance().buildQueue.queueAsLowestPriority(metaType.getUnitType(), false);
				}
			}
		}
		else {
			if (BWAPI::Broodwar->canMake(metaType.getUnitType())
				&& BWAPI::Broodwar->self()->completedUnitCount(metaType.getUnitType()) == 0
				&& BWAPI::Broodwar->self()->incompleteUnitCount(metaType.getUnitType()) == 0)
			{
				if (BuildManager::Instance().buildQueue.getItemCount(metaType.getUnitType()) == 0) {
					if (ConstructionManager::Instance().getConstructionQueueItemCount(metaType.getUnitType()) == 0) {
						BuildManager::Instance().buildQueue.queueAsLowestPriority(metaType.getUnitType(), false);
					}
				}
			}

		}
	}
	// metaType  Tech / Upgrade  , ̹ ġǾְų ġ ̸ ʰ, ׷  Ѵ
	else if (metaType.isTech())
	{
		BWAPI::UnitType producerType = metaType.whatBuilds();
		BWAPI::UnitType requiredUnitType = metaType.getTechType().requiredUnit();

		if (BWAPI::Broodwar->self()->hasResearched(metaType.getTechType()) == false
			&& BWAPI::Broodwar->self()->isResearching(metaType.getTechType()) == false) 
		{
			// ο ġ ó Ӹ ƴ϶ , ̺꿡 , BWAPI 4.1.2  ó 
			/*
			bool isThereProducer = false;
			if (producerType == BWAPI::UnitTypes::Zerg_Hatchery) {
				isThereProducer = (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hatchery) + BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Lair) + BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hive) > 0);
			}
			else {
				isThereProducer = (BWAPI::Broodwar->self()->completedUnitCount(producerType) > 0);
			}

			if (isThereProducer) {
			*/
			if (true) {
				if (BuildManager::Instance().buildQueue.getItemCount(metaType.getTechType()) == 0) {
					//std::cout << "Build_Tech : " << metaType.getTechType().c_str()
					//	<< " hasResearched " << BWAPI::Broodwar->self()->hasResearched(metaType.getTechType())
					//	<< " isResearching " << BWAPI::Broodwar->self()->isResearching(metaType.getTechType())
					//	<< " producer Count " << BWAPI::Broodwar->self()->completedUnitCount(producerType)
					//	<< " getItemCount " << BuildManager::Instance().buildQueue.getItemCount(metaType.getTechType())
					//	<< std::endl;
										
					BuildManager::Instance().buildQueue.queueAsLowestPriority(metaType.getTechType(), task.isUrgent);
				}
			}
		}
	}
	else if (metaType.isUpgrade())
	{
		BWAPI::UnitType producerType = metaType.whatBuilds();
		BWAPI::UnitType requiredUnitType = metaType.getUpgradeType().whatsRequired();

		if (BWAPI::Broodwar->self()->getUpgradeLevel(metaType.getUpgradeType()) < task.targetCount
			&& BWAPI::Broodwar->self()->isUpgrading(metaType.getUpgradeType()) == false) {

			// ε ׷̵  Ӹ ƴ϶ ̺꿡 , BWAPI 4.1.2   
			/*
			bool isThereProducer = false;
			if (producerType == BWAPI::UnitTypes::Zerg_Lair) {
				isThereProducer = (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Lair) + BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hive ) > 0);
			}
			//  ׷̵ ̾ Ӹ ƴ϶ ׷ ̾ , BWAPI 4.1.2   
			else if (producerType == BWAPI::UnitTypes::Zerg_Spire) {
				isThereProducer = (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Spire) + BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Greater_Spire) > 0);
			}
			else {
				isThereProducer = (BWAPI::Broodwar->self()->completedUnitCount(producerType) > 0);
			}

			if (isThereProducer) {
			*/
			if (true) {
				if (BuildManager::Instance().buildQueue.getItemCount(metaType.getUpgradeType()) == 0) {

					//std::cout << "Build_Upgrade : " << metaType.getUpgradeType().c_str()
					//	<< " task.targetCount " << task.targetCount
					//	<< " getUpgradeLevel " << BWAPI::Broodwar->self()->getUpgradeLevel(metaType.getUpgradeType())
					//	<< " isUpgrading " << BWAPI::Broodwar->self()->isUpgrading(metaType.getUpgradeType())
					//	<< " producer Count " << BWAPI::Broodwar->self()->completedUnitCount(producerType)
					//	<< " getItemCount " << BuildManager::Instance().buildQueue.getItemCount(metaType.getUpgradeType())
					//	<< std::endl;

					BuildManager::Instance().buildQueue.queueAsLowestPriority(metaType.getUpgradeType(), task.isUrgent);
				}
			}
		}
	}

}

void Strategy_BuildTaskManager::BuildUnitByLimit(StrategicTask task, MetaType metaType, int limitCount)
{
	// TODO : SeedPositionStrategy

	// metaType  ǹ 
	int currentCount = 0;
	int currentCreepColonyCount = 0;
	int currentCreepColonyCompletedCount = 0;

	if (metaType.isBuilding()) {

		if (BWAPI::Broodwar->canMake(metaType.getUnitType())) {

			currentCount += BWAPI::Broodwar->self()->completedUnitCount(metaType.getUnitType()) + BWAPI::Broodwar->self()->incompleteUnitCount(metaType.getUnitType());
			currentCount += BuildManager::Instance().buildQueue.getItemCount(metaType.getUnitType());
			currentCount += ConstructionManager::Instance().getConstructionQueueItemCount(metaType.getUnitType());
			
			// TODO : ū, 
			if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Sunken_Colony
				|| metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Spore_Colony) 
			{
				currentCreepColonyCompletedCount = BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Creep_Colony);
				currentCreepColonyCount += BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Creep_Colony) + BWAPI::Broodwar->self()->incompleteUnitCount(BWAPI::UnitTypes::Zerg_Creep_Colony);
				currentCreepColonyCount += BuildManager::Instance().buildQueue.getItemCount(BWAPI::UnitTypes::Zerg_Creep_Colony);
				currentCreepColonyCount += ConstructionManager::Instance().getConstructionQueueItemCount(BWAPI::UnitTypes::Zerg_Creep_Colony);

				//std::cout << "BuildUnitByLimit : Zerg_Sunken_Colony " 
				//	<< " limitCount " << limitCount
				//	<< " currentCount " << currentCount
				//	<< " currentCreepColonyCompletedCount " << currentCreepColonyCompletedCount
				//	<< " currentCreepColonyCount " << currentCreepColonyCount
				//	<< std::endl;

				if (currentCount + currentCreepColonyCount < limitCount) {

					// ũ ݷδϸ Ǽ ϰ 
					if (BuildManager::Instance().buildQueue.getItemCount(BWAPI::UnitTypes::Zerg_Creep_Colony) == 0
						&& ConstructionManager::Instance().getConstructionQueueItemCount(BWAPI::UnitTypes::Zerg_Creep_Colony) == 0) {

						BWAPI::TilePosition seedPosition;

						// TODO : ū ݷδ ġ 
						if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Sunken_Colony) {
							// ո ȸԾ 
							if (InformationManager::Instance().hasBuildingAroundBaseLocation(StrategyManager::Instance().myFirstExpansionBaseLocation, 
									InformationManager::Instance().selfPlayer, 10) == false) 
							{								
								seedPosition = StrategyManager::Instance().myMainBaseLocation->getTilePosition();
							}
							// ո Ծ 
							else {
								//     , ʿ , ū  
								seedPosition = StrategyManager::Instance().myFirstExpansionBaseLocation->getTilePosition();
							}
						}
						// TODO :  ݷδ ġ 
						else if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Spore_Colony) {
							seedPosition = StrategyManager::Instance().myMainBaseLocation->getTilePosition();
						}

						BWAPI::TilePosition possiblePosition = ConstructionPlaceFinder::Instance().getBuildLocationNear(BWAPI::UnitTypes::Zerg_Creep_Colony, seedPosition);
						if (possiblePosition != BWAPI::TilePositions::None) {
							BuildManager::Instance().buildQueue.queueAsLowestPriority(BWAPI::UnitTypes::Zerg_Creep_Colony, possiblePosition, false);
							//std::cout << "queueAsLowestPriority Zerg_Creep_Colony at " << possiblePosition.x << "," << possiblePosition.y << std::endl;
							currentCreepColonyCount++;
						}
					}
				}
			}
			else if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Creep_Colony) {
				currentCount = BWAPI::Broodwar->self()->allUnitCount(BWAPI::UnitTypes::Zerg_Creep_Colony);
				currentCount += BuildManager::Instance().buildQueue.getItemCount(BWAPI::UnitTypes::Zerg_Creep_Colony);
				currentCount += ConstructionManager::Instance().getConstructionQueueItemCount(BWAPI::UnitTypes::Zerg_Creep_Colony);
				currentCount += BWAPI::Broodwar->self()->allUnitCount(BWAPI::UnitTypes::Zerg_Sunken_Colony);
				currentCount += BuildManager::Instance().buildQueue.getItemCount(BWAPI::UnitTypes::Zerg_Sunken_Colony);
				currentCount += ConstructionManager::Instance().getConstructionQueueItemCount(BWAPI::UnitTypes::Zerg_Sunken_Colony);
			}
			else if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Lair) {
				for (auto & unit : BWAPI::Broodwar->self()->getUnits()) {
					if (unit == nullptr || unit->exists() == false) continue;
					if (unit->getType() == BWAPI::UnitTypes::Zerg_Lair && unit->isMorphing() == true) {
						currentCount++;
					}
				}
			}
			else if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Hive) {
				for (auto & unit : BWAPI::Broodwar->self()->getUnits()) {
					if (unit == nullptr || unit->exists() == false) continue;
					if (unit->getType() == BWAPI::UnitTypes::Zerg_Hive && unit->isMorphing() == true) {
						currentCount++;
					}
				}
			}
			else if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Greater_Spire) {
				for (auto & unit : BWAPI::Broodwar->self()->getUnits()) {
					if (unit == nullptr || unit->exists() == false) continue;
					if (unit->getType() == BWAPI::UnitTypes::Zerg_Greater_Spire && unit->isMorphing() == true) {
						currentCount++;
					}
				}
			}
			else if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Lurker) {
				for (auto & unit : BWAPI::Broodwar->self()->getUnits()) {
					if (unit == nullptr || unit->exists() == false) continue;
					if (unit->getType() == BWAPI::UnitTypes::Zerg_Lurker_Egg && unit->isMorphing() == true) {
						currentCount++;
					}
				}
			}
			else if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Guardian) {
				for (auto & unit : BWAPI::Broodwar->self()->getUnits()) {
					if (unit == nullptr || unit->exists() == false) continue;
					if (unit->getType() == BWAPI::UnitTypes::Zerg_Cocoon && unit->isMorphing() == true && unit->getBuildType() == BWAPI::UnitTypes::Zerg_Guardian) {
						currentCount++;
					}
				}
			}
			else if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Devourer) {
				for (auto & unit : BWAPI::Broodwar->self()->getUnits()) {
					if (unit == nullptr || unit->exists() == false) continue;
					if (unit->getType() == BWAPI::UnitTypes::Zerg_Cocoon && unit->isMorphing() == true && unit->getBuildType() == BWAPI::UnitTypes::Zerg_Devourer) {
						currentCount++;
					}
				}
			}

			if (currentCount < limitCount) {

				// ū  ũ  ־ Ѵ
				if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Sunken_Colony
					|| metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Spore_Colony) 
				{
					if (currentCreepColonyCompletedCount == 0) {
						return;
					}
				}

				//std::cout << "BuildUnitByLimit : " << metaType.getUnitType().c_str()
				//	<< " limitCount " << limitCount
				//	<< " currentCount " << currentCount
				//	<< std::endl;


				if (metaType.getUnitType() == BWAPI::UnitTypes::Zerg_Creep_Colony) {
					BWAPI::TilePosition possiblePosition = BWAPI::TilePositions::None;
					for (auto & chokepoint : StrategyManager::Instance().frontlineChokepointList) {
						possiblePosition = ConstructionPlaceFinder::Instance().getBuildLocationNear(BWAPI::UnitTypes::Zerg_Creep_Colony, BWAPI::TilePosition(chokepoint->getCenter()));
						if (possiblePosition != BWAPI::TilePositions::None) {
							BuildManager::Instance().buildQueue.queueAsHighestPriority(BWAPI::UnitTypes::Zerg_Creep_Colony, possiblePosition, true);
							//std::cout << "queueAsLowestPriority Zerg_Creep_Colony at " << possiblePosition.x << "," << possiblePosition.y << std::endl;
							break;
						}
					}

					if (possiblePosition == BWAPI::TilePositions::None) {
						possiblePosition = ConstructionPlaceFinder::Instance().getBuildLocationNear(BWAPI::UnitTypes::Zerg_Creep_Colony, StrategyManager::Instance().myFirstExpansionBaseLocation->getTilePosition());
						if (possiblePosition != BWAPI::TilePositions::None) {
							BuildManager::Instance().buildQueue.queueAsHighestPriority(BWAPI::UnitTypes::Zerg_Creep_Colony, possiblePosition, true);
							//std::cout << "queueAsLowestPriority Zerg_Creep_Colony at " << possiblePosition.x << "," << possiblePosition.y << std::endl;
						}
					}

					if (possiblePosition == BWAPI::TilePositions::None) {
						possiblePosition = ConstructionPlaceFinder::Instance().getBuildLocationNear(BWAPI::UnitTypes::Zerg_Creep_Colony, StrategyManager::Instance().myMainBaseLocation->getTilePosition());
						if (possiblePosition != BWAPI::TilePositions::None) {
							BuildManager::Instance().buildQueue.queueAsHighestPriority(BWAPI::UnitTypes::Zerg_Creep_Colony, possiblePosition, true);
							//std::cout << "queueAsLowestPriority Zerg_Creep_Colony at " << possiblePosition.x << "," << possiblePosition.y << std::endl;
						}
					}
				}
				else {
					BuildManager::Instance().buildQueue.queueAsHighestPriority(metaType.getUnitType(), true);
				}

			}
		}
	}
	// metaType  ǹ ƴ   
	else if (metaType.isUnit()) {

		if (BWAPI::Broodwar->canMake(metaType.getUnitType()) && BWAPI::Broodwar->self()->supplyUsed() < 390) {
			currentCount += BWAPI::Broodwar->self()->completedUnitCount(metaType.getUnitType()) + BWAPI::Broodwar->self()->incompleteUnitCount(metaType.getUnitType());
			currentCount += BuildManager::Instance().buildQueue.getItemCount(metaType.getUnitType());
						
			//std::cout << "BuildUnitByLimit : " << metaType.getUnitType().c_str()
			//	<< " limitCount " << limitCount
			//	<< " currentCount " << currentCount
			//	<< std::endl;

			if (BWAPI::Broodwar->self()->getRace() == BWAPI::Races::Zerg) {

				for (auto & unit : BWAPI::Broodwar->self()->getUnits())
				{
					if (unit == nullptr || unit->exists() == false) continue;
					if (unit->getType() == BWAPI::UnitTypes::Zerg_Egg) {
						// Zerg_Egg  morph   isMorphing = true, isBeingConstructed = true, isConstructing = true  ȴ
						// Zerg_Egg  ٸ  ٲ鼭     isBeingConstructed = true, isConstructing = true  Ǿٰ, 
						if (unit->isMorphing() && unit->getBuildType() == metaType.getUnitType()) {

							if (metaType.getUnitType().isTwoUnitsInOneEgg()) {
								currentCount+=2;
							}
							else {
								currentCount++;
							}
						}
					}
				}
			}

			if (currentCount < limitCount) {
				if (BuildManager::Instance().buildQueue.getItemCount(metaType.getUnitType()) == 0) 
				{
					BuildManager::Instance().buildQueue.queueAsLowestPriority(metaType.getUnitType(), false);
				}
			}
		}

	}
}



// ϲ  ߰ 
void Strategy_BuildTaskManager::executeWorkerTraining()
{
	// isAutoWorkerTrainingMode  ƴϸ  ʽϴ
	if (isAutoWorkerTrainingMode == false) {
		return;
	}

	if (BWAPI::Broodwar->self()->minerals() >= 50) {

		// workerCount =  ϲ  +  ϲ 
		int workerCount = BWAPI::Broodwar->self()->allUnitCount(InformationManager::Instance().getWorkerType());

		if (BWAPI::Broodwar->self()->getRace() == BWAPI::Races::Zerg) {

			for (auto & unit : BWAPI::Broodwar->self()->getUnits())
			{
				if (unit == nullptr || unit->exists() == false) continue;
				if (unit->getType() == BWAPI::UnitTypes::Zerg_Egg) {
					// Zerg_Egg  morph   isMorphing = true, isBeingConstructed = true, isConstructing = true  ȴ
					// Zerg_Egg  ٸ  ٲ鼭     isBeingConstructed = true, isConstructing = true  Ǿٰ, 
					if (unit->isMorphing() && unit->getBuildType() == BWAPI::UnitTypes::Zerg_Drone) {
						workerCount++;
					}
				}
			}
		}
		else {
			for (auto & unit : BWAPI::Broodwar->self()->getUnits())
			{
				if (unit == nullptr || unit->exists() == false) continue;
				if (unit->getType().isResourceDepot())
				{
					if (unit->isTraining()) {
						workerCount += unit->getTrainingQueue().size();
					}
				}
			}
		}

		//  ϲ  = ̳׶ * 1 +  * 3 + (3 )
		int optimalWorkerCount = 0;
		for (BWTA::BaseLocation* baseLocation : InformationManager::Instance().getOccupiedBaseLocations(InformationManager::Instance().selfPlayer)) {
			optimalWorkerCount += baseLocation->getMinerals().size();
			optimalWorkerCount += baseLocation->getGeysers().size() * 3;
			optimalWorkerCount += 3;
		}

		if (workerCount < optimalWorkerCount ) {
			for (auto & unit : BWAPI::Broodwar->self()->getUnits())
			{
				if (unit == nullptr || unit->exists() == false) continue;
				if (unit->getType().isResourceDepot())
				{
					if (unit->isTraining() == false || unit->getLarva().size() > 0) {

						// ť ϲ  1 ֵ Ѵ
						if (BuildManager::Instance().buildQueue.getItemCount(InformationManager::Instance().getWorkerType()) == 0) {
							//std::cout << "worker enqueue" << std::endl;
							BuildManager::Instance().buildQueue.queueAsLowestPriority(MetaType(InformationManager::Instance().getWorkerType()), false);
						}
					}
				}
			}
		}
	}
}

// Supply DeadLock   SupplyProvider   Ȳ    μ SupplyProvider ߰ Ǽ/Ѵ
void Strategy_BuildTaskManager::executeSupplyManagement()
{
	// isAutoSupplyManagementMode ̰ų
	// ߰ ε尡 ׾ supplyUsed  supplyTotal  Ŀ  ε ڵ 
	// ̹ supplyTotal  200 á ̻ Ѵ
	if ( (isAutoSupplyManagementMode == true 
		|| BWAPI::Broodwar->self()->supplyUsed() > BWAPI::Broodwar->self()->supplyTotal()) 
		&& BWAPI::Broodwar->self()->supplyTotal() < 400) 
	{
		// 1ʿ ѹ 
		if (BWAPI::Broodwar->getFrameCount() % 24 != 0) {
			return;
		}
	
		// ӿ ö  200 , BWAPI  ö  400 ִ
		// ۸ 1 ӿ ö̸ 0.5 , BWAPI  ö̸ 1 Ѵ
		if (BWAPI::Broodwar->self()->supplyTotal() <= 400)
		{
			// ִ larva  (ResourceDepot  * 3) ŭ buildQueue ִ unit   ̹Ƿ, supplyNeededForBuildQueueUnits  Ѵ 
			int supplyNeededForBuildQueueUnits = 0;

			int supplyIncresePlanInBuildQueue = 0;

			int buildQueueUnitCount = 0;
			// 
			int buildQueueUnitCountMax = (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hatchery)
				+ BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Lair)
				+ BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hive)) * 3;

			for (size_t i = 0; i < BuildManager::Instance().buildQueue.size(); i++) {
				BuildOrderItem t = BuildManager::Instance().buildQueue[i];
				if (t.metaType.isUnit() && !t.metaType.isBuilding()) {

					supplyNeededForBuildQueueUnits += t.metaType.getUnitType().supplyRequired();

					supplyIncresePlanInBuildQueue += t.metaType.getUnitType().supplyProvided();

					buildQueueUnitCount++;
					if (buildQueueUnitCount == buildQueueUnitCountMax) {
						break;
					}
				}
			}

			// ִ larva  (ResourceDepot  * 3) * ö 2 ¥  Ѵٰ . 
			// Ʈ, Ŀ     * ö 3 ~ 4 ¥  Ѵٰ ؾ
			int defaultSupplyMargin = (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hatchery)
				+ BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Lair)
				+ BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hive)) * 3 * 2;

			// ߰  : Hatchery    ö 0.5 ~ 1 ¥  ۸,  ۿ ȵǹǷ  ŭ ö  Ȯϸ 
			// Lair   Ŀ ö 2 ¥   -> Ŀ, Żũ  ǹǷ   * 2 ŭ ö  Ȯ
			// Ʈ󸮽ũ ĳ  Ŀ ö 4 ¥  Ʈ󸮽ũ ǳ, ڿ Ѱ谡 Ƿ, ڿ ؼ ִ   * 4 ŭ ö  Ȯ
			if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Lair) > 0
				|| BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Hive) > 0) 
			{
				defaultSupplyMargin = defaultSupplyMargin * 2;
			}

			if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Ultralisk_Cavern) > 0) {
				int possibleUltraliskNumber = std::min(BWAPI::Broodwar->self()->minerals() / 200, BWAPI::Broodwar->self()->gas() / 200);

				defaultSupplyMargin = std::max(defaultSupplyMargin, possibleUltraliskNumber * 4 * 2);
			}

			supplyNeededForBuildQueueUnits = std::max(defaultSupplyMargin, supplyNeededForBuildQueueUnits);

			// currentSupplyShortage  Ѵ
			int currentSupplyShortage = BWAPI::Broodwar->self()->supplyUsed() + supplyNeededForBuildQueueUnits - BWAPI::Broodwar->self()->supplyTotal() - supplyIncresePlanInBuildQueue;
			
			// currentSupplyShortage   ְ, ö̰ 200  ʾ
			if (currentSupplyShortage > 0 && BWAPI::Broodwar->self()->supplyTotal() < 400) {

				// /Ǽ  Supply 
				int onBuildingSupplyCount = 0;

				//   ,  Zerg_Overlord  
				if (BWAPI::Broodwar->self()->getRace() == BWAPI::Races::Zerg) {
					for (auto & unit : BWAPI::Broodwar->self()->getUnits())
					{
						if (unit == nullptr || unit->exists() == false) continue;
						if (unit->getType() == BWAPI::UnitTypes::Zerg_Egg && unit->getBuildType() == BWAPI::UnitTypes::Zerg_Overlord) {
							onBuildingSupplyCount += BWAPI::UnitTypes::Zerg_Overlord.supplyProvided();
						}
						// ¾ Overlord   SupplyTotal  ݿȵǾ, ߰ īƮ  
						if (unit->getType() == BWAPI::UnitTypes::Zerg_Overlord && unit->isConstructing()) {
							onBuildingSupplyCount += BWAPI::UnitTypes::Zerg_Overlord.supplyProvided();
						}
					}
				}
				//   ƴ , Ǽ Protoss_Pylon, Terran_Supply_Depot  
				else {
					onBuildingSupplyCount += ConstructionManager::Instance().getConstructionQueueItemCount(InformationManager::Instance().getBasicSupplyProviderUnitType()) * InformationManager::Instance().getBasicSupplyProviderUnitType().supplyProvided();
				}

				//std::cout << "currentSupplyShortage : " << currentSupplyShortage << " onBuildingSupplyCount : " << onBuildingSupplyCount << std::endl;

				if (currentSupplyShortage > onBuildingSupplyCount) {

					// BuildQueue ֻܿ SupplyProvider    enqueue Ѵ
					bool isToEnqueue = true;
					if (!BuildManager::Instance().buildQueue.isEmpty()) {
						BuildOrderItem currentItem = BuildManager::Instance().buildQueue.getHighestPriorityItem();
						if (currentItem.metaType.isUnit() && currentItem.metaType.getUnitType() == InformationManager::Instance().getBasicSupplyProviderUnitType()) {
							isToEnqueue = false;
						}
					}
					if (isToEnqueue) {
						//std::cout << "enqueue supply provider " << InformationManager::Instance().getBasicSupplyProviderUnitType().getName().c_str() << std::endl;
						BuildManager::Instance().buildQueue.queueAsHighestPriority(MetaType(InformationManager::Instance().getBasicSupplyProviderUnitType()), true);
					}
				}

			}

	}
}
}
