#include "StrategyManager.h"

using namespace MyBot;

StrategyManager & StrategyManager::Instance()
{
	static StrategyManager instance;
	return instance;
}

StrategyManager::StrategyManager()
{
	isToFindError = false;	

	selfPlayer = BWAPI::Broodwar->self();
	selfRace = selfPlayer->getRace();
	enemyPlayer = InformationManager::Instance().enemyPlayer;
	enemyRace = InformationManager::Instance().enemyRace;

	enemyUnitData = &(InformationManager::Instance().getUnitData(InformationManager::Instance().enemyPlayer));
	myUnitData = &(InformationManager::Instance().getUnitData(InformationManager::Instance().selfPlayer));
	enemyMainBaseLocation = InformationManager::Instance().getMainBaseLocation(InformationManager::Instance().enemyPlayer);
	myMainBaseLocation = InformationManager::Instance().getMainBaseLocation(InformationManager::Instance().selfPlayer);
	myFirstExpansionBaseLocation = InformationManager::Instance().getFirstExpansionLocation(InformationManager::Instance().selfPlayer);
	myFirstChokepoint = InformationManager::Instance().getFirstChokePoint(InformationManager::Instance().selfPlayer);
	enemyFirstExpansionBaseLocation = InformationManager::Instance().getFirstExpansionLocation(InformationManager::Instance().enemyPlayer);
	enemyFirstChokepoint = InformationManager::Instance().getFirstChokePoint(InformationManager::Instance().enemyPlayer);

	for (BWTA::BaseLocation * baseLocation : BWTA::getBaseLocations()) {
		if (baseLocation == myMainBaseLocation) {
			baseLocationStatusMap[baseLocation] = LocationInfo(LocationStatus::My_MainBase);
		}
		else {
			baseLocationStatusMap[baseLocation] = LocationInfo(LocationStatus::LocationStatus_Unknown);
		}
	}
	for (BWTA::Chokepoint * chokepoint : BWTA::getChokepoints()) {
		chokepointStatusMap[chokepoint] = LocationInfo(LocationStatus::LocationStatus_Unknown);
	}

	myOldBuildStrategy = myCurrentBuildStrategy = BuildStrategy::BuildStrategy_Unknown;
	myOldCombatStrategy = myCurrentCombatStrategy = CombatStrategy::CombatStrategy_Unknown;
	enemyOldBuildStrategy = enemyCurrentBuildStrategy = BuildStrategy::BuildStrategy_Unknown;
	enemyOldCombatStrategy = enemyCurrentCombatStrategy = CombatStrategy::CombatStrategy_Unknown;

	//  
	isToScoutWithOverlord = true;
	isToScoutWithWorker = false;
	isToScoutWithZergling = true;
	isToScoutWithScourge = false;
	isToScoutWithQueen = false;
	workerScoutCondition_completedWorkerCount = -1;
	zerglingScouterNumberFromCombatSquad = 1;
	isEnemyHasDangerousUnitToOverlord = false;

	isToBurrowOnEmptyBaseLocation = true;
	isToBurrowAndAmbushAttackWithLurker = true;

	// ո Ǽ
	isAlreadySentFirstExpansionHatcheryDrone = false;
	isAlreadySentFirstExpansionCreepColonyDrone = false;

	lastFrameOfExpansionStart = 0;
	lastFrameOfScoutEnemyBaseLocation = 0;
	lastFrameOfMultiObstructZerglingSquad = 0;

	//  
	isToMakeQueen = false;
	isToMakeGuardian = false;
	isToMakeDevourer = false;
	isToMakeUltralisk = false;


	// Ƽ Ȯ
	numRiskToStartToConstructFirstExpansion = true;
	lastFrameOfConstructHatcheryOnFirstExpansion = 0;
	lastFrameOfConstructCreepColonyOnFirstExpansion = 0;
	numRiskToStartToConstructSecondExpansion = false;
	isStartedToConstructSecondExpansion = false;

	// 
	safeLevel1Positions = new std::set<BWAPI::WalkPosition>();
	safeLevel5Positions = new std::set<BWAPI::WalkPosition>();
	safeLevel9Positions = new std::set<BWAPI::WalkPosition>();

	// Nuke 
	nukeDetectedPosition = BWAPI::Positions::None;
	nukeDetectedFrame = -1;
	isEnemyHasNuclearMissile = false;

	// fakeMineral 
	isFakeMineralCleared = false;
	fakeMineralClearWorker = nullptr;

	// confidenceMap 
	auto & theMap = BWEM::Map::Instance();
	confidenceMapForMutalisk = new ConfidenceMap(&theMap);
	confidenceMapForZergling = new ConfidenceMap(&theMap);
	
	setWord();
}

void StrategyManager::onStart()
{
	if (isToFindError) std::cout << "<s";

	updateInformations();

	//    εմϴ
	//loadGameRecordList();

	if (isToFindError) std::cout << "1";

	//   Ǵ
	figureOutEnemyStrategy();

	if (isToFindError) std::cout << "2";

	//    ؼ Ʊ  
	updateMyStrategy();

	if (isToFindError) std::cout << "3";

	// ʹݿ ڱֵ, Ʊ   ؼ Ǯ ؼ Ѵ
	setInitialBuildOrder();

	if (isToFindError) std::cout << "4";
	setInitialSquad();
	if (isToFindError) std::cout << "5>";
}

void StrategyManager::onEnd(bool isWinner)
{
	//    + ̹   մϴ
	//saveGameRecordList(isWinner);

	delete safeLevel9Positions;
	delete safeLevel5Positions;
	delete safeLevel1Positions;
}


void StrategyManager::updateInformations(){
	
	// 1ʿ 1 
	if (BWAPI::Broodwar->getFrameCount() % 24 != 0) {
		//return;
	}

	enemyPlayer = InformationManager::Instance().enemyPlayer;
	enemyRace = InformationManager::Instance().enemyRace;

	enemyUnitData = &(InformationManager::Instance().getUnitData(InformationManager::Instance().enemyPlayer));
	myUnitData = &(InformationManager::Instance().getUnitData(InformationManager::Instance().selfPlayer));
	enemyMainBaseLocation = InformationManager::Instance().getMainBaseLocation(InformationManager::Instance().enemyPlayer);
	myMainBaseLocation = InformationManager::Instance().getMainBaseLocation(InformationManager::Instance().selfPlayer);

	// StrategyManager   Ǵ
	myFirstChokepoint = InformationManager::Instance().getFirstChokePoint(InformationManager::Instance().selfPlayer);
	enemyFirstChokepoint = InformationManager::Instance().getFirstChokePoint(InformationManager::Instance().enemyPlayer);
	myFirstExpansionBaseLocation = InformationManager::Instance().getFirstExpansionLocation(InformationManager::Instance().selfPlayer);
	enemyFirstExpansionBaseLocation = InformationManager::Instance().getFirstExpansionLocation(InformationManager::Instance().enemyPlayer);

	//   ġ  𸣸, ϰ ؼ 
	BWTA::BaseLocation* enemyMainBaseLocationTemporal = enemyMainBaseLocation;
	if (enemyMainBaseLocation == nullptr) {
		while (enemyMainBaseLocationTemporal == nullptr) {
			for (BWTA::BaseLocation* startLocation : BWTA::getStartLocations()) {
				if (rand() % 4 == 0) {
					enemyMainBaseLocationTemporal = startLocation;
					break;
				}
			}
		}
	}
		
	// myFirstChokepoint  myFirstExpansionBaseLocation  fake chokepoint ؼ 
	// (  ¥ ƴϰ, ִ  ƴϰ,      )
	auto & theMap = BWEM::Map::Instance();
	const BWEM::Area* myArea = theMap.GetNearestArea(StrategyManager::Instance().myMainBaseLocation->getTilePosition());
	if (myArea != nullptr) {
		const std::map<const Area *, const std::vector<ChokePoint> *> myChokepointMap = myArea->ChokePointsByArea();
		//std::cout << "myArea " 
		//	<< " base " << myArea->Bases().size()
		//	<< " neighborArea " << myArea->ChokePointsByArea().size()
		//	<< " TopLeft " << myArea->TopLeft().x << "," << myArea->TopLeft().y
		//	<< " BottomRight " << myArea->BottomRight().x << "," << myArea->BottomRight().y
		//	<< std::endl;

		double minDistance = 100000;
		double tempDistance = 0;
		double minDistanceToExpansion = 100000;
		double tempDistanceToExpansion = 0;

		for (auto it = myChokepointMap.begin(); it != myChokepointMap.end(); it++) {
			const Area * area = it->first;
			const std::vector<ChokePoint> * chokepointList = it->second;
			for (size_t i = 0; i < chokepointList->size(); i++) {

				const BWEM::ChokePoint * CP = &((*chokepointList)[i]);
				//std::cout << "ChokePoint " << CP->Center().x << "," << CP->Center().y
				//	<< "IsPseudo " << CP->IsPseudo()
				//	<< "Blocked " << CP->Blocked()
				//	<< std::endl;

				if (CP->IsPseudo() == false && CP->Blocked() == false) {

					tempDistance = BWAPI::Position(CP->Center()).getDistance(enemyMainBaseLocationTemporal->getPosition());

					if (minDistance > tempDistance) {
						minDistance = tempDistance;

						for (auto & chokepoint : BWTA::getChokepoints()) {
							if (chokepoint->getCenter().getDistance(BWAPI::Position(CP->Center())) < 4.0 * TILE_SIZE)
							{
								myFirstChokepoint = chokepoint;
							}
						}
					}

					const std::vector<Base> & bases = area->Bases();
					for (size_t j = 0; j < bases.size(); j++) {
						if (bases[j].Geysers().size() > 0) {

							tempDistanceToExpansion = bases[j].Center().getDistance(myMainBaseLocation->getPosition());

							if (minDistanceToExpansion > tempDistanceToExpansion) {
								minDistanceToExpansion = tempDistanceToExpansion;

								for (auto & baselocation : BWTA::getBaseLocations()) {
									if (baselocation->getPosition().getDistance(bases[j].Center()) < 4.0 * TILE_SIZE)
									{
										myFirstExpansionBaseLocation = baselocation;
									}
								}
							}
						}
					}
				}
			}
		}
	}

	if (enemyMainBaseLocation != nullptr) {
		const BWEM::Area* enemyArea = theMap.GetNearestArea(enemyMainBaseLocationTemporal->getTilePosition());
		if (enemyArea != nullptr) {
			const std::map<const Area *, const std::vector<ChokePoint> *> enemyChokepointMap = enemyArea->ChokePointsByArea();
			double minDistance = 100000;
			double tempDistance = 0;
			double minDistanceToExpansion = 100000;
			double tempDistanceToExpansion = 0;
			for (auto it = enemyChokepointMap.begin(); it != enemyChokepointMap.end(); it++) {
				const Area * area = it->first;
				const std::vector<ChokePoint> * chokepointList = it->second;
				for (size_t i = 0; i < chokepointList->size(); i++) {

					const BWEM::ChokePoint * CP = &((*chokepointList)[i]);

					if (CP->IsPseudo() == false && CP->Blocked() == false) {

						tempDistance = BWAPI::Position(CP->Center()).getDistance(myMainBaseLocation->getPosition());
						if (minDistance > tempDistance) {
							minDistance = tempDistance;

							for (auto & chokepoint : BWTA::getChokepoints()) {
								if (chokepoint->getCenter().getDistance(BWAPI::Position(CP->Center())) < 4.0 * TILE_SIZE)
								{
									enemyFirstChokepoint = chokepoint;
								}
							}
						}
						
						const std::vector<Base> & bases = area->Bases();
						for (size_t j = 0; j < bases.size(); j++) {
							if (bases[j].Geysers().size() > 0) {

								tempDistanceToExpansion = bases[j].Center().getDistance(enemyMainBaseLocation->getPosition());

								if (minDistanceToExpansion > tempDistanceToExpansion) {
									minDistanceToExpansion = tempDistanceToExpansion;

									for (auto & baselocation : BWTA::getBaseLocations()) {
										if (baselocation->getPosition().getDistance(bases[j].Center()) < 4.0 * TILE_SIZE)
										{
											enemyFirstExpansionBaseLocation = baselocation;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}


	//   
	frontlineChokepointList.clear();
	frontlinePosition.x = 0;
	frontlinePosition.y = 0;

	if (InformationManager::Instance().getOccupiedBaseLocations(InformationManager::Instance().selfPlayer).size() == 1) {
		frontlineChokepointList.insert(myFirstChokepoint);
		frontlinePosition = myFirstChokepoint->getCenter();
	}
	else if (InformationManager::Instance().getOccupiedBaseLocations(InformationManager::Instance().selfPlayer).size() == 2) 
	{
		// ϴ ո ̶ Ѵ
		// TODO :  StartLocation  Ƽ , frontline  ٸ ̾ Ѵ 
		BWTA::BaseLocation* frontlineBaseLocation = myFirstExpansionBaseLocation;

		const BWEM::Area* myFrontlineArea = theMap.GetArea(frontlineBaseLocation->getTilePosition());
		if (myFrontlineArea != nullptr) {
			const std::map<const Area *, const std::vector<ChokePoint> *> chokepointMap = myFrontlineArea->ChokePointsByArea();

			//double distanceToMyFirstExpansion = StrategyManager::Instance().myMainBaseLocation->getGroundDistance(frontlineBaseLocation);
			//double distanceFromMyFirstExpansionToEnemyMainBaseLocation = StrategyManager::Instance().myFirstExpansionBaseLocation->getGroundDistance(enemyMainBaseLocationTemporal);

			for (auto it = chokepointMap.begin(); it != chokepointMap.end(); it++) {
				const std::vector<ChokePoint> * chokepointList = it->second;
				for (int i = 0; i < (int)(chokepointList->size()); i++) {

					const BWEM::ChokePoint * CP = &((*chokepointList)[i]);

					//    ¥ ƴϰ, ִ  ƴϰ, Ʊ myFirstChokepoint  ƴ,  ߰
					if (CP->IsPseudo() == false && CP->Blocked() == false) {

						// BWEM  CP  BWTA  Chokepoint  ̰ ֱ , CP   Chokepoint  
						double minDistance = 1000000000;
						double tempDistance;
						BWTA::Chokepoint* closestChokepoint;
						for (auto & chokepoint : BWTA::getChokepoints()) {
							tempDistance = chokepoint->getCenter().getDistance(BWAPI::Position(CP->Center()));
							if (minDistance > tempDistance && chokepoint != myFirstChokepoint)
							{
								minDistance = tempDistance;
								closestChokepoint = chokepoint;
							}
						}
						frontlineChokepointList.insert(closestChokepoint);

					}
				}
			}

			for (auto & chokepoint : frontlineChokepointList) {
				frontlinePosition.x += chokepoint->getCenter().x;
				frontlinePosition.y += chokepoint->getCenter().y;
			}
			if (frontlineChokepointList.size() > 0) {
				frontlinePosition.x /= frontlineChokepointList.size();
				frontlinePosition.y /= frontlineChokepointList.size();
			}
		}
	}
	else if (InformationManager::Instance().getOccupiedBaseLocations(InformationManager::Instance().selfPlayer).size() > 2)
	{
		// TODO : Ȯ    frontlinePosition  
		//  ո Ƽ Tile Path  ߰?
		frontlinePosition.x = BWAPI::Broodwar->mapWidth() * TILE_SIZE / 2;
		frontlinePosition.y = BWAPI::Broodwar->mapHeight() * TILE_SIZE / 2;
	}

	// BaseLocation    Ʈ 
	for (auto & it : baseLocationStatusMap) {
		it.second.locationStatus = LocationStatus::LocationStatus_Unknown;
	}

	for (BWTA::BaseLocation * baseLocation : InformationManager::Instance().getOccupiedBaseLocations(InformationManager::Instance().selfPlayer)) {
		baseLocationStatusMap[baseLocation].locationStatus = LocationStatus::My_Occupied;
	}
	baseLocationStatusMap[myMainBaseLocation].locationStatus = LocationStatus::My_MainBase;

	for (BWTA::BaseLocation * baseLocation : InformationManager::Instance().getOccupiedBaseLocations(InformationManager::Instance().enemyPlayer)) {
		baseLocationStatusMap[baseLocation].locationStatus = LocationStatus::Enemy_Occupied;
	}
	if (enemyMainBaseLocation != nullptr) {
		baseLocationStatusMap[enemyMainBaseLocation].locationStatus = LocationStatus::Enemy_MainBase;
	}

	for (BWTA::BaseLocation * baseLocation : BWTA::getBaseLocations()) {
		if (BWAPI::Broodwar->isVisible(baseLocation->getTilePosition())) {
			baseLocationStatusMap[baseLocation].lastVisibleTime = BWAPI::Broodwar->getFrameCount();
		}
	}
	
	// Chokepoint    Ʈ
	for (BWTA::Chokepoint * chokepoint : BWTA::getChokepoints()) {
		if (BWAPI::Broodwar->isVisible(BWAPI::TilePosition(chokepoint->getCenter()))) {
			chokepointStatusMap[chokepoint].lastVisibleTime = BWAPI::Broodwar->getFrameCount();
		}
	}

	// Ȯ ɼ   Ʈ
	numRiskToStartToConstructFirstExpansion = 0;
	for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer)) {
		BWAPI::Unit enemyUnit = it.first;
		UnitInfo & enemyUnitInfo = it.second;

		if (enemyUnitInfo.type.canAttack()
			&& enemyUnitInfo.lastHealth > 0 && enemyUnitInfo.isLastPositionValid == true
			&& enemyUnitInfo.type.isWorker() == false
			&& BWTA::getRegion(enemyUnitInfo.lastPosition) == StrategyManager::Instance().myFirstExpansionBaseLocation->getRegion())
		{
			numRiskToStartToConstructFirstExpansion ++;
		}
	}

	if (ConstructionManager::Instance().getConstructionQueueItemCount(BWAPI::UnitTypes::Zerg_Hatchery) > 0) {
		std::vector<ConstructionTask> * constructionQueue = ConstructionManager::Instance().getConstructionQueue();

		for (const auto & b : *constructionQueue)
		{
			if (b.type == BWAPI::UnitTypes::Zerg_Hatchery) {

				if (b.desiredPosition.getDistance(myFirstExpansionBaseLocation->getTilePosition()) <= 4 * TILE_SIZE) {
					lastFrameOfConstructHatcheryOnFirstExpansion = BWAPI::Broodwar->getFrameCount();
				}
			}
		}
	}

	if (ConstructionManager::Instance().getConstructionQueueItemCount(BWAPI::UnitTypes::Zerg_Creep_Colony) > 0) {
		std::vector<ConstructionTask> * constructionQueue = ConstructionManager::Instance().getConstructionQueue();

		for (const auto & b : *constructionQueue)
		{
			if (b.type == BWAPI::UnitTypes::Zerg_Creep_Colony) {

				if (b.desiredPosition.getDistance(myFirstExpansionBaseLocation->getTilePosition()) <= 8 * TILE_SIZE) {
					lastFrameOfConstructCreepColonyOnFirstExpansion = BWAPI::Broodwar->getFrameCount();
				}
			}
		}
	}


	//BWAPI::Broodwar->drawTextMap(myFirstExpansionBaseLocation->getPosition().x, myFirstExpansionBaseLocation->getPosition().y+50,  
	//	"lastFrameOfConstructHatcheryOnFirstExpansion : %d", lastFrameOfConstructHatcheryOnFirstExpansion);


	numRiskToStartToConstructSecondExpansion = 0;
	isStartedToConstructSecondExpansion = false;

	//sendWord();
}
void StrategyManager::onNukeDetect(BWAPI::Position target)
{
	nukeDetectedPosition = target;
	isEnemyHasNuclearMissile = true;

	if (nukeDetectedFrame <= 0) {
		nukeDetectedFrame = BWAPI::Broodwar->getFrameCount();
	}
}

void StrategyManager::update()
{	
	if (isToFindError) std::cout << "k";

	updateInformations();

	if (BWAPI::Broodwar->getFrameCount() == 5) {
		updateSafePositions();
	}

	if (isToFindError) std::cout << "t";

	updateConfidenceMap();

	if (isToFindError) std::cout << "x";

	// Ȳ Ǵؼ,  ,   update ϰ, 	
	//   Task List  Ʈ Ѵ. 
	updateStatusAndStrategyAndTaskList();
	
	if (isToFindError) std::cout << "y";

	// Ȳ  Task List    Squad    ġ Ѵ
	if (BWAPI::Broodwar->getFrameCount() % 5 == 4) {
		updateSquad();
	}

	if (isToFindError) std::cout << "z1";

	//  Ѵ
	executeScout();
	if (isToFindError) std::cout << "l";

	//      Ÿũ Ѵ
	executeBuild();
	if (isToFindError) std::cout << "m";

	// Ȯ  Ÿũ Ѵ
	executeExpansion();
	if (isToFindError) std::cout << "n";

	//      Ÿũ Ѵ
	executeCombat();
	if (isToFindError) std::cout << "o";

	if (isToFindError) std::cout << "q";

	// ٹ̻
	/*
	if (nukeDetectedFrame > 0) {

		// ٹ̻   : Ʈ  ̰ų, ľ 
		if (BWAPI::Broodwar->getFrameCount() - nukeDetectedFrame < 380) {
			
			BWAPI::Broodwar->drawTextScreen(200, 100, "Nuclear missile will be arrived by %d frame", 380 - (BWAPI::Broodwar->getFrameCount() - nukeDetectedFrame));

			if (nukeDetectedPosition != BWAPI::Positions::Unknown) {
				BWAPI::Broodwar->drawCircleMap(nukeDetectedPosition, 40, BWAPI::Colors::Red, true);
			}
			else {
				if (BWAPI::Broodwar->getFrameCount() - nukeDetectedFrame < 150) {
				}
			}
		}
		// ٹ̻  
		else {
			nukeDetectedFrame = 0;
		}
	}
	*/
		
	// ǹ Ǽ 
	// TODO : Bullet   Ǵ?
	for (auto& unit : BWAPI::Broodwar->self()->getUnits()) {
		if (unit == nullptr || unit->exists() == false) continue;
		if (unit->isMorphing() && unit->getHitPoints() < 20) {
			for (auto & enemyUnit : BWAPI::Broodwar->getUnitsInRadius(unit->getPosition(), 5 * TILE_SIZE)) {
				int enemyCombatUnitCount = 0;
				if (enemyUnit->getPlayer() != BWAPI::Broodwar->self() 
					&& enemyUnit->canAttack() && enemyUnit->getType().isWorker() == false) {
					enemyCombatUnitCount++;
				}
				if (enemyCombatUnitCount >= 2) {
					unit->cancelMorph();
					std::cout << "cancelMorph by danger " << unit->getType().getName().c_str() << " " << unit->getPosition().x / TILE_SIZE << "," << unit->getPosition().y / TILE_SIZE << std::endl;
				}
			}
		}
	}

	if (isToFindError) std::cout << "r";

	// TODO :  ϲ  
	// Ʒ ڵ忡   
	if (WorkerManager::Instance().getNumMineralWorkers() <= 9 
		&& WorkerManager::Instance().getNumGasWorkers() >= 3
		&& (BWAPI::Broodwar->self()->gas() / (BWAPI::Broodwar->self()->minerals()+1)) > 3
		&& BWAPI::Broodwar->self()->minerals() < 200)
	{
		Config::Macro::WorkersPerRefinery = 1;
		/*
		int numGasWorker = 0;
		for (auto & worker : WorkerManager::Instance().getWorkerData().getWorkers()) {
			if (WorkerManager::Instance().getWorkerData().getWorkerJob(worker) == WorkerData::WorkerJob::Gas) {
				numGasWorker++;
				if (numGasWorker > 1){
					WorkerManager::Instance().setIdleWorker(worker);
				}
			}
		}
		*/
	}
	else {
		Config::Macro::WorkersPerRefinery = 3;
	}

	// ū  
	if (BWAPI::Broodwar->self()->allUnitCount(BWAPI::UnitTypes::Zerg_Creep_Colony) >= 1)
	{
		Config::Macro::BuildingDefenseTowerSpacing = 0;
		/*
		int numGasWorker = 0;
		for (auto & worker : WorkerManager::Instance().getWorkerData().getWorkers()) {
		if (WorkerManager::Instance().getWorkerData().getWorkerJob(worker) == WorkerData::WorkerJob::Gas) {
		numGasWorker++;
		if (numGasWorker > 1){
		WorkerManager::Instance().setIdleWorker(worker);
		}
		}
		}
		*/
	}

	if (isToFindError) std::cout << "s";


	if (isToFindError) std::cout << "u";

	// ̹  α׸ ϴ
	//saveGameLog();

	if (isToFindError) std::cout << "v";
}


void StrategyManager::updateConfidenceMap()
{
	// 4 Ӹ 1 Ʈ
	if (BWAPI::Broodwar->getFrameCount() % 4 != 0) {
		return;
	}

	// ϴ,   ̴ ֵ鸸  ConfidenceMap  Ѵ
	for (int j = 0; j < confidenceMapForMutalisk->Height(); ++j) {
		for (int i = 0; i < confidenceMapForMutalisk->Width(); ++i) {
			confidenceMapForMutalisk->GetCell(i, j).clear();
		}
	}

	for (BWAPI::Unit unit : BWAPI::Broodwar->self()->getUnits()) {
		confidenceMapForMutalisk->Add(unit);
	}
	for (BWAPI::Unit unit : InformationManager::Instance().enemyPlayer->getUnits()) {
		confidenceMapForMutalisk->Add(unit);
	}

}


void StrategyManager::updateStatusAndStrategyAndTaskList()
{
	// State Machine  ?
	//  ǿ شϰ Ǹ  State   State  ȯ
	
	//   :
	// Ʊ   Ÿ
	//  
	//  . 2ο . 4ο . 8ο 
	//   
	
	//   Ǵ
	figureOutEnemyStrategy();

	if (isToFindError) std::cout << "v";

	//    ؼ Ʊ  
	updateMyStrategy();

	if (isToFindError) std::cout << "w";

	//   / Ʊ   Ÿũ ߰
	updateScoutTask();

	if (isToFindError) std::cout << "x";

	if (isToFindError) std::cout << "y";
	updateBuildTask();
	if (isToFindError) std::cout << "z2";
	updateCombatTask();
	if (isToFindError) std::cout << "a";
	updateExpansionTask();
	if (isToFindError) std::cout << "b";

	// Ϸ StrategicTask  Ѵ
	clearCompletedTask();
	if (isToFindError) std::cout << "c";
}


void StrategyManager::setInitialBuildOrder()
{
	// ʱ  
	// TODO :  ID  ,  ,  踦 ȰϿ ʱ  

	Strategy_InitialBuildOrderManager::Instance().setInitialBuildOrder();
}

void StrategyManager::updateSquad()
{
	// TODO : Ÿũ ŵǾ ش Ÿũ ϴ Squad    Squad  

	//    ϴ  reservedSquad  Ѵ
	for (auto & kv : InformationManager::Instance().getUnitAndUnitInfoMap(BWAPI::Broodwar->self())) {
		BWAPI::Unit unit = kv.first;
		UnitInfo & ui = kv.second;
		if (unit->getType().isBuilding() == false && ui.isAssignedToSquad == false) {
			reservedSquad.addUnit(unit);
			ui.isAssignedToSquad = true;
		}
	}

	//   Squad  Ѵ
	clearDeadUnitInSquad();

	// ⺻ reservedSquad  ۸  mainBaseDefenseSquad  ߰Ѵ
	moveUnitBetweenSquad(&reservedSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Zergling);

	// ⺻ reservedSquad    mainBaseDefenseSquad  ߰Ѵ
	//  Ŀ ϸ, mainBaseDefenseSquad  ִ Ŀ  
	// Ϻθ ambushCombatLurkerSquad , Ȥ multiObstructLurkerSquad  ԽŲ
	moveUnitBetweenSquad(&reservedSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Hydralisk);
	moveUnitBetweenSquad(&reservedSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Lurker);

	// ⺻ reservedSquad  Ŀ  mainBaseDefenseSquad  ߰Ѵ
	moveUnitBetweenSquad(&reservedSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Scourge);
	// ⺻ reservedSquad    mainBaseDefenseSquad  ߰Ѵ
	moveUnitBetweenSquad(&reservedSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Queen);
	// ⺻ reservedSquad  Ϸ  mainBaseDefenseSquad  ߰Ѵ
	moveUnitBetweenSquad(&reservedSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Defiler);
	// ⺻ reservedSquad  Ʈ󸮽ũ  mainBaseDefenseSquad  ߰Ѵ
	moveUnitBetweenSquad(&reservedSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Ultralisk);

	// ʷ ¾ Żũ mainCombatMutaliskSquad  ԽŲ
	if (mainCombatMutaliskSquad.unitset.size() == 0) {
		moveUnitBetweenSquad(&reservedSquad, &mainCombatMutaliskSquad, BWAPI::UnitTypes::Zerg_Mutalisk);
		moveUnitBetweenSquad(&reinforceMainCombatMutaliskSquad, &mainCombatMutaliskSquad, BWAPI::UnitTypes::Zerg_Mutalisk);
	}
	// ⺻ reservedSquad  Żũ reinforceMainCombatMutaliskSquad  ԽŲ
	else {
		moveUnitBetweenSquad(&reservedSquad, &reinforceMainCombatMutaliskSquad, BWAPI::UnitTypes::Zerg_Mutalisk);
	}
	// reinforceMainCombatMutaliskSquad  mainCombatMutaliskSquad   ϸ ԽŲ
	for (auto it = reinforceMainCombatMutaliskSquad.unitset.begin(); it != reinforceMainCombatMutaliskSquad.unitset.end();) {
		BWAPI::Unit unit = *it;
		if (unit->getDistance(Strategy_CombatTaskManager::Instance().mainCombatMutaliskSquadCenterPosition) < 2 * TILE_SIZE) {
			mainCombatMutaliskSquad.addUnit(unit);
			it = reinforceMainCombatMutaliskSquad.removeUnit(it);
		}
		else {
			++it;
		}
	}


	// Ÿũ ߰Ǿµ ش Ÿũ  Squad    Squad  ġ
	// TODO :  Ÿũ ÿ ϴµ, ü    , 켱   ġ
	for (auto task = StrategyManager::Instance().taskList.begin(); task != StrategyManager::Instance().taskList.end(); task++) {

		//   ̰ų,
		// 3ο ̻ ̾  ̽ ġ ľؾ Ҷ
		if (task->taskGoal == TaskGoalType::Figure_Out_Enemy_Race
			|| task->taskGoal == TaskGoalType::Figure_Out_Enemy_BaseLocation) {

			//  ε δ 1 
			if (isToScoutWithOverlord == true) {
				if (scoutOverlordSquad1.unitset.size() == 0) {
					moveUnitBetweenSquad(&reservedSquad, &scoutOverlordSquad1, BWAPI::UnitTypes::Zerg_Overlord);

					if (getUnitNumberInSquad(&scoutOverlordSquad1, BWAPI::UnitTypes::Zerg_Overlord) == 0) {
						moveUnitBetweenSquad(&mainCombatMutaliskSquad, &scoutOverlordSquad1, BWAPI::UnitTypes::Zerg_Overlord);
					}
				}
				if (scoutOverlordSquad2.unitset.size() == 0) {
					moveUnitBetweenSquad(&reservedSquad, &scoutOverlordSquad2, BWAPI::UnitTypes::Zerg_Overlord);

					if (getUnitNumberInSquad(&scoutOverlordSquad2, BWAPI::UnitTypes::Zerg_Overlord) == 0) {
						moveUnitBetweenSquad(&mainCombatMutaliskSquad, &scoutOverlordSquad2, BWAPI::UnitTypes::Zerg_Overlord);
					}
				}
				if (scoutOverlordSquad3.unitset.size() == 0) {
					moveUnitBetweenSquad(&reservedSquad, &scoutOverlordSquad3, BWAPI::UnitTypes::Zerg_Overlord);

					if (getUnitNumberInSquad(&scoutOverlordSquad3, BWAPI::UnitTypes::Zerg_Overlord) == 0) {
						moveUnitBetweenSquad(&mainCombatMutaliskSquad, &scoutOverlordSquad3, BWAPI::UnitTypes::Zerg_Overlord);
					}
				}
				if (scoutOverlordSquad4.unitset.size() == 0) {
					moveUnitBetweenSquad(&reservedSquad, &scoutOverlordSquad4, BWAPI::UnitTypes::Zerg_Overlord);

					if (getUnitNumberInSquad(&scoutOverlordSquad4, BWAPI::UnitTypes::Zerg_Overlord) == 0) {
						moveUnitBetweenSquad(&mainCombatMutaliskSquad, &scoutOverlordSquad4, BWAPI::UnitTypes::Zerg_Overlord);
					}
				}
				if (scoutOverlordSquad5.unitset.size() == 0) {
					moveUnitBetweenSquad(&reservedSquad, &scoutOverlordSquad5, BWAPI::UnitTypes::Zerg_Overlord);

					if (getUnitNumberInSquad(&scoutOverlordSquad5, BWAPI::UnitTypes::Zerg_Overlord) == 0) {
						moveUnitBetweenSquad(&mainCombatMutaliskSquad, &scoutOverlordSquad5, BWAPI::UnitTypes::Zerg_Overlord);
					}
				}
			}
			else {
				breakUpSquad(&scoutOverlordSquad1);
				breakUpSquad(&scoutOverlordSquad2);
				breakUpSquad(&scoutOverlordSquad3);
				breakUpSquad(&scoutOverlordSquad4);
				breakUpSquad(&scoutOverlordSquad5);
			}

			//   1 
			if (isToScoutWithWorker == true ) {
				if (scoutDroneSquad.unitset.size() == 0) {
					// ϲ workerScoutCondition_completedWorkerCount ڸŭ   
					if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Drone) >= workerScoutCondition_completedWorkerCount
						&& StrategyManager::Instance().workerScoutCondition_completedWorkerCount != -1)
					{
						BWAPI::Unit unit = WorkerManager::Instance().getClosestMineralWorkerTo(myMainBaseLocation->getPosition());
						moveUnitBetweenSquad(&reservedSquad, &scoutDroneSquad, BWAPI::UnitTypes::Zerg_Drone, 1, unit);
						WorkerManager::Instance().setScoutWorker(unit);
					}
				}
			}
			else if (scoutDroneSquad.unitset.size() > 0) {
				breakUpSquad(&scoutDroneSquad);
			}

			if (isToScoutWithZergling == true) {

				// Ϲ  ۸ 1 
				if (myCurrentCombatStrategy != CombatStrategy::Zerg_Combat_4Drone_Zergling_Rush) {
					if (scoutZerglingSquad.unitset.size() == 0)
					{
						moveUnitBetweenSquad(&mainBaseDefenseSquad, &scoutZerglingSquad, BWAPI::UnitTypes::Zerg_Zergling);
						lastFrameOfScoutEnemyBaseLocation = BWAPI::Broodwar->getFrameCount();
					}
				}
				//  ۸  Zerg_Combat_4Drone_Zergling_Rush ϶  ۸  
				else {
					moveUnitBetweenSquad(&mainBaseDefenseSquad, &scoutZerglingSquad, BWAPI::UnitTypes::Zerg_Zergling, 
						getUnitNumberInSquad(&mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Zergling));
					lastFrameOfScoutEnemyBaseLocation = BWAPI::Broodwar->getFrameCount();
				}
			}
		}
		//  ̽ ġ ľǵ ¿,  ̽ /  
		else if (task->taskGoal == TaskGoalType::Scout_Enemy_MainBaseLocation
			|| task->taskGoal == TaskGoalType::Scout_Enemy_First_Expansion
			|| task->taskGoal == TaskGoalType::Scout_Enemy_Other_Expansion
			|| task->taskGoal == TaskGoalType::Scout_Enemy_Chokepoint)
		{
			//  ε δ 1 
			if (isToScoutWithOverlord == true) {
				if (scoutOverlordSquad1.unitset.size() == 0) {
					moveUnitBetweenSquad(&reservedSquad, &scoutOverlordSquad1, BWAPI::UnitTypes::Zerg_Overlord);
				}
				if (scoutOverlordSquad2.unitset.size() == 0) {
					moveUnitBetweenSquad(&reservedSquad, &scoutOverlordSquad2, BWAPI::UnitTypes::Zerg_Overlord);
				}
				if (scoutOverlordSquad3.unitset.size() == 0) {
					moveUnitBetweenSquad(&reservedSquad, &scoutOverlordSquad3, BWAPI::UnitTypes::Zerg_Overlord);
				}
				if (scoutOverlordSquad4.unitset.size() == 0) {
					moveUnitBetweenSquad(&reservedSquad, &scoutOverlordSquad4, BWAPI::UnitTypes::Zerg_Overlord);
				}
				if (scoutOverlordSquad5.unitset.size() == 0) {
					moveUnitBetweenSquad(&reservedSquad, &scoutOverlordSquad5, BWAPI::UnitTypes::Zerg_Overlord);
				}
			}
			else {
				breakUpSquad(&scoutOverlordSquad1);
				breakUpSquad(&scoutOverlordSquad2);
				breakUpSquad(&scoutOverlordSquad3);
				breakUpSquad(&scoutOverlordSquad4);
				breakUpSquad(&scoutOverlordSquad5);
			}

			//   ִ 1 
			if (isToScoutWithWorker == true) {
				if (scoutDroneSquad.unitset.size() == 0) {
					// ϲ workerScoutCondition_completedWorkerCount ڸŭ   
					if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Drone) >= workerScoutCondition_completedWorkerCount
						&& StrategyManager::Instance().workerScoutCondition_completedWorkerCount != -1)
					{
						BWAPI::Unit unit = WorkerManager::Instance().getClosestMineralWorkerTo(myMainBaseLocation->getPosition());
						moveUnitBetweenSquad(&reservedSquad, &scoutDroneSquad, BWAPI::UnitTypes::Zerg_Drone, 1, unit);
						WorkerManager::Instance().setScoutWorker(unit);
					}
				}
			}
			else if (scoutDroneSquad.unitset.size() > 0) {
				breakUpSquad(&scoutDroneSquad);
			}

			// ۸ ּ 4 ʰ߸ ۸ 
			if (isToScoutWithZergling == false) {
				if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Zergling) > 4) {
					isToScoutWithZergling = true;
				}
			}

			//  ۸ zerglingScouterNumberFromCombatSquad  
			if (isToScoutWithZergling == true && (int)(scoutZerglingSquad.unitset.size()) < zerglingScouterNumberFromCombatSquad) {
				
				// Ϲ, ʹ    ۸ ڸ  3и ۸  
				// 
				if (myCurrentCombatStrategy == CombatStrategy::Zerg_Combat_4Drone_Zergling_Rush
					|| lastFrameOfScoutEnemyBaseLocation + 24 * 60 * 3 < BWAPI::Broodwar->getFrameCount())
				{
					moveUnitBetweenSquad(&mainBaseDefenseSquad, &scoutZerglingSquad, BWAPI::UnitTypes::Zerg_Zergling);

					if ((int)(scoutZerglingSquad.unitset.size()) < zerglingScouterNumberFromCombatSquad)
					{
						moveUnitBetweenSquad(&mainCombatZerglingSquad, &scoutZerglingSquad, BWAPI::UnitTypes::Zerg_Zergling);
					}

					if (scoutZerglingSquad.unitset.size() > 0) {
						lastFrameOfScoutEnemyBaseLocation = BWAPI::Broodwar->getFrameCount();
					}
				}
			}
			else if (isToScoutWithZergling == false && scoutZerglingSquad.unitset.size() > 0) {
				breakUpSquad(&scoutZerglingSquad);
			}

			//  Ŀ ⺻  Ŀ  . ߿  δ ġ
			if (isToScoutWithScourge == true) {
				moveUnitBetweenSquad(&reservedSquad, &scoutScourgeSquad, BWAPI::UnitTypes::Zerg_Scourge);
			}
			else if (isToScoutWithScourge == false && scoutScourgeSquad.unitset.size() > 0) {
				breakUpSquad(&scoutScourgeSquad);
			}

			//   ⺻    . ߿  δ ġ
			if (isToScoutWithQueen == true) {
				moveUnitBetweenSquad(&reservedSquad, &scoutQueenSquad, BWAPI::UnitTypes::Zerg_Queen);
			}
			else if (isToScoutWithQueen == false && scoutQueenSquad.unitset.size() > 0) {
				breakUpSquad(&scoutQueenSquad);
			}
		}
		else if (task->taskGoal == TaskGoalType::Scout_Empty_BaseLocations || task->taskGoal == TaskGoalType::Burrow_On_Empty_BaseLocation)
		{
			int multiObstructZerglingSquadCount = 0;
			int multiObstructLurkerSquadCount = 0;

			if (BWAPI::Broodwar->getFrameCount() > 24 * 60 * 8) {
				multiObstructZerglingSquadCount = 4;
				multiObstructLurkerSquadCount = 2;
			}
			else if (BWAPI::Broodwar->getFrameCount() > 24 * 60 * 5) {
				multiObstructZerglingSquadCount = 2;
				multiObstructLurkerSquadCount = 1;
			}
			else if (BWAPI::Broodwar->getFrameCount() > 24 * 60 * 3) {
				multiObstructZerglingSquadCount = 1;
				multiObstructLurkerSquadCount = 0;
			}

			// Ƽ  ۸ ʹ    ʴ´
			if (getUnitNumberInSquad(&multiObstructZerglingSquad, BWAPI::UnitTypes::Zerg_Zergling) < multiObstructZerglingSquadCount
				&& lastFrameOfMultiObstructZerglingSquad + 24 * 60 * 2 < BWAPI::Broodwar->getFrameCount()) {
				moveUnitBetweenSquad(&mainBaseDefenseSquad, &multiObstructZerglingSquad, BWAPI::UnitTypes::Zerg_Zergling);
				lastFrameOfMultiObstructZerglingSquad = BWAPI::Broodwar->getFrameCount();
			}
			// Ƽ  Ŀ ʹ   ʴ´
			if (getUnitNumberInSquad(&multiObstructLurkerSquad, BWAPI::UnitTypes::Zerg_Lurker) < multiObstructLurkerSquadCount) {
				moveUnitBetweenSquad(&mainBaseDefenseSquad, &multiObstructLurkerSquad, BWAPI::UnitTypes::Zerg_Lurker);
			}

			// Ʊ ó ǼϷ  Ʊ Ƽ  ۸ / Ŀ ,  ϴ ׳ д. 
			// ȲǴϱ  ʴ.   Ǽص ū .
		}

		if (task->taskGoal == TaskGoalType::Attack_Enemy_Worker_In_Main_Region) {

			int enemyWorkerCount = 0;
			for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer)) {
				BWAPI::Unit enemyUnit = it.first;
				UnitInfo & enemyUnitInfo = it.second;

				if (enemyUnitInfo.type.isWorker()) {

					if (BWTA::getRegion(enemyUnitInfo.lastPosition) == myMainBaseLocation->getRegion()
						|| BWTA::getRegion(enemyUnitInfo.lastPosition) == myFirstExpansionBaseLocation->getRegion())
					{
						if (enemyUnitInfo.lastHealth > 0 && enemyUnitInfo.isLastPositionValid == true) {
							enemyWorkerCount++;
						}
					}
				}
			}

			if (enemyWorkerCount > 0) {

				if (myCurrentCombatStrategy != CombatStrategy::Zerg_Combat_4Drone_Zergling_Rush) {
					if (getUnitNumberInSquad(&mainBaseClearSquad1, BWAPI::UnitTypes::Zerg_Zergling) < enemyWorkerCount * 2) {
						moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainBaseClearSquad1, BWAPI::UnitTypes::Zerg_Zergling);
					}
					if (getUnitNumberInSquad(&mainBaseClearSquad1, BWAPI::UnitTypes::Zerg_Zergling) < enemyWorkerCount * 2) {
						moveUnitBetweenSquad(&scoutZerglingSquad, &mainBaseClearSquad1, BWAPI::UnitTypes::Zerg_Zergling);
					}
					if (getUnitNumberInSquad(&mainBaseClearSquad1, BWAPI::UnitTypes::Zerg_Zergling) < enemyWorkerCount * 2) {
						moveUnitBetweenSquad(&multiObstructZerglingSquad, &mainBaseClearSquad1, BWAPI::UnitTypes::Zerg_Zergling);
					}
					if (getUnitNumberInSquad(&mainBaseClearSquad1, BWAPI::UnitTypes::Zerg_Zergling) < enemyWorkerCount * 2) {
						moveUnitBetweenSquad(&mainCombatZerglingSquad, &mainBaseClearSquad1, BWAPI::UnitTypes::Zerg_Zergling);
					}
				}

				//  ϲۿ ؼ Ʊ  δ
				if (getUnitNumberInSquad(&mainBaseClearSquad1) < enemyWorkerCount) {
					moveUnitBetweenSquad(&reservedSquad, &mainBaseClearSquad1, BWAPI::UnitTypes::Zerg_Drone);
				}

				//  ϲ Ʊ ϲ ϸ, Ư SCV  ϸ, Ʊ ϲ   ִ
				//  : reservedSquad  
				/*
				if (getUnitNumberInSquad(&mainBaseClearSquad1) < enemyWorkerCount * 2) {
				for (auto & myWorker : WorkerManager::Instance().getWorkerData().getWorkers()) {
				if (myWorker != nullptr
				&& myWorker->exists()
				&& WorkerManager::Instance().isMineralWorker(myWorker)
				&& myWorker->isUnderAttack())
				{
				moveUnitBetweenSquad(&reservedSquad, &mainBaseClearSquad1, BWAPI::UnitTypes::Zerg_Drone, 1, myWorker);
				}
				}
				}
				*/

			}
			else {
				breakUpSquad(&mainBaseClearSquad1);
			}
		}

		if (task->taskGoal == TaskGoalType::Attack_Enemy_Dangerous_Building_In_Main_Region) {

			int enemyBuildingCount = 0;
			for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer)) {
				BWAPI::Unit enemyUnit = it.first;
				UnitInfo & enemyUnitInfo = it.second;

				if (BWTA::getRegion(enemyUnitInfo.lastPosition) == myMainBaseLocation->getRegion()
					|| BWTA::getRegion(enemyUnitInfo.lastPosition) == myFirstExpansionBaseLocation->getRegion())
				{
					if (enemyUnitInfo.lastHealth > 0 && enemyUnitInfo.isLastPositionValid == true) {
						if (enemyUnitInfo.type.isBuilding()) {
							// ׶ ٴϴ ǹ ϴ mainBaseClearSquad2   ʴ´
							if (enemyUnitInfo.type == BWAPI::UnitTypes::Terran_Bunker
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Terran_Refinery
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Protoss_Pylon
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Protoss_Photon_Cannon
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Protoss_Assimilator
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Zerg_Extractor
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Zerg_Creep_Colony
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Zerg_Nydus_Canal
								|| enemyUnitInfo.type == BWAPI::UnitTypes::Zerg_Sunken_Colony)
							{
								enemyBuildingCount++;
							}
						}
					}
				}
			}

			//  ǹ : Ŀ, , ū,  
			if (enemyBuildingCount > 0) {
				if (getUnitNumberInSquad(&mainBaseClearSquad2, BWAPI::UnitTypes::Zerg_Zergling) < 4) {
					moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainBaseClearSquad2, BWAPI::UnitTypes::Zerg_Zergling);
				}
				if (getUnitNumberInSquad(&mainBaseClearSquad2, BWAPI::UnitTypes::Zerg_Zergling) < 4) {
					moveUnitBetweenSquad(&scoutZerglingSquad, &mainBaseClearSquad2, BWAPI::UnitTypes::Zerg_Zergling);
				}
				if (getUnitNumberInSquad(&mainBaseClearSquad1, BWAPI::UnitTypes::Zerg_Zergling) < 4) {
					moveUnitBetweenSquad(&mainChokepointBlockingSquad, &mainBaseClearSquad1, BWAPI::UnitTypes::Zerg_Zergling);
				}
				if (getUnitNumberInSquad(&mainBaseClearSquad2, BWAPI::UnitTypes::Zerg_Zergling) < 4) {
					moveUnitBetweenSquad(&multiObstructZerglingSquad, &mainBaseClearSquad2, BWAPI::UnitTypes::Zerg_Zergling);
				}
				if (getUnitNumberInSquad(&mainBaseClearSquad2, BWAPI::UnitTypes::Zerg_Zergling) < 4) {
					moveUnitBetweenSquad(&mainCombatZerglingSquad, &mainBaseClearSquad2, BWAPI::UnitTypes::Zerg_Zergling);
				}

				if (getUnitNumberInSquad(&mainBaseClearSquad2) < enemyBuildingCount * 7) {
					//  ʹ϶, ϲ۱ 
					if (BWAPI::Broodwar->getFrameCount() < 24 * 60 * 5) {
						moveUnitBetweenSquad(&reservedSquad, &mainBaseClearSquad2, BWAPI::UnitTypes::Zerg_Drone);
					}
				}

			}
			else {
				breakUpSquad(&mainBaseClearSquad2);
			}

		}

		if (task->taskGoal == TaskGoalType::Attack_Enemy_Ground_Unit_In_Our_Region) {

			int enemyCount = 0;
			for (auto & it : InformationManager::Instance().getUnitAndUnitInfoMap(InformationManager::Instance().enemyPlayer)) {
				BWAPI::Unit enemyUnit = it.first;
				UnitInfo & enemyUnitInfo = it.second;

				if (enemyUnitInfo.type.isWorker() == false
					&& enemyUnitInfo.type.canAttack()
					&& enemyUnitInfo.type.isFlyer() == false
					&& enemyUnitInfo.lastHealth > 0
					&& enemyUnitInfo.isLastPositionValid == true)
				{
					for (BWTA::BaseLocation* baselocation : InformationManager::Instance().getOccupiedBaseLocations(InformationManager::Instance().selfPlayer)) {
						if (baselocation->getPosition().getDistance(enemyUnitInfo.lastPosition) < 16 * TILE_SIZE) {
							enemyCount++;
						}
					}
				}
			}

			if (enemyCount > 0) {

				// ٸ δ뿡   ؼ mainBaseDefenseSquad  ߰Ѵ
				if (getUnitNumberInSquad(&mainBaseDefenseSquad) < enemyCount * 2) {
					moveUnitBetweenSquad(&mainCombatHydraliskSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Hydralisk);
				}
				if (getUnitNumberInSquad(&mainBaseDefenseSquad) < enemyCount * 2) {
					moveUnitBetweenSquad(&scoutZerglingSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Zergling);
				}
				if (getUnitNumberInSquad(&mainBaseDefenseSquad) < enemyCount * 2) {
					moveUnitBetweenSquad(&multiObstructZerglingSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Zergling);
				}
				if (getUnitNumberInSquad(&mainBaseDefenseSquad) < enemyCount * 2) {
					moveUnitBetweenSquad(&mainCombatZerglingSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Zergling);
				}
				if (getUnitNumberInSquad(&mainBaseDefenseSquad) < enemyCount * 2) {
					moveUnitBetweenSquad(&ambushCombatLurkerSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Lurker);
				}
				if (getUnitNumberInSquad(&mainBaseDefenseSquad) < enemyCount * 2) {
					moveUnitBetweenSquad(&multiObstructLurkerSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Lurker);
				}
				if (getUnitNumberInSquad(&mainBaseDefenseSquad) < enemyCount * 2) {
					moveUnitBetweenSquad(&mainCombatLurkerSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Lurker);
				}

				//     ϲ  ʴ´ ?
				//if (getUnitNumberInSquad(&mainBaseClearSquad1) < enemyCount * 2) {
				//	moveUnitBetweenSquad(&reservedSquad, &mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Drone);
				//}
			}
			else {
				//breakUpSquad(&mainBaseDefenseSquad);
			}
		}

		if (task->taskGoal == TaskGoalType::Block_And_Hold_On_ChokePoint) {

			// ۸ ּ 4 mainChokepointBlockingSquad  ֵ Ѵ
			if (getUnitNumberInSquad(&mainChokepointBlockingSquad) < 4) {
				moveUnitBetweenSquad(&scoutZerglingSquad, &mainChokepointBlockingSquad, BWAPI::UnitTypes::Zerg_Zergling);
			}
			if (getUnitNumberInSquad(&mainChokepointBlockingSquad) < 4) {
				moveUnitBetweenSquad(&multiObstructZerglingSquad, &mainChokepointBlockingSquad, BWAPI::UnitTypes::Zerg_Zergling);
			}
		}
		
		if (task->taskGoal == TaskGoalType::Burrow_And_Ambush_Attack_With_Lurker)
		{
			int ambushCombatLurkerSquadCount = 0;

			if (BWAPI::Broodwar->getFrameCount() > 24 * 60 * 8) {
				ambushCombatLurkerSquadCount = 4;
			}
			else if (BWAPI::Broodwar->getFrameCount() > 24 * 60 * 5) {
				ambushCombatLurkerSquadCount = 2;
			}

			// ź Ŀ ʹ   ʴ´
			if (getUnitNumberInSquad(&ambushCombatLurkerSquad, BWAPI::UnitTypes::Zerg_Lurker) < ambushCombatLurkerSquadCount) {
				moveUnitBetweenSquad(&mainBaseDefenseSquad, &ambushCombatLurkerSquad, BWAPI::UnitTypes::Zerg_Lurker);
			}
			if (getUnitNumberInSquad(&ambushCombatLurkerSquad, BWAPI::UnitTypes::Zerg_Lurker) < ambushCombatLurkerSquadCount) {
				moveUnitBetweenSquad(&mainCombatLurkerSquad, &ambushCombatLurkerSquad, BWAPI::UnitTypes::Zerg_Lurker);
			}
		}

		if (task->taskGoal == TaskGoalType::Defense_Position_With_Hydralisk) {
		}

		if (task->taskGoal == TaskGoalType::Attack_Enemy_BaseLocation_With_Early_Zergling_Unit) {

			if (enemyMainBaseLocation != nullptr) {
				
				// ۸ ѵ
				moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatZerglingSquad, BWAPI::UnitTypes::Zerg_Zergling, 
					getUnitNumberInSquad(&mainBaseDefenseSquad, BWAPI::UnitTypes::Zerg_Zergling));

				//  ۸ zerglingScouterNumberFromCombatSquad  ΰ ѵ
				if (getUnitNumberInSquad(&scoutZerglingSquad, BWAPI::UnitTypes::Zerg_Zergling) > zerglingScouterNumberFromCombatSquad) {
					moveUnitBetweenSquad(&scoutZerglingSquad, &mainCombatZerglingSquad, BWAPI::UnitTypes::Zerg_Zergling, 1);
				}
			}
		}

		
		if (task->taskGoal == TaskGoalType::Attack_Enemy_BaseLocation_With_Ground_Unit) {

			//  mainBaseDefenseSquad δ뿡 ִ ۸, , Ŀ, Ʈ󸮽ũ, Ϸ ݺδ뿡 ԽŲ
			moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatZerglingSquad, BWAPI::UnitTypes::Zerg_Zergling);
			moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatHydraliskSquad, BWAPI::UnitTypes::Zerg_Hydralisk);
			moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatLurkerSquad, BWAPI::UnitTypes::Zerg_Lurker);
			moveUnitBetweenSquad(&ambushCombatLurkerSquad, &mainCombatLurkerSquad, BWAPI::UnitTypes::Zerg_Lurker);
			moveUnitBetweenSquad(&multiObstructLurkerSquad, &mainCombatLurkerSquad, BWAPI::UnitTypes::Zerg_Lurker);
			moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatUltraliskSquad, BWAPI::UnitTypes::Zerg_Ultralisk);
			moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatQueenSquad, BWAPI::UnitTypes::Zerg_Queen);
			moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatDefilerSquad, BWAPI::UnitTypes::Zerg_Defiler);
			moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatScourgeSquad, BWAPI::UnitTypes::Zerg_Scourge);
			moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatMutaliskSquad, BWAPI::UnitTypes::Zerg_Mutalisk);

			// ε 1⾿  δ뿡 ԽŲ
			// TODO : ε  ؾ. ȱ׷ ε  ̵ϴٰ 
			if (getUnitNumberInSquad(&mainCombatZerglingSquad, BWAPI::UnitTypes::Zerg_Overlord) == 0) {
				moveUnitBetweenSquad(&reservedSquad, &mainCombatZerglingSquad, BWAPI::UnitTypes::Zerg_Overlord);
			}
			if (getUnitNumberInSquad(&mainCombatHydraliskSquad, BWAPI::UnitTypes::Zerg_Overlord) == 0) {
				moveUnitBetweenSquad(&reservedSquad, &mainCombatHydraliskSquad, BWAPI::UnitTypes::Zerg_Overlord);
			}
			if (getUnitNumberInSquad(&mainCombatLurkerSquad, BWAPI::UnitTypes::Zerg_Overlord) == 0) {
				moveUnitBetweenSquad(&reservedSquad, &mainCombatLurkerSquad, BWAPI::UnitTypes::Zerg_Overlord);
			}
			if (getUnitNumberInSquad(&mainCombatDefilerSquad, BWAPI::UnitTypes::Zerg_Overlord) == 0) {
				moveUnitBetweenSquad(&reservedSquad, &mainCombatDefilerSquad, BWAPI::UnitTypes::Zerg_Overlord);
			}
		}



		if (task->taskGoal == TaskGoalType::Attack_Enemy_BaseLocation_With_Mutalisk) {

			/*
			// ε 1⸦ ԽŲ
			if (mainCombatMutaliskSquad.unitset.size() > 0) {

			bool isOverlordContained = false;
			for (auto & unit : mainCombatMutaliskSquad.unitset) {
			if (unit->getType() == BWAPI::UnitTypes::Zerg_Overlord) {
			isOverlordContained = true;
			}
			}

			double minDistance = 1000000000;
			double tempDistance = 0;
			BWAPI::Unit minDistanceOverlord = nullptr;
			for (auto & unit : reservedSquad.unitset) {
			if (unit->getType() == BWAPI::UnitTypes::Zerg_Overlord) {
			tempDistance = unit->getDistance(myMainBaseLocation->getPosition());
			if (minDistance > tempDistance) {
			minDistance = tempDistance;
			minDistanceOverlord = unit;
			}
			}
			}

			if (minDistanceOverlord != nullptr) {
			moveUnitBetweenSquad(&mainCombatMutaliskSquad, &reservedSquad, BWAPI::UnitTypes::Zerg_Overlord);
			moveUnitBetweenSquad(&reservedSquad, &mainCombatMutaliskSquad, BWAPI::UnitTypes::Zerg_Overlord, 1, minDistanceOverlord);
			}
			}
			*/

		}

		if (task->taskGoal == TaskGoalType::Attack_With_Lurker_Drop) {
		}

		if (task->taskGoal == TaskGoalType::Eliminate_Enemy_Player) {

			//  ۸, , Ŀ, Ʈ󸮽ũ, Ϸ ݺδ뿡 ԽŲ
			moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatZerglingSquad, BWAPI::UnitTypes::Zerg_Zergling);
			moveUnitBetweenSquad(&multiObstructZerglingSquad, &mainCombatZerglingSquad, BWAPI::UnitTypes::Zerg_Zergling);
			moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatHydraliskSquad, BWAPI::UnitTypes::Zerg_Hydralisk);
			moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatLurkerSquad, BWAPI::UnitTypes::Zerg_Lurker);
			moveUnitBetweenSquad(&multiObstructLurkerSquad, &mainCombatLurkerSquad, BWAPI::UnitTypes::Zerg_Lurker);
			moveUnitBetweenSquad(&ambushCombatLurkerSquad, &mainCombatLurkerSquad, BWAPI::UnitTypes::Zerg_Lurker);
			moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatUltraliskSquad, BWAPI::UnitTypes::Zerg_Ultralisk);
			moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatQueenSquad, BWAPI::UnitTypes::Zerg_Queen);
			moveUnitBetweenSquad(&mainBaseDefenseSquad, &mainCombatDefilerSquad, BWAPI::UnitTypes::Zerg_Defiler);

			/*
			// ε 1⾿  δ뿡 ԽŲ
			// TODO : ε  ؾ. ȱ׷ ε  ̵ϴٰ 
			if (getUnitNumberInSquad(&mainCombatZerglingSquad, BWAPI::UnitTypes::Zerg_Overlord) == 0) {
			moveUnitBetweenSquad(&reservedSquad, &mainCombatZerglingSquad, BWAPI::UnitTypes::Zerg_Overlord);
			}
			if (getUnitNumberInSquad(&mainCombatHydraliskSquad, BWAPI::UnitTypes::Zerg_Overlord) == 0) {
			moveUnitBetweenSquad(&reservedSquad, &mainCombatHydraliskSquad, BWAPI::UnitTypes::Zerg_Overlord);
			}
			if (getUnitNumberInSquad(&mainCombatLurkerSquad, BWAPI::UnitTypes::Zerg_Overlord) == 0) {
			moveUnitBetweenSquad(&reservedSquad, &mainCombatLurkerSquad, BWAPI::UnitTypes::Zerg_Overlord);
			}
			if (getUnitNumberInSquad(&mainCombatUltraliskSquad, BWAPI::UnitTypes::Zerg_Overlord) == 0) {
			moveUnitBetweenSquad(&reservedSquad, &mainCombatUltraliskSquad, BWAPI::UnitTypes::Zerg_Overlord);
			}
			if (getUnitNumberInSquad(&mainCombatDefilerSquad, BWAPI::UnitTypes::Zerg_Overlord) == 0) {
			moveUnitBetweenSquad(&reservedSquad, &mainCombatDefilerSquad, BWAPI::UnitTypes::Zerg_Overlord);
			}
			*/
		}

		// Ƽ
		if (task->taskGoal == TaskGoalType::Build_Expansion_On_Ground){

			//  BuildManager  

			// ε 1 ߰
			if (getUnitNumberInSquad(&newExpansionSetupSquad, BWAPI::UnitTypes::Zerg_Overlord) < 1) {
				moveUnitBetweenSquad(&reservedSquad, &newExpansionSetupSquad, BWAPI::UnitTypes::Zerg_Overlord);
			}

			// Ż 1 ߰
			if (getUnitNumberInSquad(&newExpansionSetupSquad, BWAPI::UnitTypes::Zerg_Mutalisk) < 1) {
				moveUnitBetweenSquad(&mainCombatMutaliskSquad, &newExpansionSetupSquad, BWAPI::UnitTypes::Zerg_Mutalisk);
			}

			// ۸ 1 ߰
			// ۸ ߿  Ѵ
			//if (getUnitNumberInSquad(&newExpansionSetupSquad, BWAPI::UnitTypes::Zerg_Zergling) < 1) {
			//	moveUnitBetweenSquad(&mainBaseDefenseSquad, &newExpansionSetupSquad, BWAPI::UnitTypes::Zerg_Zergling);
			//}

		}
		else if (task->taskGoal == TaskGoalType::Build_Expansion_On_Island) {

			/*

			if (myMainBaseLocation != nullptr && enemyMainBaseLocation != nullptr) {

			if (task->targetPosition != BWAPI::Positions::None) {

			int dangerousLevel = (int)(task->targetPosition.getDistance(myMainBaseLocation->getPosition()) - task->targetPosition.getDistance(enemyMainBaseLocation->getPosition()));

			int droneUnitCount = 0;
			int overlordUnitCount = 0;
			int zerglingUnitCount = 0;
			int hydraliskUnitCount = 0;

			int droneUnitCountMax = 1;
			int overlordUnitCountMax = 0;
			int zerglingUnitCountMax = 0;
			int hydraliskUnitCountMax = 0;

			if (dangerousLevel < -1000) {
			droneUnitCountMax = 1;
			overlordUnitCountMax = 0;
			zerglingUnitCountMax = 0;
			hydraliskUnitCountMax = 0;
			}
			else if (dangerousLevel < -100) {
			droneUnitCountMax = 2;
			overlordUnitCountMax = 1;
			zerglingUnitCountMax = 2;
			hydraliskUnitCountMax = 0;
			}
			else if (dangerousLevel >= -100) {
			droneUnitCountMax = 2;
			overlordUnitCountMax = 1;
			zerglingUnitCountMax = 2;
			hydraliskUnitCountMax = 2;
			}

			for (auto & unit : newExpansionSetupSquad.unitset) {
			if (unit->getType() == BWAPI::UnitTypes::Zerg_Drone) droneUnitCount++;
			else if (unit->getType() == BWAPI::UnitTypes::Zerg_Overlord) overlordUnitCount++;
			else if (unit->getType() == BWAPI::UnitTypes::Zerg_Zergling) zerglingUnitCount++;
			else if (unit->getType() == BWAPI::UnitTypes::Zerg_Hydralisk) hydraliskUnitCount++;
			}

			if (droneUnitCount < droneUnitCountMax) {
			moveUnitBetweenSquad(&reservedSquad, &newExpansionSetupSquad, BWAPI::UnitTypes::Zerg_Drone);
			}
			if (overlordUnitCount < overlordUnitCountMax) {
			moveUnitBetweenSquad(&reservedSquad, &newExpansionSetupSquad, BWAPI::UnitTypes::Zerg_Overlord);
			}
			if (zerglingUnitCount < zerglingUnitCountMax) {
			moveUnitBetweenSquad(&reservedSquad, &newExpansionSetupSquad, BWAPI::UnitTypes::Zerg_Zergling);
			}
			if (hydraliskUnitCount < hydraliskUnitCountMax) {
			moveUnitBetweenSquad(&mainBaseClearSquad, &newExpansionSetupSquad, BWAPI::UnitTypes::Zerg_Hydralisk);
			}

			droneUnitCount = 0;
			overlordUnitCount = 0;
			zerglingUnitCount = 0;
			hydraliskUnitCount = 0;
			for (auto & unit : newExpansionSetupSquad.unitset) {
			if (unit->getType() == BWAPI::UnitTypes::Zerg_Drone) droneUnitCount++;
			else if (unit->getType() == BWAPI::UnitTypes::Zerg_Overlord) overlordUnitCount++;
			else if (unit->getType() == BWAPI::UnitTypes::Zerg_Zergling) zerglingUnitCount++;
			else if (unit->getType() == BWAPI::UnitTypes::Zerg_Hydralisk) hydraliskUnitCount++;
			}

			if (overlordUnitCount < zerglingUnitCountMax) {
			moveUnitBetweenSquad(&scoutOverlordSquad, &newExpansionSetupSquad, BWAPI::UnitTypes::Zerg_Overlord);
			}
			if (zerglingUnitCount < zerglingUnitCountMax) {
			moveUnitBetweenSquad(&mainBaseClearSquad, &newExpansionSetupSquad, BWAPI::UnitTypes::Zerg_Zergling);
			}

			if (hydraliskUnitCount < hydraliskUnitCountMax) {
			moveUnitBetweenSquad(&reservedSquad, &newExpansionSetupSquad, BWAPI::UnitTypes::Zerg_Hydralisk);
			}

			droneUnitCount = 0;
			overlordUnitCount = 0;
			zerglingUnitCount = 0;
			hydraliskUnitCount = 0;

			std::cout << "newExpansionSetupSquad " << newExpansionSetupSquad.unitset.size() << " to " << task->targetPosition.x / TILE_SIZE << ", " << task->targetPosition.y / TILE_SIZE << std::endl;

			for (auto & unit : newExpansionSetupSquad.unitset) {
			if (unit->getType() == BWAPI::UnitTypes::Zerg_Drone) droneUnitCount++;
			else if (unit->getType() == BWAPI::UnitTypes::Zerg_Overlord) overlordUnitCount++;
			else if (unit->getType() == BWAPI::UnitTypes::Zerg_Zergling) zerglingUnitCount++;
			else if (unit->getType() == BWAPI::UnitTypes::Zerg_Hydralisk) hydraliskUnitCount++;
			}
			*/
		}

	}

	// Task   Squad  üѴ
	//breakUpSquadsThatHasNoTask();
}


void StrategyManager::executeScout()
{
	Strategy_ScoutTaskManager::Instance().update();
}

void StrategyManager::executeBuild()
{
	Strategy_BuildTaskManager::Instance().update();
}


void StrategyManager::executeCombat()
{
	Strategy_CombatTaskManager::Instance().update();
}

void StrategyManager::executeExpansion()
{
	// ϲ  Ǿ 2 BaseLocation  Ȱ ư  ϲ 1 ô
	if (BWAPI::Broodwar->self()->completedUnitCount(BWAPI::UnitTypes::Zerg_Drone) > 16) {
		clearFakeMineral();
	}

	Strategy_ExpansionTaskManager::Instance().update();
}

void StrategyManager::setWord()
{
	words.push_back("Psalms #23");
	words.push_back("The LORD is my shepherd, I shall not be in want.");
	words.push_back("He makes me lie down in green pastures, he leads me beside quiet waters,");
	words.push_back("he restores my soul. He guides me in paths of righteousness for his name's sake.");
	words.push_back("Even though I walk through the valley of the shadow of death, I will fear no evil, for you are with me; your rod and your staff, they comfort me.");
	words.push_back("You prepare a table before me in the presence of my enemies. You anoint my head with oil; my cup overflows.");
	words.push_back("Surely goodness and love will follow me all the days of my life, and I will dwell in the house of the LORD forever.");
}

void StrategyManager::sendWord()
{
	for (size_t i = 0; i < words.size(); i++) {
		if (BWAPI::Broodwar->getFrameCount() == 24 * (60 + i * 3 )) {
			BWAPI::Broodwar->sendText("%s", words[i].c_str());
		}
	}


}

