﻿#include "Config.h"

namespace Config
{
	namespace BotInfo
	{
		std::string BotName = "Sling";
		std::string BotAuthors = "tekseon.shin@gmail.com";
	}

	namespace Files
	{
		std::string LogFilename = Config::BotInfo::BotName + "_GameRecord.dat";
		std::string ReadDirectory = "bwapi-data\\read\\";
		std::string WriteDirectory = "bwapi-data\\write\\";
	}

	namespace BWAPIOptions
	{
		int SetLocalSpeed = 42;
		int SetFrameSkip = 0;
		bool EnableUserInput = true;
		bool EnableCompleteMapInformation = false;
	}
	
	namespace Tools
	{
		extern int MAP_GRID_SIZE = 32;      
	}

	namespace Macro
	{
		int WorkersPerRefinery = 3;
		int BuildingSpacing = 2;
		int BuildingResourceDepotSpacing = 0;
		int BuildingPylonEarlyStageSpacing = 4;
		int BuildingPylonSpacing = 2;
		int BuildingSupplyDepotSpacing = 0;
		int BuildingDefenseTowerSpacing = 3;
	}

	namespace Debug
	{
		bool DrawGameInfo = true;
		bool DrawUnitHealthBars = true;
		bool DrawProductionInfo = true;
		bool DrawScoutInfo = false;
		bool DrawResourceInfo = false;
		bool DrawWorkerInfo = false;
		bool DrawReservedBuildingTiles = false;
		bool DrawBuildingInfo = false;
		bool DrawMouseCursorInfo = true;
		bool DrawEnemyUnitInfo = false;
		bool DrawBWTAInfo = true;
		bool DrawMapGrid = false;
		bool DrawUnitTargetInfo = true;

		// 추가
		bool DrawSquadName = false;
		bool DrawSquadList = true;
	}

}