#pragma once

#include "Common.h"

namespace MyBot
{

	struct ConfidenceMapCell
	{
		///  ġִ 
		std::vector<BWAPI::Unit>	enemyUnits;
		std::vector<BWAPI::Unit>	myUnits;
		std::vector<BWAPI::Unit>	Units;

		int							airDamagePerSecond;
		int							groundDamagePerSecond;

		ConfidenceMapCell() {
			airDamagePerSecond = 0;
			groundDamagePerSecond = 0;
		}

		void clear() {
			Units.clear();
			myUnits.clear();
			enemyUnits.clear();
			airDamagePerSecond = 0;
			groundDamagePerSecond = 0;
		}
	};

	/// Ÿ  
	class ConfidenceMap : public GridMap < ConfidenceMapCell, 1 >
	{
		bool isToFindError;
	public:
		ConfidenceMap(const Map * pMap) : GridMap(pMap) {
			isToFindError = false;
		}

		void							Add(BWAPI::Unit unit);
		void							Remove(BWAPI::Unit unit);

		std::vector<BWAPI::Unit>		GetUnits(BWAPI::TilePosition topLeft, BWAPI::TilePosition bottomRight, BWAPI::Player player) const;

		int								getDangerLevelToFlyer(BWAPI::TilePosition from, BWAPI::TilePosition to);

		//std::set<BWAPI::TilePosition>	getTileList(BWAPI::TilePosition from, BWAPI::TilePosition to);

	};
}