#include "SurveyerManager.h"
#include "MapGrid.h"
#include <random>

using namespace UAlbertaBot;

SurveyerManager::SurveyerManager()
{ 
}

void SurveyerManager::executeMicro(const BWAPI::Unitset & targets)
{
	const BWAPI::Unitset & surveyerUnits = getUnits();

	if (surveyerUnits.empty())
	{
		return;
	}

	int x = 0;
	for (auto & surveyor : surveyerUnits)
	{
		if (surveyor->getType() == BWAPI::UnitTypes::Zerg_Overlord) {
			// Set order position for a surveyer
			x++;

			std::uniform_int_distribution<int> uniform_dist(30, 300);
			std::random_device rng_seed;
			std::mt19937 rng(rng_seed());
			int w = uniform_dist(rng);        // a lot of trouble to get one random number...

			BWAPI::Position surveyorTarget = MapGrid::Instance().getLeastExploredNearUs(surveyor->getPosition());
			if (BWAPI::Broodwar->getFrameCount() < 100 || BWAPI::Broodwar->getFrameCount() % w == 0)
			{
				Micro::SmartMove(surveyor, surveyorTarget);
			}

			if (Config::Debug::DrawSquadInfo)
			{
				BWAPI::Broodwar->drawCircleMap(surveyorTarget, 10, BWAPI::Colors::Green, true);
				BWAPI::Broodwar->drawCircleMap(surveyorTarget, 100, BWAPI::Colors::Red, false);
				BWAPI::Broodwar->drawTextMap(surveyorTarget + BWAPI::Position(0, 10), "%s %d", "Surveyer", x);
			}
		}
	}

	return;
}

void SurveyerManager::update(SquadOrder order)
{
	const BWAPI::Unitset & surveyerUnits = getUnits();

	if (surveyerUnits.empty())
	{
		return;
	}

	return;
}
