#pragma once;

#include <Common.h>
#include "MicroManager.h"

namespace UAlbertaBot
{
class MicroManager;

class DetectorManager : public MicroManager
{
	// The cloakedUnitMap is unused, but code exists to fill in its values.
	// For each enemy cloaked unit, it keeps a flag "have we assigned a detector to watch it?"
	// No code exists to assign detectors or move them toward their assigned positions.
	std::map<BWAPI::Unit, bool>	cloakedUnitMap;
	bool isAssigned(BWAPI::Unit unit);
	BWAPI::Unit unitClosestToEnemy;
	BWAPI::Position center;

public:

	DetectorManager();
	~DetectorManager() {}

	void setUnitClosestToEnemy(BWAPI::Unit unit) { unitClosestToEnemy = unit; }
	void setCenter(BWAPI::Position position) { center = position; }
	void executeMicro(const BWAPI::Unitset & targets);

	BWAPI::Unit closestCloakedUnit(const BWAPI::Unitset & cloakedUnits, BWAPI::Unit detectorUnit);
};
}