#include "DetectorManager.h"

using namespace UAlbertaBot;

DetectorManager::DetectorManager() 
	: unitClosestToEnemy(nullptr) 
	, center(BWAPI::Broodwar->self()->getStartLocation())
{ 
}

void DetectorManager::executeMicro(const BWAPI::Unitset & targets) 
{
	const BWAPI::Unitset & detectorUnits = getUnits();

	if (detectorUnits.empty())
	{
		return;
	}

	// NOTE targets is a list of nearby enemies.
	// Currently unused. Could use it to avoid enemy fire, among other possibilities.
	for (size_t i(0); i<targets.size(); ++i)
	{
		// do something here if there's targets
	}

	cloakedUnitMap.clear();
	BWAPI::Unitset cloakedUnits;

	// Find enemy cloaked units.
	// NOTE This code is unused, but it is potentially useful.
	for (auto & unit : BWAPI::Broodwar->enemy()->getUnits())
	{
		// conditions for targeting
		// TODO is this good enough for arbiters?
		if (unit->getType().hasPermanentCloak() ||     // dark templar, observer
			unit->getType().isCloakable() ||           // wraith, ghost
			unit->getType() == BWAPI::UnitTypes::Terran_Vulture_Spider_Mine ||
			unit->getType() == BWAPI::UnitTypes::Zerg_Lurker ||
			unit->isBurrowed() ||
			(unit->isVisible() && !unit->isDetected()))
		{
			cloakedUnits.insert(unit);
			cloakedUnitMap[unit] = false;
		}
	}

	// for each detectorUnit
	for (auto & detectorUnit : detectorUnits)
	{
		// Move the detector toward the squad unit closest to the enemy.
		//if (unitClosestToEnemy && unitClosestToEnemy->getPosition().isValid())
		//{
			//Micro::SmartMove(detectorUnit, unitClosestToEnemy->getPosition());
			Micro::SmartMove(detectorUnit, center);
		//}
		// otherwise there is no battle or no closest to enemy so we don't want our detectorUnit to die
		// send him to scout around the map
		// no, don't - not so smart for overlords
		/*
		else
		{
			BWAPI::Position explorePosition = MapGrid::Instance().getLeastExplored();
			Micro::SmartMove(detectorUnit, explorePosition);
		}
		*/
	}
}

// NOTE Unused but potentially useful.
BWAPI::Unit DetectorManager::closestCloakedUnit(const BWAPI::Unitset & cloakedUnits, BWAPI::Unit detectorUnit)
{
	BWAPI::Unit closestCloaked = nullptr;
	double closestDist = 100000;

	for (auto & unit : cloakedUnits)
	{
		// if we haven't already assigned an detectorUnit to this cloaked unit
		if (!cloakedUnitMap[unit])
		{
			double dist = unit->getDistance(detectorUnit);

			if (!closestCloaked || (dist < closestDist))
			{
				closestCloaked = unit;
				closestDist = dist;
			}
		}
	}

	return closestCloaked;
}