#pragma once

#include "Common.h"
#include <fstream>

#include "BuildOrderQueue.h"
#include "WorkerManager.h"
#include <iostream>
#include <fstream>
#include <iomanip>

#include "BuildOrder.h"
#include "MacroAct.h"
#include "UnitUtil.h"
typedef std::pair<int, int> IntPair;
typedef std::pair<MetaType, common_UnitCountType> MetaPair;
typedef std::vector<MetaPair> MetaPairVector;

// SparCraft
typedef std::pair<UAlbertaBot::MacroAct, size_t> SparCraft_MetaPair;
typedef std::vector<SparCraft_MetaPair> SparCraft_MetaPairVector;

struct Strategy
{
	std::string						_name;
	BWAPI::Race						_race;
	int								_wins;
	int								_losses;
	std::string						_openingGroup;
	UAlbertaBot::BuildOrder			_buildOrder;

	Strategy()
		: _name("None")
		, _race(BWAPI::Races::None)
		, _wins(0)
		, _losses(0)
		, _openingGroup("")
	{
	}

	Strategy(const std::string & name, const BWAPI::Race & race, const std::string & openingGroup, const UAlbertaBot::BuildOrder & buildOrder)
		: _name(name)
		, _race(race)
		, _wins(0)
		, _losses(0)
		, _openingGroup(openingGroup)
		, _buildOrder(buildOrder)
	{
	}
};





class StrategyManager
{
	//----------------------------------------------------------------------------------
	// SparCraft private member
	BWAPI::Race                           _selfRace;
	BWAPI::Race                           _enemyRace;
	UAlbertaBot::BuildOrder				  _emptyBuildOrder;
	std::string							  _openingGroup;
	std::map<std::string, Strategy>		  _strategies;


	//----------------------------------------------------------------------------------
	StrategyManager();
	~StrategyManager() {}

	std::vector<MetaType> 		actions;
	

	openingStrategy				currentopeningStrategy;

	bool						triggerMutaliskBuild;

	bool						disableMutaliskHarass;

	std::vector<std::string>	openingStrategyName;

	bool						lairTrigger;
	bool						spireTrigger;


	bool						overlordUpgradeTrigger;
	bool						mutaUpgradeTrigger;
	bool						hydraUpgradeTrigger;

	std::vector<std::string>							stateActions;
	std::map<std::string, BWAPI::UnitType>				actionBuildingTarget;
	std::map<std::string, std::map<std::string, std::vector<std::string>>>		featureNames;
	int													previousScore;
	std::string											previousAction;
	std::map<std::string, std::map<std::string, double>>						parameterValue;
	std::map<std::string, std::map<std::string, int>>						featureValue;
	int							curActionTime;
	void						featureWeightInit();
	void						experienceDataInit();

	std::map<std::string, std::map<std::string, double>>						parameterCumulativeGradient;
	void						featureCumulativeGradientInit();


	std::vector<std::vector<std::string>> experienceData;
	std::vector<std::vector<std::string>>	curEpisodeData;
	double						discountRate;
	double						calQValue(std::string stringData, std::map<std::string, std::map<std::string, int>>& stringValue);
	std::string					getCategory(std::vector<std::string>& categoryRange, int curValue, std::string prefix);
	void						calCurrentStateFeature();
	double						calActionFeature(std::string curAction, std::map<std::string, std::map<std::string, int>>& features);
	std::string					opponentWinrate;
	void						setArmyUpgrade();

	int							playMatchCount;
	bool 						muteBuilding;
	bool						isInBuildingMutalisk;
	//--------------------------------------------------------------------------------------------------
	//   SparCraft private function
	const SparCraft_MetaPairVector  getZergBuildOrderGoal() const;
	const bool  shouldExpandNow() const;

	//---------------------------------------------------------------------------------------------------

public:

	//----------------------------------------------------------------------------------
	// SparCraft public function
	void                        setOpeningGroup();
	const std::string &         getOpeningGroup() const;
	void						addStrategy(const std::string &name, Strategy & strategy);


	//----------------------------------------------------------------------------------
	std::vector<MetaType>		getMetaVector(std::string buildString);

	static	StrategyManager &	Instance();

	std::vector<MetaType>		getOpeningBook();
	void						setOpeningStrategy(openingStrategy opening);
	
	openingStrategy				getCurrentopeningStrategy() { return currentopeningStrategy; }

	bool						mutaliskHarassFlag() { return disableMutaliskHarass; }
	void						update();
	void						baseExpand();

	int							getStrategyByName(std::string strategy);
	std::string					getStrategyName(openingStrategy strategy);
	std::vector<std::string>	getStrategyNameArray() { return openingStrategyName; }
	int							getScore();

	std::string					strategyChange(int reward);
	std::vector<MetaType>		getStrategyBuildingOrder(std::string stateAction);

	void						featureWeightSave();
	void						featureGradientSave();
	void						experienceDataSave();

	void						setOpponentWinrate(std::string rate) { opponentWinrate = rate; }
	int							getPlayeMatchCount() { return playMatchCount; }
	bool						isBuildingMutaliskBuilding() { return isInBuildingMutalisk; }

};
