#include "KillAll.h"

// SparCraft
#include "SparCraft.h"
#include "SparCraft_Common.h"
#include "MapGrid.h"
#include "ScoutManager.h"
#include <regex>

bool analyzed;
bool analysis_just_finished;


//  my initialize
void KillAll::init()
{
	// SparCraft init
	SparCraft::init();

    // enemy name
	string enemyName;
	enemyName = BWAPI::Broodwar->enemy()->getName();
	BWAPI::Broodwar->printf("Match to:   %s", enemyName.c_str());
	

	////default opening strategy
	//chooseOpeningStrategy = TwelveHatchMuta;// FivePoolling ; //TwelveHatchMuta;//TenHatchMuta;//NinePoolling;

	StrategyManager::Instance().setOpponentWinrate("-1");
    
	// For Enemy Strategy
	if (BWAPI::Broodwar->enemy()->getRace() == BWAPI::Races::Protoss)
	{
		chooseOpeningStrategy = FivePoolling;
		StrategyManager::Instance().setOpeningStrategy(chooseOpeningStrategy);
	}
	else if (BWAPI::Broodwar->enemy()->getRace() == BWAPI::Races::Zerg)
	{
		chooseOpeningStrategy = NinePoollingMuta;
		StrategyManager::Instance().setOpeningStrategy(chooseOpeningStrategy);
	}
	else if (BWAPI::Broodwar->enemy()->getRace() == BWAPI::Races::Terran)
	{
		chooseOpeningStrategy = FivePoolling;
		StrategyManager::Instance().setOpeningStrategy(FivePoolling);
	}
	else // Random
	{
		chooseOpeningStrategy = FivePoolling;
		StrategyManager::Instance().setOpeningStrategy(chooseOpeningStrategy);
	}

	StrategyManager::Instance().setOpeningGroup();
	
	
}

void KillAll::onStart()
{
	// init for Boss and SparCraft
	init();

	//Broodwar->setFrameSkip(0);
	//Broodwar->setGUI(false);
	
	Broodwar->setLocalSpeed(0);
	BWAPI::Broodwar->sendText("Let's Rock :)");

	//Broodwar->printf("The map is %s, a %d player map", Broodwar->mapName().c_str(), Broodwar->getStartLocations().size());
	// Enable some cheat flags
	Broodwar->enableFlag(Flag::UserInput);
	// Uncomment to enable complete map information
	//Broodwar->enableFlag(Flag::CompleteMapInformation);

	//read map information into BWTA so terrain analysis can be done in another thread
	BWTA::readMap();
	BWTA::analyze();

	for (auto & u : BWAPI::Broodwar->self()->getUnits())
	{
		if (u->getType().isResourceDepot())
			InformationManager::Instance().addOccupiedRegionsDetail(BWTA::getRegion(BWAPI::Broodwar->self()->getStartLocation()), BWAPI::Broodwar->self(), u);
	}

	analyzed = true;
	analysis_just_finished = true;

	show_bullets = false;
	show_visibility_data = false;
	show_paths = true;

}


void KillAll::onEnd(bool isWinner)
{
	
}


void KillAll::onFrame()
{
	
   // replay return
	if (Broodwar->isReplay())
		return;

   //  leave game return
	if (curMode == Develop && BWAPI::Broodwar->getFrameCount() >= 86400)
	{
		BWAPI::Broodwar->leaveGame();
	}

	// draw the line.
	drawStats();

	TimerManager::Instance().startTimer(TimerManager::All);

	// Worker
	TimerManager::Instance().startTimer(TimerManager::Worker);
	WorkerManager::Instance().update();
	TimerManager::Instance().stopTimer(TimerManager::Worker);

	//self start location only available if the map has base locations
	if (analyzed)
	{
		drawTerrainData();

		// Information
		TimerManager::Instance().startTimer(TimerManager::Information);
		InformationManager::Instance().update();
		UAlbertaBot::MapGrid::Instance().update();
		TimerManager::Instance().stopTimer(TimerManager::Information);

		// Production
		TimerManager::Instance().startTimer(TimerManager::Production);
		ProductionManager::Instance().update();
		ProductionManager::Instance().drawProductionInformation(0, 20);
		TimerManager::Instance().stopTimer(TimerManager::Production);

		// Building
		TimerManager::Instance().startTimer(TimerManager::Building);
		BuildingManager::Instance().update();
		TimerManager::Instance().stopTimer(TimerManager::Building);

		// Attack
		TimerManager::Instance().startTimer(TimerManager::Attack);
		AttackManager::Instance().update();
		TimerManager::Instance().stopTimer(TimerManager::Attack);

		// Scout
		TimerManager::Instance().startTimer(TimerManager::Scout);
		UAlbertaBot::ScoutManager::Instance().update();
		TimerManager::Instance().stopTimer(TimerManager::Scout);


	}


	// End All timer.
	TimerManager::Instance().stopTimer(TimerManager::All);
	TimerManager::Instance().displayTimers(490, 180);


	
	
	
	
}

void KillAll::onSendText(std::string text)
{
	stringstream ss;
	ss << text;
	int speed(-1);

	ss >> speed;
	if (speed >= 0 && speed <= 100)
	{
		BWAPI::Broodwar->setLocalSpeed(speed);
	}
	else if (text == "/show bullets")
	{
		show_bullets = !show_bullets;
	}
	else if (text == "/show players")
	{
		showPlayers();
	}
	else if (text == "/show forces")
	{
		showForces();
	}
	else if (text == "/show visibility")
	{
		show_visibility_data = !show_visibility_data;
	}
	else if (text == "/analyze")
	{
		if (analyzed == false)
		{
			Broodwar->printf("Analyzing map... this may take a minute");
			CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)AnalyzeThread, NULL, 0, NULL);
		}
	}
	else
	{
		Broodwar->printf("You typed '%s'!", text.c_str());
		Broodwar->sendText("%s", text.c_str());
	}
}


void KillAll::drawPaths()
{
	//for (set<Unit*>::const_iterator it = BWAPI::Broodwar->self()->getUnits().begin(); it != Broodwar->self()->getUnits().end(); it++) 
	for (auto unit : BWAPI::Broodwar->self()->getUnits())
	{
		if (unit->getType() != UnitTypes::Protoss_Interceptor)
		{
			BWAPI::Position point1 = unit->getPosition();
			BWAPI::Position point2 = unit->getTargetPosition();

			Color color = Colors::Cyan;
			if (unit->getOrder() == Orders::AttackUnit)
			{
				color = Colors::Red;
			}

			Broodwar->drawLine(CoordinateType::Map, point1.x, point1.y, point2.x, point2.y, color);

		}
	}
}


void KillAll::onNukeDetect(BWAPI::Position target)
{
	if (target != Positions::Unknown)
		Broodwar->printf("Nuclear Launch Detected at (%d,%d)", target.x, target.y);
	else
		Broodwar->printf("Nuclear Launch Detected");
}

void KillAll::onUnitDiscover(BWAPI::Unit unit)
{

}

void KillAll::onUnitEvade(BWAPI::Unit unit)
{

}

void KillAll::onUnitShow(BWAPI::Unit unit)
{
	if (unit->getType() == BWAPI::UnitTypes::Zerg_Egg || unit->getType() == BWAPI::UnitTypes::Zerg_Larva)
		return;

	InformationManager::Instance().onUnitShow(unit);
	//for initial 
	//ScoutManager::Instance().onUnitShow(unit);
	WorkerManager::Instance().onUnitShow(unit);
	//for first overlord
	if (unit->getPlayer() == BWAPI::Broodwar->self() && (unit->getType() == BWAPI::UnitTypes::Zerg_Zergling || unit->getType() == BWAPI::UnitTypes::Zerg_Overlord))
	{
		AttackManager::Instance().onUnitMorph(unit);
	}
}

void KillAll::onUnitHide(BWAPI::Unit unit)
{
	
}

void KillAll::onUnitCreate(BWAPI::Unit unit)
{

}

void KillAll::onUnitDestroy(BWAPI::Unit unit)
{
	if (unit->getType() == BWAPI::UnitTypes::Zerg_Egg || unit->getType() == BWAPI::UnitTypes::Zerg_Larva)
		return;
		
	// All information.
	InformationManager::Instance().onUnitDestroy(unit);

	// myself
	if ( unit->getPlayer() == BWAPI::Broodwar->self())
	{
		ProductionManager::Instance().onUnitDestroy(unit);
		WorkerManager::Instance().onUnitDestroy(unit);
		//ScoutManager::Instance().onUnitDestroy(unit);
		if (!unit->getType().isBuilding() && !unit->getType().isWorker())
		{
			AttackManager::Instance().onUnitDestroy(unit);
		}
	}
	// otehr side
	else if (unit->getPlayer() == BWAPI::Broodwar->enemy())
	{
		AttackManager::Instance().onEnemyUnitDestroy(unit);
	}
}

void KillAll::onUnitMorph(BWAPI::Unit unit)
{
	if (unit->getType() == BWAPI::UnitTypes::Zerg_Egg || unit->getType() == BWAPI::UnitTypes::Zerg_Larva)
		return;

	InformationManager::Instance().onUnitMorph(unit);
	if (unit->getPlayer() == BWAPI::Broodwar->self())
	{
		WorkerManager::Instance().onUnitMorph(unit);
		//ScoutManager::Instance().onUnitMorph(unit);
		if (!unit->getType().isBuilding() && !unit->getType().isWorker())
		{
			AttackManager::Instance().onUnitMorph(unit);
		}
	}

	// Here is not consider the other side.
}


void KillAll::onUnitComplete(BWAPI::Unit unit)
{

}


DWORD WINAPI AnalyzeThread()
{
	BWTA::analyze();

	BOOST_FOREACH(BWAPI::Unit u, BWAPI::Broodwar->self()->getUnits())
	{
		if (u->getType().isResourceDepot())
			InformationManager::Instance().addOccupiedRegionsDetail(BWTA::getRegion(BWAPI::Broodwar->self()->getStartLocation()), BWAPI::Broodwar->self(), u);
	}

	analyzed = true;
	analysis_just_finished = true;
	return 0;
}

void KillAll::drawStats()
{
	// Basement draw circles
	/*for (auto localUnit : InformationManager::Instance().getOurAllBaseUnit())
	{
		BWAPI::Broodwar->drawCircleMap(localUnit->getPosition(), 32 * 10, BWAPI::Colors::Yellow);
	}*/

	BWAPI::Unitset myUnits = BWAPI::Broodwar->self()->getUnits();
	Broodwar->drawTextScreen(5, 0, "I have %d units:", purple, myUnits.size());
	std::map<UnitType, int> unitTypeCounts;
	//for (std::set<Unit*>::iterator i = myUnits.begin(); i != myUnits.end(); i++)
	for (auto unit : myUnits)
	{
		if (!unit->getType().isBuilding() && unit->getType().canAttack() && !unit->getType().isSpecialBuilding() && !unit->getType().isFlyingBuilding())
		{
			int unitWidth = unit->getType().tileWidth() * 32;
			int unitHeight = unit->getType().tileHeight() * 32 / 8;
			BWAPI::Position unitPosition = unit->getPosition();
			BWAPI::Broodwar->drawBoxMap(unitPosition.x - unitWidth / 2, unitPosition.y + unitHeight / 2, unitPosition.x + unitWidth / 2, unitPosition.y - unitHeight / 2, BWAPI::Colors::Red, true);
			double healthPercent = double(unit->getHitPoints()) / unit->getType().maxHitPoints();
			BWAPI::Broodwar->drawBoxMap(unitPosition.x - unitWidth / 2, unitPosition.y + unitHeight / 2, unitPosition.x - unitWidth / 2 + int(unitWidth * healthPercent), unitPosition.y - unitHeight / 2, BWAPI::Colors::Green, true);
			/*
			if (unit->isSelected())
			{
				BWAPI::Broodwar->printf("Previous Command Frame=%d Pos=(%d, %d) type=%d", unit->getLastCommandFrame(), unit->getLastCommand().getTargetPosition().x / 32, unit->getLastCommand().getTargetPosition().y / 32, unit->getLastCommand().getType());
				BWAPI::Broodwar->drawLineMap(unit->getPosition().x, unit->getPosition().y, unit->getLastCommand().getTargetPosition().x, unit->getLastCommand().getTargetPosition().y, BWAPI::Colors::Green);
				BWAPI::Broodwar->drawCircleMap(unit->getLastCommand().getTargetPosition().x, unit->getLastCommand().getTargetPosition().y, 8, BWAPI::Colors::Green, true);
			}*/
		}

		if (unitTypeCounts.find(unit->getType()) == unitTypeCounts.end())
		{
			unitTypeCounts.insert(std::make_pair(unit->getType(), 0));
		}
		unitTypeCounts.find(unit->getType())->second++;
	}
	int line = 1;
	for (std::map<UnitType, int>::iterator i = unitTypeCounts.begin(); i != unitTypeCounts.end(); i++)
	{
		Broodwar->drawTextScreen(500, 16 * line, "- %d %ss", (*i).second, (*i).first.getName().c_str());
		line++;
	}
	// draw the map tile position at map
	Broodwar->drawTextScreen(BWAPI::Broodwar->getMousePosition().x + 20, BWAPI::Broodwar->getMousePosition().y + 20, "%d %d", (BWAPI::Broodwar->getScreenPosition().x + BWAPI::Broodwar->getMousePosition().x) / TILE_SIZE, (BWAPI::Broodwar->getScreenPosition().y + BWAPI::Broodwar->getMousePosition().y) / TILE_SIZE);
}

void KillAll::drawBullets()
{
	BWAPI::Bulletset bullets = Broodwar->getBullets();
	//for (std::set<Bullet*>::iterator i = bullets.begin(); i != bullets.end(); i++)
	for (auto bullet : bullets)
	{
		Position p = bullet->getPosition();
		double velocityX = bullet->getVelocityX();
		double velocityY = bullet->getVelocityY();
		if (bullet->getPlayer() == Broodwar->self())
		{
			Broodwar->drawLineMap(p.x, p.y, p.x + (int)velocityX, p.y + (int)velocityY, Colors::Green);
			Broodwar->drawTextMap(p.x, p.y, "\x07%s", bullet->getType().getName().c_str());
		}
		else
		{
			Broodwar->drawLineMap(p.x, p.y, p.x + (int)velocityX, p.y + (int)velocityY, Colors::Red);
			Broodwar->drawTextMap(p.x, p.y, "\x06%s", bullet->getType().getName().c_str());
		}
	}
}


void KillAll::drawVisibilityData()
{
	for (int x = 0; x<Broodwar->mapWidth(); x++)
	{
		for (int y = 0; y<Broodwar->mapHeight(); y++)
		{
			if (Broodwar->isExplored(x, y))
			{
				if (Broodwar->isVisible(x, y))
					Broodwar->drawDotMap(x * 32 + 16, y * 32 + 16, Colors::Green);
				else
					Broodwar->drawDotMap(x * 32 + 16, y * 32 + 16, Colors::Blue);
			}
			else
				Broodwar->drawDotMap(x * 32 + 16, y * 32 + 16, Colors::Red);
		}
	}
}


void KillAll::drawTerrainData()
{
	Broodwar->drawTextScreen(5, 0, "\x04Starts: %d Bases: %d Enemy: %s Frames: %d (%d:%s%d) Map: %s", BWTA::getStartLocations().size(), BWTA::getBaseLocations().size(), Broodwar->enemy()->getRace().getName().c_str(), Broodwar->getFrameCount(), Broodwar->getFrameCount() / (24 * 60), (Broodwar->elapsedTime() % 60 < 10) ? "0" : "", Broodwar->elapsedTime() % 60, Broodwar->mapName().c_str());

	//we will iterate through all the base locations, and draw their outlines.
	//for (std::set<BWTA::BaseLocation*>::const_iterator i = BWTA::getBaseLocations().begin(); i != BWTA::getBaseLocations().end(); i++)
	for (auto i : BWTA::getBaseLocations())
	{
		TilePosition p = i->getTilePosition();
		Position c = i->getPosition();

		//draw outline of center location
		Broodwar->drawBox(CoordinateType::Map, p.x * 32, p.y * 32, p.x * 32 + 4 * 32, p.y * 32 + 3 * 32, Colors::Blue, false);

		//draw a circle at each mineral patch
		for (auto j : i->getStaticMinerals())
		{
			Position q = j->getInitialPosition();
			Broodwar->drawCircle(CoordinateType::Map, q.x, q.y, 30, Colors::Cyan, false);
		}

		//draw the outlines of vespene geysers
		//for (std::set<BWAPI::Unit>::const_iterator j = (*i)->getGeysers().begin(); j != (*i)->getGeysers().end(); j++)
		for (auto j : i->getGeysers())
		{
			TilePosition q = j->getInitialTilePosition();
			Broodwar->drawBox(CoordinateType::Map, q.x * 32, q.y * 32, q.x * 32 + 4 * 32, q.y * 32 + 2 * 32, Colors::Orange, false);
		}

		//if this is an island expansion, draw a yellow circle around the base location
		if (i->isIsland())
			Broodwar->drawCircle(CoordinateType::Map, c.x, c.y, 80, Colors::Yellow, false);
	}

	//we will iterate through all the regions and draw the polygon outline of it in green.
	//for (std::set<BWTA::Region*>::const_iterator r = BWTA::getRegions().begin(); r != BWTA::getRegions().end(); r++)
	for (auto r : BWTA::getRegions())
	{
		BWTA::Polygon p = r->getPolygon();
		for (int j = 0; j<(int)p.size(); j++)
		{
			Position point1 = p[j];
			Position point2 = p[(j + 1) % p.size()];
			Broodwar->drawLine(CoordinateType::Map, point1.x, point1.y, point2.x, point2.y, Colors::Green);
		}
	}

	//we will visualize the chokepoints with red lines
	//for (std::set<BWTA::Region*>::const_iterator r = BWTA::getRegions().begin(); r != BWTA::getRegions().end(); r++)
	for (auto r : BWTA::getRegions())
	{
		//for (std::set<BWTA::Chokepoint*>::const_iterator c = (*r)->getChokepoints().begin(); c != (*r)->getChokepoints().end(); c++)
		for (auto c : r->getChokepoints())
		{
			Position point1 = c->getSides().first;
			Position point2 = c->getSides().second;
			Broodwar->drawLine(CoordinateType::Map, point1.x, point1.y, point2.x, point2.y, Colors::Red);
		}
	}
}


void KillAll::showPlayers()
{
	BWAPI::Playerset players = Broodwar->getPlayers();
	//for (std::set<Player*>::iterator i = players.begin(); i != players.end(); i++)
	for (auto i : players)
	{
		Broodwar->printf("Player [%d]: %s is in force: %s", i->getID(), i->getName().c_str(), i->getForce()->getName().c_str());
	}
}

void KillAll::showForces()
{
	BWAPI::Forceset forces = Broodwar->getForces();
	for (auto i : forces)
	{
		BWAPI::Playerset players = i->getPlayers();
		Broodwar->printf("Force %s has the following players:", i->getName().c_str());
		for (auto j : players)
		{
			Broodwar->printf("  - Player [%d]: %s", j->getID(), j->getName().c_str());
		}
	}
}




