#pragma once

#include "Common.h"
#include "MapGrid.h"

#ifdef USING_VISUALIZATION_LIBRARIES
#include "Visualizer.h"
#endif

#include "GameState.h"
#include "Game.h"
#include "Unit.h"
#include "AllPlayers.h"
#include "InformationManager.h"

namespace UAlbertaBot
{
	class CombatSimulation
	{
		SparCraft::GameState _state;

	public:

		CombatSimulation();

		void setCombatUnits(const BWAPI::Position & center, const int radius);

		SparCraft::ScoreType simulateCombat();

		const SparCraft::Unit			getSparCraftUnit(const UnitInfo & ui) const;
		const SparCraft::Unit			getSparCraftUnit(BWAPI::Unit unit) const;
		const SparCraft::GameState &	getSparCraftState() const;

		const SparCraft::IDType getSparCraftPlayerID(BWAPI::Player player) const;

		void logState(const SparCraft::GameState & state);
	};
}