#pragma once
#include "Common.h"
#include "ProductionManager.h"
#include "StrategyManager.h"
#include "InformationManager.h"
#include "UnitState.h"


// SparCraft include
#include "UnitUtil.h"
#include "SquadOrder.h"
#include "Squad.h"
#include "SquadData.h"
#include "ScoutManager.h"

struct AttackEnemyBase
{
	BWAPI::Position base;
	bool nowAttacking;
	int priority;
	int groundNextAttackTime;
	int airNextAttackTime;

	AttackEnemyBase(BWAPI::Position b, int p)
	{
		base = b;
		priority = p;
		groundNextAttackTime = 0;
		airNextAttackTime = 0;
		nowAttacking = false;
	}

	bool operator < (const AttackEnemyBase& u) const
	{
		if (priority < u.priority)
			return true;
		else
			return false;
	}
};


class AttackManager{
	//--------------------------------------------------
    //  SparCraft command  private member--   
	BWAPI::Unitset _validUnits;
	BWAPI::Unitset _combatUnits;
	BWAPI::Unitset _scoutUnits;
	BWAPI::Position _overlord_survey_position;

	bool  _initialScoutSet;
	bool  _scoutAlways;
	bool  _scoutWorker;
	bool  _scoutOverlord;
	bool  _initialized;
	bool  _goAggressive;
	UAlbertaBot::SquadData _squadData;

	// -------------------------------------------------



	std::vector<AttackEnemyBase>			attackPositions;
	BWAPI::Position							lastAttackPosition;
	int						updatPositionTime;
	int						defendAddSupply;

	AttackManager();
	bool					triggerZerglingBuilding;

	bool					isNeedDefend;
	bool					isNeedTacticDefend;
	bool					hasWorkerScouter;

	bool					zerglingHarassFlag;
	std::vector<BWAPI::Unit> unRallyArmy;
	BWAPI::Position			rallyPosition;

	std::set<BWAPI::Unit> enemyInvadeSet;

	BWAPI::Position			naturalChokePosition;
	BWAPI::Position			baseChokePosition;




	//--------------------------------------------------
	//  SparCraft command  private function--   
	void assignUnit(BWAPI::Unit unit, BWAPI::Unitset &set);
	bool isAssigned(BWAPI::Unit unit) const;
	BWAPI::Unit getAnyFreeWorker();
	BWAPI::Unit getAnyOverlord();

	void combatCommander(const BWAPI::Unitset &combatUnits);
	void initializeSquads();

	BWAPI::Position		getMainAttackLocation(const UAlbertaBot::Squad * squad);
	BWAPI::Position		getSurveyLocation();
	void				updateIdleSquad();
	void				updateDropSquads();
	bool				unitIsGoodToDrop(const BWAPI::Unit unit) const;
	void				updateScoutDefenseSquad();
	void				updateBaseDefenseSquads();
	int					numZerglingsInOurBase() const;
	bool				buildingRush() const;
	BWAPI::Unit			findClosestWorkerToTarget(BWAPI::Unitset & unitsToAssign, BWAPI::Unit target);
	void				updateDefenseSquadUnits(UAlbertaBot::Squad & defenseSquad, const size_t & flyingDefendersNeeded, const size_t & groundDefendersNeeded, bool pullWorkers);
	BWAPI::Unit			findClosestDefender(const UAlbertaBot::Squad & defenseSquad, BWAPI::Position pos, bool flyingDefender, bool pullWorkers);
	void				updateAttackSquads();
	void				updateSurveySquad();
	void				cancelDyingBuildings();


	// -------------------------------------------------

public:
	//--------------------------------------------------
	//  SparCraft command  public function--   
	void handleUnitAssignments();
	void setValidUnits();
	void setScoutUnits();
	void setCombatUnits();

	void goScoutAlways();
	void goScoutWorker();
	void goScoutOverlord();

	void setAggression(bool aggressive) { _goAggressive = aggressive; }
	BWAPI::Position getOverlordSurveyPosition(){ return _overlord_survey_position; }

	// -------------------------------------------------


	
	void					update();
	void					onUnitMorph(BWAPI::Unit unit);
	void					onUnitDestroy(BWAPI::Unit unit);
	void					onEnemyUnitDestroy(BWAPI::Unit unit);

	bool					isNeedRetreatDefend() { return isNeedTacticDefend; }
	bool					isUnderAttack() { return isNeedDefend; }
	
	static AttackManager&	Instance();

};

