# CherryPI

CherryPi is a TorchCraft Zerg bot developed by Facebook AI Research.
It uses bandits to select learn strategies that work against a given
opponent.

Since TorchCraft provides the interface used by the bot to communicate
with BWAPI, the bot is technically split into two parts: a
`CherryPi.dll` object that needs to be launched by BWAPI, and a
`CherryPi.exe` executable that should be launched before the game
starts, similarly to a BWAPIClient bot.

More information on TorchCraft can be found following these links:

* github.com/TorchCraft/TorchCraft
* https://arxiv.org/abs/1611.00625


For AIIDE, we have prepackaged TorchCraft inside the bot directory, so
that it's straightforward to compile all the requirements.


# Directory setup

```bash
# after zipping
[nantas@devfair014:~] tree CherryPi
CherryPi
├── AI
│   ├── opponents*.json  # many .json files
│   ├── run_proxy.bat
│   ├── CherryPi.dll
│   ├── CherryPi.exe
│   ├── czmq.dll
│   ├── libsodium.dll
│   ├── rttr_core.dll
│   └── libzmq.dll
├── CherryPi
│   └── # source files
└── README.md
```


## Requirements

* VisualStudio 2017 supplied with the Development Tools for C++ at
  installation time.
* Windows 10 SDK 10.0.15063.0 (installed by default with the VS 
  C++ developer tools).
* BWAPI 4.2.0.
* The ability for processes started by the Tournament Manager to
  open and bind sockets on port 11111 (to allow TorchCraft's ZMQ
  connection to work). 


## Installation

The following env variables are assumed to have been set:

* `BWAPI_DIR`, pointing to e.g. `C:\StarCraft\BWAPI`, that is a working
  BWAPI 4.2.0 installation.
* Copy czmq.dll, libsodium.dll, rttr_core.dll, and libzmq.dll into C:\StarCraft (or whichever
  path you have starcraft installed in). Leave them in AI/ too, as both the
  dll and the exe require them.

After installing VisualStudio 2017 (with the included C++ dev setup),
do the following:

```bash
# Open `Developer Command Prompt for VS 2017`.

# Get in CherryPi's source directory
$ cd /path/to/cherrypi/

# Compile the bot
$ cd VisualStudio
$ build.bat
```
