/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include <memory>
#include <string>

#include <torchcraft/client.h>

namespace fairrsh {

class OpenBwProcess;

class SelfPlayScenario {
 public:
  struct Pipe {
    Pipe();
    ~Pipe();

    int rfd, wfd;
  };

  SelfPlayScenario(
      std::string const& map,
      std::string const& race1,
      std::string const& race2);
  // ~SelfPlayScenario();

  std::shared_ptr<torchcraft::Client> makeClient1(
      torchcraft::Client::Options opts = torchcraft::Client::Options()) const;
  std::shared_ptr<torchcraft::Client> makeClient2(
      torchcraft::Client::Options opts = torchcraft::Client::Options()) const;

 private:
  std::shared_ptr<torchcraft::Client> makeClient(
      std::shared_ptr<OpenBwProcess> proc,
      torchcraft::Client::Options opts) const;

  std::shared_ptr<OpenBwProcess> proc1_;
  std::shared_ptr<OpenBwProcess> proc2_;
  Pipe pipe1_, pipe2_;
};

} // namespace fairrsh
