/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include <memory>
#include <string>

#include <torchcraft/client.h>

#include "fairrsh.h"

namespace fairrsh {

class OpenBwProcess;

class Scenario {
  RTTR_ENABLE()

 public:
  Scenario(std::string map, std::string race);

  std::shared_ptr<torchcraft::Client> makeClient(
      torchcraft::Client::Options opts = torchcraft::Client::Options()) const;

 protected:
  Scenario() = default;

  virtual std::shared_ptr<OpenBwProcess> startProcess() const;

  // This should be a unique_ptr, but that breaks using OpenBwProcess via
  // forward-declaration. Alternatively, we could declare destructors, move
  // constructors etc. in the source file...
  std::shared_ptr<OpenBwProcess> proc_;

 private:
  std::string map_;
  std::string race_;
};

class MeleeScenario : public Scenario {
  RTTR_ENABLE(Scenario)

 public:
  MeleeScenario(
      std::string map,
      std::string myRace,
      std::string enemyRace = std::string());

 protected:
  virtual std::shared_ptr<OpenBwProcess> startProcess() const override;

 private:
  std::string map_;
  std::string myRace_;
  std::string enemyRace_;
};

} // namespace fairrsh
