/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include <atomic>
#include <cstdio>
#include <future>
#include <string>
#include <vector>

namespace fairrsh {

enum class AiModule {
  BWEnv,
  Steamhammer_123,
  UAlbertaBot_aiide_2015,
  BlackCrow,
};

/**
 * Launches and manages an OpenBW process.
 */
class OpenBwProcess {
 public:
  struct EnvVar {
    std::string key;
    std::string value;
    bool overwrite = false;
  };

  OpenBwProcess(AiModule module, std::vector<EnvVar> const& vars);
  ~OpenBwProcess();

  /// Returns the BWEnv port (if AI module is BWEnv)
  int port();

 private:
  void redirectOutput();

  FILE* pipe_;
  int pid_;
  int port_ = -1;
  std::future<int> portf_;
  std::promise<int> portp_;
  // Need to keep a variable alive for thread to continue running
  std::future<void> outputThread_;  
  std::atomic_bool running_;
};

} // namespace fairrsh
