/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "module.h"
#include "task.h"

namespace fairrsh {

class WorkerDefenceTask;

class WorkerDefenceModule : public Module {
  RTTR_ENABLE(Module)

 public:
  virtual ~WorkerDefenceModule() = default;

  virtual void step(State* state) override;

 protected:
  void checkState(State* state);
  void flee(State* state, std::shared_ptr<WorkerDefenceTask> task);
  void checkEnemyBuildings(State* state);
  // bool isScout(State* state, Unit* unit);
  void findBlindSpots(State* state);
  Position nextBlindSpot(State* state);
  void consumeUPC(State* state, UpcId upcId, std::shared_ptr<UPCTuple> upc);
  void createUPC(State* state, Unit* unit);
  void createUPCs(State* state);

  std::unordered_map<Unit*, int> timeout_;
  std::unordered_map<Unit*, int> prevCD_;
  std::unordered_set<Unit*> myWorkers_;
  std::unordered_set<Unit*> attackers_;
  std::unordered_set<Unit*> defenders_;
  std::unordered_map<Position, int> blindSpots_;
  // Unit* scout_ = nullptr;
};
}
