/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include <set>
#include <vector>

#include "module.h"
#include "unitsinfo.h"

namespace fairrsh {

/**
 * A bottom-level module that generates TorchCraft commands for all unambiguous
 * UPCS tuples.
 */
class UPCToCommandModule : public Module {
  RTTR_ENABLE(Module)

 public:
  UPCToCommandModule() {}
  virtual ~UPCToCommandModule() = default;

  virtual void step(State* s);

  /// Returns a human-readable text representation of the given command. This
  /// is helpful for logging.
  static std::string commandString(
      State* s,
      tc::Client::Command const& command);

 private:
  struct UPCToCommandState {
      std::set<const Unit*> commandToUnit;
      std::vector<tc::Client::Command> commands;
      std::vector<int> upcIds;
  };

  void checkDuplicateCommand(const Unit *unit, UPCToCommandState& upcToCommandState);
  void registerGameCommand(State *state, const Unit *unit, int upcId,
                           tc::Client::Command command,
                           UPCToCommandState& upcToCommandState);
  void temporaryDebugDrawing(State* state, UPCToCommandState& upcToCommandState);
  void postGameCommand(State *state, UPCToCommandState& upcToCommandState);
};

} // namespace fairrsh
