/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include "module.h"

#include <vector>

namespace fairrsh {

/**
 * A helper module for umm buildorder
 */
class UMMHelperModule : public Module {
  RTTR_ENABLE(Module)

 protected:
  std::vector<std::vector<std::pair<size_t, float>>> inputs_;
  std::vector<std::vector<float>> outputs_;

 public:
  virtual void setPlayer(Player *p) override;
  virtual void step(State* s) override;
  virtual void onGameEnd(State* s) override;
};

} // namespace fairrsh
