/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include "module.h"

namespace fairrsh {

struct UPCTuple;

/**
 * A top-level module that generates a single combined UPCS tuple for all active
 * units.
 */
class TopModule : public Module {
  RTTR_ENABLE(Module)

 public:
  TopModule() {}
  virtual ~TopModule() = default;

  virtual void step(State* s);

 private:
  std::shared_ptr<UPCTuple> upc_;
};

} // namespace fairrsh
