/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#include "state.h"

#include "modules/top.h"

namespace fairrsh {

RTTR_REGISTRATION {
  rttr::registration::class_<TopModule>("TopModule")(
      metadata("type", rttr::type::get<TopModule>()))
      .constructor();
}

void TopModule::step(State* state) {
  auto board = state->board();

  if (!upc_) {
    upc_ = std::make_shared<UPCTuple>();
    for (int i = 0; i < Command::MAX; i++) {
      upc_->command[i] = 1.0f / Command::MAX;
    }
    // TODO: uniform positions?
  }

  auto& myUnits = state->unitsInfo().myUnits();
  int n = myUnits.size();
  upc_->unit.clear();
  for (Unit* unit : myUnits) {
    upc_->unit[unit] = 1.0f / n;
  }

  // Check if UPC instance is still on blackboard
  if (board->upcsFrom(this).empty()) {
    board->postUPC(upc_, kRootUpcId, this);
  }
}

} // namespace fairrsh
