/**
 * Copyright (c) 2017-present, Facebook, Inc.
 * All rights reserved.
 */

#pragma once

#include "module.h"
#include "tilesinfo.h"

#include <random>

namespace fairrsh {

struct Unit;

/**
 * A tactics module that selects armies and priority targets to attack.
 */
class TacticsModule : public Module {
  RTTR_ENABLE(Module)

 public:
  virtual void step(State* s) override;

 protected:
  UpcId findSourceUpc(State* s);

  FrameNum lastProcess = 0;
  void process(State* state, int srcUpcId);

  std::vector<uint8_t> inBaseArea =
      std::vector<uint8_t>(TilesInfo::tilesWidth * TilesInfo::tilesHeight);
  FrameNum lastUpdateInBaseArea = 0;

  std::vector<uint16_t> fleeScore =
      std::vector<uint16_t>(TilesInfo::tilesWidth * TilesInfo::tilesHeight);
  FrameNum lastUpdateFleeScore = 0;

  std::unordered_map<Unit*, std::pair<int, Position>> searchAndDestroyTarget;
  std::unordered_map<Unit*, std::pair<int, Position>> scoutTarget;
  std::ranlux24 rngEngine{42};

  std::unordered_map<Unit*, int> noOrderUntil;
  std::unordered_map<Unit*, int> lastTargetInRange;
  std::unordered_map<Unit*, int> lastMove;
};

// This function is here because it is used in ABBOBase. This might not be the
// proper place to put it.
void updateInBaseArea(State* state, std::vector<uint8_t>& inBaseArea);

} // namespace fairrsh
